/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.sdk.EnrollCertRequestEntry;
import org.xipki.ca.sdk.EnrollCertsRequest;
import org.xipki.ca.sdk.EnrollOrPollCertsResponse;
import org.xipki.ca.sdk.EnrollOrPullCertResponseEntry;
import org.xipki.ca.sdk.SdkClient;
import org.xipki.ca.sdk.SdkClientConf;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.qa.ca.CaEnrollBenchEntry;
import org.xipki.util.Args;
import org.xipki.util.BenchmarkExecutor;

public class CaEnrollBenchmark
extends BenchmarkExecutor {
    private static final String CONf_FILE = "xipki/ca-qa/qa-benchmark-conf.json";
    private static final Logger LOG = LoggerFactory.getLogger(CaEnrollBenchmark.class);
    private final CaEnrollBenchEntry benchmarkEntry;
    private final AtomicLong index;
    private final SecureRandom random = new SecureRandom();
    private final int num;
    private final AtomicInteger processedRequests = new AtomicInteger(0);
    private final int maxRequests;
    private final SdkClient client;
    private final String caName;
    private final boolean caGenKeyPair;

    public CaEnrollBenchmark(String caName, CaEnrollBenchEntry benchmarkEntry, int maxRequests, int num, String description) throws Exception {
        super(description);
        this.caName = caName;
        this.maxRequests = maxRequests;
        this.num = Args.positive((int)num, (String)"num");
        this.benchmarkEntry = (CaEnrollBenchEntry)Args.notNull((Object)benchmarkEntry, (String)"benchmarkEntry");
        this.index = new AtomicLong(CaEnrollBenchmark.getSecureIndex());
        this.caGenKeyPair = benchmarkEntry.getSubjectPublicKeyInfo() == null;
        this.client = new SdkClient(SdkClientConf.readConfFromFile((String)CONf_FILE));
    }

    protected Runnable getTester() throws Exception {
        return new Tester();
    }

    protected long getRealAccount(long account) {
        return (long)this.num * account;
    }

    public EnrollCertsRequest nextCertRequest() throws Exception {
        int num;
        if (this.maxRequests > 0 && (num = this.processedRequests.getAndAdd(1)) >= this.maxRequests) {
            return null;
        }
        ArrayList<EnrollCertRequestEntry> entries = new ArrayList<EnrollCertRequestEntry>(this.num);
        for (int i = 0; i < this.num; ++i) {
            long thisIndex = this.index.getAndIncrement();
            EnrollCertRequestEntry entry = new EnrollCertRequestEntry();
            entry.setSubject(new X500NameType(this.benchmarkEntry.getX500Name(thisIndex)));
            if (!this.caGenKeyPair) {
                entry.setSubjectPublicKey(this.benchmarkEntry.getSubjectPublicKeyInfo().getEncoded());
            }
            entry.setCertprofile(this.benchmarkEntry.getCertprofile());
            entry.setCertReqId(BigInteger.valueOf(i + 1));
            entries.add(entry);
        }
        EnrollCertsRequest req = new EnrollCertsRequest();
        req.setTransactionId(Hex.toHexString((byte[])this.randomBytes(8)));
        req.setEntries(entries);
        return req;
    }

    private void parseEnrollCertResult(EnrollOrPollCertsResponse response, int numCerts) throws Exception {
        int n;
        List entries = response.getEntries();
        int n2 = n = entries == null ? 0 : entries.size();
        if (n != numCerts) {
            throw new Exception("expected " + numCerts + " CertResponse, but returned " + n);
        }
        for (int i = 0; i < numCerts; ++i) {
            EnrollOrPullCertResponseEntry certResp = (EnrollOrPullCertResponseEntry)entries.get(i);
            if (certResp.getError() == null) continue;
            throw new Exception("CertReqId " + certResp.getId() + ": server returned PKIStatus: " + certResp.getError());
        }
    }

    private byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        this.random.nextBytes(bytes);
        return bytes;
    }

    class Tester
    implements Runnable {
        @Override
        public void run() {
            while (!CaEnrollBenchmark.this.stop() && CaEnrollBenchmark.this.getErrorAccout() < 1L) {
                try {
                    EnrollCertsRequest certReq = CaEnrollBenchmark.this.nextCertRequest();
                    if (certReq == null) break;
                    this.testNext(certReq);
                    CaEnrollBenchmark.this.account(1L, 0L);
                }
                catch (Exception ex) {
                    LOG.warn("exception", (Throwable)ex);
                    CaEnrollBenchmark.this.account(1L, 1L);
                }
                catch (Error ex) {
                    LOG.warn("unexpected exception", (Throwable)ex);
                    CaEnrollBenchmark.this.account(1L, 1L);
                }
            }
        }

        private void testNext(EnrollCertsRequest request) throws Exception {
            EnrollOrPollCertsResponse sdkResponse = CaEnrollBenchmark.this.client.enrollCerts(CaEnrollBenchmark.this.caName, request);
            CaEnrollBenchmark.this.parseEnrollCertResult(sdkResponse, CaEnrollBenchmark.this.num);
        }
    }
}

