/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x509.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.certprofile.xijson.XijsonCertprofile;
import org.xipki.ca.certprofile.xijson.conf.X509ProfileType;
import org.xipki.qa.ValidationIssue;
import org.xipki.qa.ValidationResult;
import org.xipki.qa.ca.IssuerInfo;
import org.xipki.qa.ca.PublicKeyChecker;
import org.xipki.qa.ca.SubjectChecker;
import org.xipki.qa.ca.extn.ExtensionsChecker;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.Validity;

public class CertprofileQa {
    private static final Logger LOG = LoggerFactory.getLogger(CertprofileQa.class);
    private static final Instant MAX_CERT_TIME = ZonedDateTime.of(9999, 12, 31, 23, 59, 59, 0, ZoneOffset.UTC).toInstant();
    private static final Instant EPOCHTIME_2050010100 = ZonedDateTime.of(2050, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC).toInstant();
    private final SubjectChecker subjectChecker;
    private final PublicKeyChecker publicKeyChecker;
    private final ExtensionsChecker extensionsChecker;
    private final XijsonCertprofile certprofile;

    public CertprofileQa(String data) throws CertprofileException {
        this(StringUtil.toUtf8Bytes((String)((String)Args.notNull((Object)data, (String)"data"))));
    }

    public CertprofileQa(byte[] dataBytes) throws CertprofileException {
        Args.notNull((Object)dataBytes, (String)"dataBytes");
        try {
            X509ProfileType conf = X509ProfileType.parse((InputStream)new ByteArrayInputStream(dataBytes));
            this.certprofile = new XijsonCertprofile();
            this.certprofile.initialize(conf);
            this.publicKeyChecker = new PublicKeyChecker(this.certprofile.getKeyAlgorithms());
            this.subjectChecker = new SubjectChecker(this.certprofile.getSubjectControl());
            this.extensionsChecker = new ExtensionsChecker(conf, this.certprofile);
        }
        catch (RuntimeException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            throw new CertprofileException("RuntimeException thrown while initializing certprofile: " + ex.getMessage());
        }
    }

    public ValidationResult checkCert(byte[] certBytes, IssuerInfo issuerInfo, X500Name requestedSubject, SubjectPublicKeyInfo requestedPublicKey, Extensions requestedExtensions) {
        int size;
        Args.notNull((Object)certBytes, (String)"certBytes");
        Args.notNull((Object)issuerInfo, (String)"issuerInfo");
        Args.notNull((Object)requestedSubject, (String)"requestedSubject");
        Args.notNull((Object)requestedPublicKey, (String)"requestedPublicKey");
        LinkedList<ValidationIssue> resultIssues = new LinkedList<ValidationIssue>();
        ValidationIssue issue = new ValidationIssue("X509.SIZE", "certificate size");
        resultIssues.add(issue);
        certBytes = X509Util.toDerEncoded((byte[])certBytes);
        Integer maxSize = this.certprofile.getMaxSize();
        if (maxSize != 0 && (size = certBytes.length) > maxSize) {
            issue.setFailureMessage(String.format("certificate exceeds the maximal allowed size: %d > %d", size, maxSize));
        }
        issue = new ValidationIssue("X509.ENCODING", "certificate encoding");
        resultIssues.add(issue);
        Certificate bcCert = Certificate.getInstance((Object)certBytes);
        TBSCertificate tbsCert = bcCert.getTBSCertificate();
        X509Cert cert = new X509Cert(bcCert, certBytes);
        issue = new ValidationIssue("X509.VERSION", "certificate version");
        resultIssues.add(issue);
        int versionNumber = tbsCert.getVersion().intPositiveValueExact();
        Certprofile.X509CertVersion expVersion = this.certprofile.getVersion();
        if (versionNumber != expVersion.getVersionNumber()) {
            issue.setFailureMessage("is '" + versionNumber + "' but expected '" + expVersion.getVersionNumber() + "'");
        }
        issue = new ValidationIssue("X509.serialNumber", "certificate serial number");
        resultIssues.add(issue);
        BigInteger serialNumber = tbsCert.getSerialNumber().getValue();
        if (serialNumber.signum() != 1) {
            issue.setFailureMessage("not positive");
        } else if (serialNumber.bitLength() >= 160) {
            issue.setFailureMessage("serial number has more than 20 octets");
        }
        List signatureAlgorithms = this.certprofile.getSignatureAlgorithms();
        if (CollectionUtil.isNotEmpty((Collection)signatureAlgorithms)) {
            issue = new ValidationIssue("X509.SIGALG", "signature algorithm");
            resultIssues.add(issue);
            AlgorithmIdentifier sigAlgId = bcCert.getSignatureAlgorithm();
            AlgorithmIdentifier tbsSigAlgId = tbsCert.getSignature();
            if (!tbsSigAlgId.equals((Object)sigAlgId)) {
                issue.setFailureMessage("Certificate.tbsCertificate.signature != Certificate.signatureAlgorithm");
            }
            if (!issue.isFailed()) {
                try {
                    SignAlgo signAlgo = SignAlgo.getInstance((AlgorithmIdentifier)sigAlgId);
                    if (!signatureAlgorithms.contains(signAlgo)) {
                        issue.setFailureMessage("signatureAlgorithm '" + signAlgo + "' is not allowed");
                    }
                    if (!issue.isFailed() && !sigAlgId.equals((Object)signAlgo.getAlgorithmIdentifier())) {
                        issue.setFailureMessage("signatureAlgorithm has invalid content");
                    }
                }
                catch (NoSuchAlgorithmException ex) {
                    issue.setFailureMessage("unsupported signature algorithm " + sigAlgId.getAlgorithm().getId());
                }
            }
        }
        issue = new ValidationIssue("X509.NOTBEFORE.ENCODING", "notBefore encoding");
        CertprofileQa.checkTime(tbsCert.getStartDate(), issue);
        issue = new ValidationIssue("X509.NOTAFTER.ENCODING", "notAfter encoding");
        CertprofileQa.checkTime(tbsCert.getStartDate(), issue);
        if (this.certprofile.getNotBeforeOption().getMidNightTimeZone() != null) {
            issue = new ValidationIssue("X509.NOTBEFORE", "notBefore midnight");
            resultIssues.add(issue);
            ZonedDateTime cal = ZonedDateTime.ofInstant(cert.getNotBefore(), ZoneOffset.UTC);
            int minute = cal.getMinute();
            int second = cal.getSecond();
            if (minute != 0 || second != 0) {
                issue.setFailureMessage(" '" + cert.getNotBefore() + "' is not midnight time");
            }
        }
        issue = new ValidationIssue("X509.VALIDITY", "cert validity");
        resultIssues.add(issue);
        if (cert.getNotAfter().isBefore(cert.getNotBefore())) {
            issue.setFailureMessage("notAfter may not be before notBefore");
        } else if (cert.getNotBefore().isBefore(issuerInfo.getCaNotBefore())) {
            issue.setFailureMessage("notBefore may not be before CA's notBefore");
        } else if (this.certprofile.hasNoWellDefinedExpirationDate()) {
            if (MAX_CERT_TIME.getEpochSecond() != cert.getNotAfter().getEpochSecond()) {
                issue.setFailureMessage("cert notAfter != 99991231235959Z");
            }
        } else {
            Validity validity = this.certprofile.getValidity();
            Instant expectedNotAfter = validity.add(cert.getNotBefore());
            if (expectedNotAfter.isAfter(MAX_CERT_TIME)) {
                expectedNotAfter = MAX_CERT_TIME;
            }
            if (issuerInfo.isCutoffNotAfter() && expectedNotAfter.isAfter(issuerInfo.getCaNotAfter())) {
                expectedNotAfter = issuerInfo.getCaNotAfter();
            }
            if (Math.abs(expectedNotAfter.getEpochSecond() - cert.getNotAfter().getEpochSecond()) > 60L) {
                issue.setFailureMessage("cert validity is not within " + validity);
            }
        }
        resultIssues.addAll(this.publicKeyChecker.checkPublicKey(bcCert.getSubjectPublicKeyInfo(), requestedPublicKey));
        issue = new ValidationIssue("X509.SIG", "whether certificate is signed by CA");
        resultIssues.add(issue);
        try {
            cert.verify(issuerInfo.getCert().getPublicKey(), "BC");
        }
        catch (NoSuchAlgorithmException ex) {
            try {
                cert.verify(issuerInfo.getCert().getPublicKey());
            }
            catch (Exception ex1) {
                issue.setFailureMessage("invalid signature");
            }
        }
        catch (Exception ex) {
            issue.setFailureMessage("invalid signature");
        }
        issue = new ValidationIssue("X509.ISSUER", "certificate issuer");
        resultIssues.add(issue);
        if (!cert.getIssuer().equals((Object)issuerInfo.getCert().getSubject())) {
            issue.setFailureMessage("issue in certificate does not equal the subject of CA certificate");
        }
        resultIssues.addAll(this.subjectChecker.checkSubject(bcCert.getSubject(), requestedSubject));
        issue = new ValidationIssue("X509.IssuerUniqueID", "issuerUniqueID");
        resultIssues.add(issue);
        if (tbsCert.getIssuerUniqueId() != null) {
            issue.setFailureMessage("is present but not permitted");
        }
        issue = new ValidationIssue("X509.SubjectUniqueID", "subjectUniqueID");
        resultIssues.add(issue);
        if (tbsCert.getSubjectUniqueId() != null) {
            issue.setFailureMessage("is present but not permitted");
        }
        issue = new ValidationIssue("X509.GrantedSubject", "grantedSubject");
        resultIssues.add(issue);
        resultIssues.addAll(this.extensionsChecker.checkExtensions(bcCert, issuerInfo, requestedExtensions, requestedSubject));
        return new ValidationResult(resultIssues);
    }

    private static void checkTime(Time time, ValidationIssue issue) {
        ASN1Primitive asn1Time = time.toASN1Primitive();
        if (time.getDate().toInstant().isBefore(EPOCHTIME_2050010100)) {
            if (!(asn1Time instanceof ASN1UTCTime)) {
                issue.setFailureMessage("not encoded as UTCTime");
            }
        } else if (!(asn1Time instanceof ASN1GeneralizedTime)) {
            issue.setFailureMessage("not encoded as GeneralizedTime");
        }
    }
}

