/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECPoint;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.EdECConstants;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.DSAParameterCache;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class FillKeytool
implements AutoCloseable {
    private static final int ENCALG_AES128GCM = 1;
    private static final int ENCALG_AES192GCM = 2;
    private static final int ENCALG_AES256GCM = 3;
    protected final DataSourceWrapper datasource;

    public FillKeytool(DataSourceFactory datasourceFactory, PasswordResolver passwordResolver, String dbConfFile) throws PasswordResolverException, IOException {
        try (InputStream dbConfStream = Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)dbConfFile), new String[0]), new OpenOption[0]);){
            this.datasource = datasourceFactory.createDataSource("ds-" + dbConfFile, dbConfStream, passwordResolver);
        }
    }

    @Override
    public void close() {
        if (this.datasource != null) {
            this.datasource.close();
        }
    }

    public void execute(int numKeypairs, String encAlg, char[] password) throws Exception {
        int keyLength;
        int encAlgCode;
        Args.notNull((Object)password, (String)"password");
        if (encAlg == null || "AES128/GCM".equalsIgnoreCase(encAlg)) {
            encAlgCode = 1;
            keyLength = 128;
        } else if ("AES192/GCM".equalsIgnoreCase(encAlg)) {
            encAlgCode = 2;
            keyLength = 192;
        } else if ("AES256/GCM".equalsIgnoreCase(encAlg)) {
            encAlgCode = 3;
            keyLength = 256;
        } else {
            throw new IllegalArgumentException("invalid encAlg " + encAlg);
        }
        PBEKeySpec spec = new PBEKeySpec(password, "ENC".getBytes(StandardCharsets.UTF_8), 10000, keyLength);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        SecretKeySpec key = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        Connection conn = this.datasource.getConnection();
        PreparedStatement ps = null;
        String sql = null;
        try {
            ASN1ObjectIdentifier[] curves;
            sql = "DELETE FROM KEYPOOL";
            this.datasource.createStatement(conn).executeUpdate(sql);
            sql = "DELETE FROM KEYSPEC";
            this.datasource.createStatement(conn).executeUpdate(sql);
            LinkedList<String> keyspecs = new LinkedList<String>(Arrays.asList("DSA/1024/160", "DSA/2048/224", "DSA/2048/256", "DSA/3072/256", "RSA/2048", "RSA/3072", "RSA/4096", "ED25519", "ED448", "X25519", "X448"));
            for (ASN1ObjectIdentifier curve : curves = new ASN1ObjectIdentifier[]{SECObjectIdentifiers.secp256r1, SECObjectIdentifiers.secp384r1, SECObjectIdentifiers.secp521r1, TeleTrusTObjectIdentifiers.brainpoolP256r1, TeleTrusTObjectIdentifiers.brainpoolP384r1, TeleTrusTObjectIdentifiers.brainpoolP512r1, GMObjectIdentifiers.sm2p256v1}) {
                keyspecs.add("EC/" + curve.getId());
            }
            HashMap<String, Integer> keyspecToIdMap = new HashMap<String, Integer>();
            int incrementKid = 1;
            for (String keyspec : keyspecs) {
                keyspecToIdMap.put(keyspec, incrementKid++);
            }
            sql = "INSERT INTO KEYSPEC (ID,KEYSPEC) VALUES (?,?)";
            ps = this.datasource.prepareStatement(sql);
            for (String keyspec : keyspecs) {
                int kid = (Integer)keyspecToIdMap.get(keyspec);
                ps.setInt(1, kid);
                ps.setString(2, keyspec);
                ps.addBatch();
            }
            ps.executeBatch();
            ps = null;
            sql = "INSERT INTO KEYPOOL (ID,KID,SHARD_ID,ENC_ALG,ENC_META,DATA) VALUES(?,?,?,?,?,?)";
            SecureRandom rnd = new SecureRandom();
            ps = this.datasource.prepareStatement(sql);
            int id = 1;
            String[] rsaKeyspecs = new String[]{"RSA/2048", "RSA/3072", "RSA/4096"};
            HashMap rsaKeysMap = new HashMap();
            for (String keyspec : rsaKeyspecs) {
                String fn = "/keypool/" + keyspec.replace('/', '_') + ".txt";
                try (InputStream in = FillKeytool.class.getResourceAsStream(fn);){
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    ArrayList<byte[]> keys = new ArrayList<byte[]>(100);
                    rsaKeysMap.put(keyspec, keys);
                    while ((line = reader.readLine()) != null) {
                        if (!StringUtil.isNotBlank((String)line)) continue;
                        keys.add(Base64.decodeFast((String)line));
                    }
                }
            }
            for (String keyspec : keyspecs) {
                int kid = (Integer)keyspecToIdMap.get(keyspec);
                String[] tokens = keyspec.split("/");
                String name = keyspec;
                if (tokens[0].equalsIgnoreCase("EC")) {
                    String curveName = AlgorithmUtil.getCurveName((ASN1ObjectIdentifier)new ASN1ObjectIdentifier(tokens[1]));
                    name = name + " (" + curveName + ")";
                }
                System.out.println(name + ":");
                boolean rsa = keyspec.startsWith("RSA/");
                System.out.println("\t" + (rsa ? "loading " : "generating ") + numKeypairs + " keypairs");
                long start = Clock.systemUTC().millis();
                List rsaKeys = null;
                if (rsa) {
                    rsaKeys = (List)rsaKeysMap.get(keyspec);
                }
                for (int i = 0; i < numKeypairs; ++i) {
                    byte[] keyInfo = rsa ? (byte[])rsaKeys.get(i % rsaKeys.size()) : FillKeytool.generateKeypair(keyspec, rnd).getEncoded();
                    byte[] nonce = new byte[12];
                    rnd.nextBytes(nonce);
                    GCMParameterSpec gcmSpec = new GCMParameterSpec(128, nonce);
                    cipher.init(1, (Key)key, gcmSpec);
                    byte[] encryptedData = cipher.doFinal(keyInfo);
                    int idx = 1;
                    ps.setInt(idx++, id++);
                    ps.setInt(idx++, kid);
                    ps.setInt(idx++, 0);
                    ps.setInt(idx++, encAlgCode);
                    ps.setString(idx++, Base64.encodeToString((byte[])nonce));
                    ps.setString(idx, Base64.encodeToString((byte[])encryptedData));
                    ps.addBatch();
                    if (i != numKeypairs - 1 && i % 100 != 0) continue;
                    ps.executeBatch();
                }
                long duration = Clock.systemUTC().millis() - start;
                System.out.println("\t" + (rsa ? "loaded " : "generated ") + numKeypairs + " keypairs, took " + duration + " ms");
            }
        }
        catch (SQLException ex) {
            try {
                throw this.datasource.translate(sql, ex);
            }
            catch (Throwable throwable) {
                this.datasource.releaseResources(ps, null, false);
                this.datasource.returnConnection(conn);
                throw throwable;
            }
        }
        this.datasource.releaseResources((Statement)ps, null, false);
        this.datasource.returnConnection(conn);
    }

    private static PrivateKeyInfo generateKeypair(String keyspec, SecureRandom random) throws Exception {
        String type;
        String[] tokens = keyspec.split("/");
        switch (type = tokens[0]) {
            case "RSA": {
                int keysize = Integer.parseInt(tokens[1]);
                if (keysize > 4096) {
                    throw new XiSecurityException("keysize too large");
                }
                KeyPair kp = KeyUtil.generateRSAKeypair((int)keysize, null, (SecureRandom)random);
                return KeyUtil.toPrivateKeyInfo((RSAPrivateCrtKey)((RSAPrivateCrtKey)kp.getPrivate()));
            }
            case "EC": {
                ASN1ObjectIdentifier curveOid = new ASN1ObjectIdentifier(tokens[1]);
                KeyPair kp = KeyUtil.generateECKeypair((ASN1ObjectIdentifier)curveOid, (SecureRandom)random);
                ECPublicKey pub = (ECPublicKey)kp.getPublic();
                int orderBitLength = pub.getParams().getOrder().bitLength();
                byte[] publicKey = KeyUtil.getUncompressedEncodedECPoint((ECPoint)pub.getW(), (int)orderBitLength);
                java.security.interfaces.ECPrivateKey priv = (java.security.interfaces.ECPrivateKey)kp.getPrivate();
                return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)curveOid), (ASN1Encodable)new ECPrivateKey(orderBitLength, priv.getS(), (ASN1BitString)new DERBitString(publicKey), null));
            }
            case "DSA": {
                int pLength = Integer.parseInt(tokens[1]);
                int qLength = Integer.parseInt(tokens[2]);
                DSAParameterSpec spec = DSAParameterCache.getDSAParameterSpec((int)pLength, (int)qLength, null);
                KeyPair kp = KeyUtil.generateDSAKeypair((DSAParameterSpec)spec, (SecureRandom)random);
                DSAParameter parameter = new DSAParameter(spec.getP(), spec.getQ(), spec.getG());
                AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)parameter);
                byte[] publicKey = new ASN1Integer(((DSAPublicKey)kp.getPublic()).getY()).getEncoded();
                DSAPrivateKey priv = (DSAPrivateKey)kp.getPrivate();
                return new PrivateKeyInfo(algId, (ASN1Encodable)new ASN1Integer(priv.getX()), null, publicKey);
            }
            case "ED25519": 
            case "ED448": 
            case "X25519": 
            case "X448": {
                ASN1ObjectIdentifier curveId = EdECConstants.getCurveOid((String)keyspec);
                KeyPair kp = KeyUtil.generateEdECKeypair((ASN1ObjectIdentifier)curveId, (SecureRandom)random);
                return PrivateKeyInfo.getInstance((Object)kp.getPrivate().getEncoded());
            }
        }
        throw new IllegalArgumentException("unknown keyspec " + keyspec);
    }
}

