/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.message;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import org.xipki.scep.crypto.ScepHashAlgoType;
import org.xipki.scep.message.CertificateValidator;
import org.xipki.scep.util.ScepUtil;

public class CollectionCertificateValidator
implements CertificateValidator {
    private final Collection<String> certHashes;

    public CollectionCertificateValidator(Collection<X509Certificate> certs) {
        ScepUtil.requireNonEmpty("certs", certs);
        this.certHashes = new HashSet<String>(certs.size());
        for (X509Certificate cert : certs) {
            String hash;
            try {
                hash = ScepHashAlgoType.SHA256.hexDigest(cert.getEncoded());
            }
            catch (CertificateEncodingException ex) {
                throw new IllegalArgumentException("could not encode certificate: " + ex.getMessage(), ex);
            }
            this.certHashes.add(hash);
        }
    }

    public CollectionCertificateValidator(X509Certificate cert) {
        String hash;
        ScepUtil.requireNonNull("cert", cert);
        this.certHashes = new HashSet<String>(1);
        try {
            hash = ScepHashAlgoType.SHA256.hexDigest(cert.getEncoded());
        }
        catch (CertificateEncodingException ex) {
            throw new IllegalArgumentException("could not encode certificate: " + ex.getMessage(), ex);
        }
        this.certHashes.add(hash);
    }

    @Override
    public boolean trustCertificate(X509Certificate signerCert, X509Certificate[] otherCerts) {
        String hash;
        ScepUtil.requireNonNull("signerCert", signerCert);
        try {
            hash = ScepHashAlgoType.SHA256.hexDigest(signerCert.getEncoded());
        }
        catch (CertificateEncodingException ex) {
            throw new IllegalArgumentException("could not encode certificate: " + ex.getMessage(), ex);
        }
        return this.certHashes.contains(hash);
    }
}

