/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.message;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.xipki.scep.crypto.ScepHashAlgoType;
import org.xipki.scep.exception.MessageEncodingException;
import org.xipki.scep.util.ScepUtil;

public class NextCaMessage {
    private X509Certificate caCert;
    private List<X509Certificate> raCerts;

    public X509Certificate caCert() {
        return this.caCert;
    }

    public void setCaCert(X509Certificate caCert) {
        this.caCert = caCert;
    }

    public List<X509Certificate> raCerts() {
        return this.raCerts;
    }

    public void setRaCerts(List<X509Certificate> raCerts) {
        this.raCerts = raCerts == null || raCerts.isEmpty() ? null : Collections.unmodifiableList(new ArrayList<X509Certificate>(raCerts));
    }

    public ContentInfo encode(PrivateKey signingKey, X509Certificate signerCert, X509Certificate[] cmsCertSet) throws MessageEncodingException {
        ScepUtil.requireNonNull("signingKey", signingKey);
        ScepUtil.requireNonNull("signerCert", signerCert);
        try {
            byte[] degenratedSignedDataBytes;
            try {
                CMSSignedDataGenerator degenerateSignedData = new CMSSignedDataGenerator();
                degenerateSignedData.addCertificate(new X509CertificateHolder(this.caCert.getEncoded()));
                if (this.raCerts != null && !this.raCerts.isEmpty()) {
                    for (X509Certificate m : this.raCerts) {
                        degenerateSignedData.addCertificate(new X509CertificateHolder(m.getEncoded()));
                    }
                }
                degenratedSignedDataBytes = degenerateSignedData.generate((CMSTypedData)new CMSAbsentContent()).getEncoded();
            }
            catch (CertificateEncodingException ex) {
                throw new MessageEncodingException(ex.getMessage(), ex);
            }
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            String signatureAlgo = NextCaMessage.getSignatureAlgorithm(signingKey, ScepHashAlgoType.SHA1);
            ContentSigner signer = new JcaContentSignerBuilder(signatureAlgo).build(signingKey);
            JcaSignerInfoGeneratorBuilder signerInfoBuilder = new JcaSignerInfoGeneratorBuilder((DigestCalculatorProvider)new BcDigestCalculatorProvider());
            signerInfoBuilder.setSignedAttributeGenerator((CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator());
            SignerInfoGenerator signerInfo = signerInfoBuilder.build(signer, signerCert);
            generator.addSignerInfoGenerator(signerInfo);
            CMSProcessableByteArray cmsContent = new CMSProcessableByteArray(CMSObjectIdentifiers.signedData, degenratedSignedDataBytes);
            ScepUtil.addCmsCertSet(generator, cmsCertSet);
            return generator.generate((CMSTypedData)cmsContent, true).toASN1Structure();
        }
        catch (CMSException ex) {
            throw new MessageEncodingException(ex);
        }
        catch (CertificateEncodingException ex) {
            throw new MessageEncodingException(ex);
        }
        catch (IOException ex) {
            throw new MessageEncodingException(ex);
        }
        catch (OperatorCreationException ex) {
            throw new MessageEncodingException(ex);
        }
    }

    private static String getSignatureAlgorithm(PrivateKey key, ScepHashAlgoType hashAlgo) {
        String algorithm = key.getAlgorithm();
        if ("RSA".equalsIgnoreCase(algorithm)) {
            return hashAlgo.getName() + "withRSA";
        }
        throw new UnsupportedOperationException("getSignatureAlgorithm() for non-RSA is not supported yet.");
    }
}

