/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.crypto;

import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.util.encoders.Hex;
import org.xipki.scep.util.ScepUtil;

public enum ScepHashAlgoType {
    MD5(16, "1.2.840.113549.2.5", "MD5"),
    SHA1(20, "1.3.14.3.2.26", "SHA1"),
    SHA256(32, "2.16.840.1.101.3.4.2.1", "SHA256"),
    SHA512(64, "2.16.840.1.101.3.4.2.3", "SHA512");

    private final int length;
    private final String oid;
    private final String name;

    private ScepHashAlgoType(int length, String oid, String name) {
        this.length = length;
        this.oid = oid;
        this.name = name;
    }

    public int length() {
        return this.length;
    }

    public String oid() {
        return this.oid;
    }

    public String getName() {
        return this.name;
    }

    public String hexDigest(byte[] content) {
        byte[] dgst = this.digest(content);
        return dgst == null ? null : Hex.toHexString((byte[])dgst).toUpperCase();
    }

    public byte[] digest(byte[] content) {
        SHA1Digest digest;
        ScepUtil.requireNonNull("content", content);
        if (this == SHA1) {
            digest = new SHA1Digest();
        } else if (this == SHA256) {
            digest = new SHA256Digest();
        } else if (this == SHA512) {
            digest = new SHA512Digest();
        } else if (this == MD5) {
            digest = new MD5Digest();
        } else {
            throw new RuntimeException("should not reach here");
        }
        byte[] ret = new byte[this.length];
        digest.doFinal(ret, 0);
        return ret;
    }

    public static ScepHashAlgoType forNameOrOid(String nameOrOid) {
        String tmpNameOrOid = nameOrOid;
        for (ScepHashAlgoType hashAlgo : ScepHashAlgoType.values()) {
            if (hashAlgo.oid.equals(tmpNameOrOid)) {
                return hashAlgo;
            }
            if (tmpNameOrOid.indexOf(45) != -1) {
                tmpNameOrOid = tmpNameOrOid.replace("-", "");
            }
            if (!hashAlgo.name.equalsIgnoreCase(tmpNameOrOid)) continue;
            return hashAlgo;
        }
        return null;
    }
}

