/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.message;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.scep.util.ScepUtil;

public class IssuerAndSubject
extends ASN1Object {
    private X500Name issuer;
    private X500Name subject;

    private IssuerAndSubject(ASN1Sequence seq) {
        ScepUtil.requireNonNull("seq", seq);
        this.issuer = X500Name.getInstance((Object)seq.getObjectAt(0));
        this.subject = X500Name.getInstance((Object)seq.getObjectAt(1));
    }

    public IssuerAndSubject(X500Name issuer, X500Name subject) {
        this.issuer = ScepUtil.requireNonNull("issuer", issuer);
        this.subject = ScepUtil.requireNonNull("subject", subject);
    }

    public X500Name issuer() {
        return this.issuer;
    }

    public X500Name subject() {
        return this.subject;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)this.issuer);
        vec.add((ASN1Encodable)this.subject);
        return new DERSequence(vec);
    }

    public static IssuerAndSubject getInstance(Object obj) {
        if (obj instanceof IssuerAndSubject) {
            return (IssuerAndSubject)((Object)obj);
        }
        if (obj != null) {
            return new IssuerAndSubject(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }
}

