/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.message;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.xipki.scep.exception.MessageEncodingException;
import org.xipki.scep.message.ScepObjectIdentifiers;
import org.xipki.scep.transaction.FailInfo;
import org.xipki.scep.transaction.MessageType;
import org.xipki.scep.transaction.Nonce;
import org.xipki.scep.transaction.PkiStatus;
import org.xipki.scep.transaction.TransactionId;
import org.xipki.scep.util.ScepUtil;

public class PkiMessage {
    private static final Set<ASN1ObjectIdentifier> SCEP_ATTR_TYPES = new HashSet<ASN1ObjectIdentifier>();
    private final MessageType messageType;
    private final Nonce senderNonce;
    private final TransactionId transactionId;
    private Nonce recipientNonce;
    private PkiStatus pkiStatus;
    private FailInfo failInfo;
    private ASN1Encodable messageData;
    private final Map<ASN1ObjectIdentifier, ASN1Encodable> signedAttributes = new HashMap<ASN1ObjectIdentifier, ASN1Encodable>();
    private final Map<ASN1ObjectIdentifier, ASN1Encodable> unsignedAttributes = new HashMap<ASN1ObjectIdentifier, ASN1Encodable>();

    public PkiMessage(TransactionId transactionId, MessageType messageType) {
        this(transactionId, messageType, Nonce.randomNonce());
    }

    public PkiMessage(TransactionId transactionId, MessageType messageType, Nonce senderNonce) {
        this.transactionId = ScepUtil.requireNonNull("transactionId", transactionId);
        this.messageType = ScepUtil.requireNonNull("messageType", messageType);
        this.senderNonce = ScepUtil.requireNonNull("senderNonce", senderNonce);
    }

    public TransactionId transactionId() {
        return this.transactionId;
    }

    public Nonce senderNonce() {
        return this.senderNonce;
    }

    public final MessageType messageType() {
        return this.messageType;
    }

    public Nonce recipientNonce() {
        return this.recipientNonce;
    }

    public void setRecipientNonce(Nonce recipientNonce) {
        this.recipientNonce = recipientNonce;
    }

    public PkiStatus pkiStatus() {
        return this.pkiStatus;
    }

    public void setPkiStatus(PkiStatus pkiStatus) {
        this.pkiStatus = pkiStatus;
    }

    public FailInfo failInfo() {
        return this.failInfo;
    }

    public void setFailInfo(FailInfo failInfo) {
        this.failInfo = failInfo;
    }

    public ASN1Encodable messageData() {
        return this.messageData;
    }

    public void setMessageData(ASN1Encodable messageData) {
        this.messageData = messageData;
    }

    public ASN1Encodable addSignendAttribute(ASN1ObjectIdentifier type, ASN1Encodable value) {
        if (SCEP_ATTR_TYPES.contains(type)) {
            throw new IllegalArgumentException("Adding SCEP attribute via addSignedAttribute() method is not permitted");
        }
        return this.signedAttributes.put(type, value);
    }

    public ASN1Encodable addUnsignendAttribute(ASN1ObjectIdentifier type, ASN1Encodable value) {
        return this.unsignedAttributes.put(type, value);
    }

    public ASN1Encodable removeSignedAttribute(ASN1ObjectIdentifier type) {
        return this.signedAttributes.remove(type);
    }

    public ASN1Encodable removeUnsignedAttribute(ASN1ObjectIdentifier type) {
        return this.unsignedAttributes.remove(type);
    }

    public ASN1Encodable getSignedAtrributeValue(ASN1ObjectIdentifier type) {
        return this.signedAttributes.get(type);
    }

    public ASN1Encodable getUnsignedAtrributeValue(ASN1ObjectIdentifier type) {
        return this.unsignedAttributes.get(type);
    }

    private AttributeTable getSignedAttributes() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        PkiMessage.addAttribute(vec, ScepObjectIdentifiers.ID_MESSAGE_TYPE, (ASN1Encodable)new DERPrintableString(Integer.toString(this.messageType.code())));
        PkiMessage.addAttribute(vec, ScepObjectIdentifiers.ID_SENDER_NONCE, (ASN1Encodable)new DEROctetString(this.senderNonce.bytes()));
        PkiMessage.addAttribute(vec, ScepObjectIdentifiers.ID_TRANSACTION_ID, (ASN1Encodable)new DERPrintableString(this.transactionId.id()));
        if (this.failInfo != null) {
            PkiMessage.addAttribute(vec, ScepObjectIdentifiers.ID_FAILINFO, (ASN1Encodable)new DERPrintableString(Integer.toString(this.failInfo.code())));
        }
        if (this.pkiStatus != null) {
            PkiMessage.addAttribute(vec, ScepObjectIdentifiers.ID_PKI_STATUS, (ASN1Encodable)new DERPrintableString(Integer.toString(this.pkiStatus.code())));
        }
        if (this.recipientNonce != null) {
            PkiMessage.addAttribute(vec, ScepObjectIdentifiers.ID_RECIPIENT_NONCE, (ASN1Encodable)new DEROctetString(this.recipientNonce.bytes()));
        }
        for (ASN1ObjectIdentifier type : this.signedAttributes.keySet()) {
            PkiMessage.addAttribute(vec, type, this.signedAttributes.get(type));
        }
        return new AttributeTable(vec);
    }

    private AttributeTable getUnsignedAttributes() {
        if (this.unsignedAttributes.isEmpty()) {
            return null;
        }
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (ASN1ObjectIdentifier type : this.unsignedAttributes.keySet()) {
            PkiMessage.addAttribute(vec, type, this.unsignedAttributes.get(type));
        }
        return new AttributeTable(vec);
    }

    public ContentInfo encode(PrivateKey signerKey, String signatureAlgorithm, X509Certificate signerCert, X509Certificate[] signerCertSet, X509Certificate recipientCert, ASN1ObjectIdentifier encAlgId) throws MessageEncodingException {
        ContentSigner signer;
        ScepUtil.requireNonNull("signerKey", signerKey);
        try {
            signer = new JcaContentSignerBuilder(signatureAlgorithm).build(signerKey);
        }
        catch (OperatorCreationException ex) {
            throw new MessageEncodingException(ex);
        }
        return this.encode(signer, signerCert, signerCertSet, recipientCert, encAlgId);
    }

    public ContentInfo encode(ContentSigner signer, X509Certificate signerCert, X509Certificate[] cmsCertSet, X509Certificate recipientCert, ASN1ObjectIdentifier encAlgId) throws MessageEncodingException {
        CMSAbsentContent content;
        ScepUtil.requireNonNull("signer", signer);
        ScepUtil.requireNonNull("signerCert", signerCert);
        if (this.messageData != null) {
            ScepUtil.requireNonNull("recipientCert", recipientCert);
            ScepUtil.requireNonNull("encAlgId", encAlgId);
        }
        if (this.messageData == null) {
            content = new CMSAbsentContent();
        } else {
            byte[] encoded;
            CMSEnvelopedData envelopedData = this.encrypt(recipientCert, encAlgId);
            try {
                encoded = envelopedData.getEncoded();
            }
            catch (IOException ex) {
                throw new MessageEncodingException(ex);
            }
            content = new CMSProcessableByteArray(CMSObjectIdentifiers.envelopedData, encoded);
        }
        try {
            SignerInfoGenerator signerInfo;
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            JcaSignerInfoGeneratorBuilder signerInfoBuilder = new JcaSignerInfoGeneratorBuilder((DigestCalculatorProvider)new BcDigestCalculatorProvider());
            signerInfoBuilder.setSignedAttributeGenerator((CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(this.getSignedAttributes()));
            AttributeTable attrTable = this.getUnsignedAttributes();
            if (attrTable != null) {
                signerInfoBuilder.setUnsignedAttributeGenerator((CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(attrTable));
            }
            ScepUtil.addCmsCertSet(generator, cmsCertSet);
            try {
                signerInfo = signerInfoBuilder.build(signer, signerCert);
            }
            catch (Exception ex) {
                throw new MessageEncodingException(ex);
            }
            generator.addSignerInfoGenerator(signerInfo);
            CMSSignedData signedData = generator.generate((CMSTypedData)content, true);
            return signedData.toASN1Structure();
        }
        catch (CMSException ex) {
            throw new MessageEncodingException(ex);
        }
        catch (Exception ex) {
            throw new MessageEncodingException(ex);
        }
    }

    private CMSEnvelopedData encrypt(X509Certificate recipient, ASN1ObjectIdentifier encAlgId) throws MessageEncodingException {
        JceKeyTransRecipientInfoGenerator recipientGenerator;
        byte[] messageDataBytes;
        ScepUtil.requireNonNull("recipient", recipient);
        ScepUtil.requireNonNull("encAlgId", encAlgId);
        try {
            messageDataBytes = this.messageData.toASN1Primitive().getEncoded();
        }
        catch (IOException ex) {
            throw new MessageEncodingException(ex);
        }
        CMSEnvelopedDataGenerator edGenerator = new CMSEnvelopedDataGenerator();
        CMSProcessableByteArray envelopable = new CMSProcessableByteArray(messageDataBytes);
        try {
            recipientGenerator = new JceKeyTransRecipientInfoGenerator(recipient);
        }
        catch (CertificateEncodingException ex) {
            throw new MessageEncodingException(ex);
        }
        edGenerator.addRecipientInfoGenerator((RecipientInfoGenerator)recipientGenerator);
        try {
            OutputEncryptor encryptor = new JceCMSContentEncryptorBuilder(encAlgId).build();
            CMSEnvelopedData pkcsPkiEnvelope = edGenerator.generate((CMSTypedData)envelopable, encryptor);
            return pkcsPkiEnvelope;
        }
        catch (CMSException ex) {
            throw new MessageEncodingException(ex);
        }
    }

    private static void addAttribute(ASN1EncodableVector vector, ASN1ObjectIdentifier attrType, ASN1Encodable attrValue) {
        vector.add((ASN1Encodable)new Attribute(attrType, (ASN1Set)new DERSet(attrValue)));
    }

    static {
        SCEP_ATTR_TYPES.add(ScepObjectIdentifiers.ID_FAILINFO);
        SCEP_ATTR_TYPES.add(ScepObjectIdentifiers.ID_MESSAGE_TYPE);
        SCEP_ATTR_TYPES.add(ScepObjectIdentifiers.ID_PKI_STATUS);
        SCEP_ATTR_TYPES.add(ScepObjectIdentifiers.ID_RECIPIENT_NONCE);
        SCEP_ATTR_TYPES.add(ScepObjectIdentifiers.ID_SENDER_NONCE);
        SCEP_ATTR_TYPES.add(ScepObjectIdentifiers.ID_TRANSACTION_ID);
        SCEP_ATTR_TYPES.add(CMSAttributes.signingTime);
    }
}

