/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.message;

import java.security.cert.X509Certificate;
import org.xipki.scep.crypto.KeyUsage;
import org.xipki.scep.util.ScepUtil;

public class AuthorityCertStore {
    private final X509Certificate caCert;
    private final X509Certificate signatureCert;
    private final X509Certificate encryptionCert;

    private AuthorityCertStore(X509Certificate caCert, X509Certificate signatureCert, X509Certificate encryptionCert) {
        this.caCert = caCert;
        this.signatureCert = signatureCert;
        this.encryptionCert = encryptionCert;
    }

    public X509Certificate getSignatureCert() {
        return this.signatureCert;
    }

    public X509Certificate getEncryptionCert() {
        return this.encryptionCert;
    }

    public X509Certificate getCaCert() {
        return this.caCert;
    }

    public static AuthorityCertStore getInstance(X509Certificate caCert, X509Certificate ... raCerts) {
        ScepUtil.requireNonNull("caCert", caCert);
        X509Certificate encryptionCert = null;
        X509Certificate signatureCert = null;
        if (raCerts == null || raCerts.length == 0) {
            signatureCert = caCert;
            encryptionCert = caCert;
        } else {
            for (X509Certificate cert : raCerts) {
                boolean[] keyusage = cert.getKeyUsage();
                if (AuthorityCertStore.hasKeyusage(keyusage, KeyUsage.keyEncipherment)) {
                    if (encryptionCert != null) {
                        throw new IllegalArgumentException("Could not determine RA certificate for encryption");
                    }
                    encryptionCert = cert;
                }
                if (!AuthorityCertStore.hasKeyusage(keyusage, KeyUsage.digitalSignature) && !AuthorityCertStore.hasKeyusage(keyusage, KeyUsage.contentCommitment)) continue;
                if (signatureCert != null) {
                    throw new IllegalArgumentException("Could not determine RA certificate for signature");
                }
                signatureCert = cert;
            }
            if (encryptionCert == null) {
                throw new IllegalArgumentException("Could not determine RA certificate for encryption");
            }
            if (signatureCert == null) {
                throw new IllegalArgumentException("Could not determine RA certificate for signature");
            }
        }
        return new AuthorityCertStore(caCert, signatureCert, encryptionCert);
    }

    private static boolean hasKeyusage(boolean[] keyusage, KeyUsage usage) {
        if (keyusage != null && keyusage.length > usage.getBit()) {
            return keyusage[usage.getBit()];
        }
        return false;
    }
}

