/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.scep.crypto.ScepHashAlgo;
import org.xipki.scep.transaction.CaCapability;
import org.xipki.scep.util.ScepUtil;

public class CaCaps {
    private static final Logger LOG = LoggerFactory.getLogger(CaCaps.class);
    private byte[] bytes;
    private final Set<CaCapability> capabilities;

    public CaCaps() {
        this.capabilities = new HashSet<CaCapability>();
    }

    public CaCaps(Set<CaCapability> capabilities) {
        this.capabilities = capabilities == null || capabilities.isEmpty() ? new HashSet<CaCapability>() : new HashSet<CaCapability>(capabilities);
        this.refresh();
    }

    public Set<CaCapability> capabilities() {
        return Collections.unmodifiableSet(this.capabilities);
    }

    public void addCapabilities(CaCapability ... caps) {
        ScepUtil.requireNonNull("caps", caps);
        for (CaCapability m : caps) {
            this.capabilities.add(m);
        }
        this.refresh();
    }

    public void removeCapabilities(CaCaps caCaps) {
        ScepUtil.requireNonNull("caCaps", caCaps);
        this.capabilities.retainAll(caCaps.capabilities);
        this.refresh();
    }

    public void removeCapabilities(CaCapability ... caps) {
        ScepUtil.requireNonNull("caps", caps);
        for (CaCapability m : caps) {
            this.capabilities.remove((Object)m);
        }
        this.refresh();
    }

    public boolean containsCapability(CaCapability cap) {
        ScepUtil.requireNonNull("cap", cap);
        return this.capabilities.contains((Object)cap);
    }

    public String toString() {
        return this.toScepMessage();
    }

    public int hashCode() {
        return this.toScepMessage().hashCode();
    }

    public String toScepMessage() {
        if (this.capabilities.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (CaCapability cap : this.capabilities) {
            sb.append(cap.getText()).append("\n");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public boolean supportsPost() {
        return this.capabilities.contains((Object)CaCapability.POSTPKIOperation);
    }

    public ScepHashAlgo mostSecureHashAlgo() {
        if (this.capabilities.contains((Object)CaCapability.SHA512)) {
            return ScepHashAlgo.SHA512;
        }
        if (this.capabilities.contains((Object)CaCapability.SHA256)) {
            return ScepHashAlgo.SHA256;
        }
        if (this.capabilities.contains((Object)CaCapability.SHA1)) {
            return ScepHashAlgo.SHA1;
        }
        return ScepHashAlgo.MD5;
    }

    private void refresh() {
        if (this.capabilities != null) {
            this.bytes = this.toString().getBytes();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CaCaps)) {
            return false;
        }
        return this.capabilities.equals(((CaCaps)obj).capabilities);
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public static CaCaps getInstance(String scepMessage) {
        CaCaps ret = new CaCaps();
        if (scepMessage == null || scepMessage.isEmpty()) {
            return ret;
        }
        StringTokenizer st = new StringTokenizer(scepMessage, "\r\n");
        ArrayList<CaCapability> caps = new ArrayList<CaCapability>(st.countTokens());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            try {
                CaCapability cap = CaCapability.forValue(token);
                caps.add(cap);
            }
            catch (IllegalArgumentException ex) {
                LOG.warn("ignore unknown CACap '{}'", (Object)token);
            }
        }
        if (!caps.isEmpty()) {
            ret.addCapabilities(caps.toArray(new CaCapability[0]));
        }
        return ret;
    }
}

