/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.message;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Selector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.scep.exception.MessageDecodingException;
import org.xipki.scep.message.AuthorityCertStore;
import org.xipki.scep.util.ScepUtil;

public class DecodedNextCaMessage {
    private static final Logger LOG = LoggerFactory.getLogger(DecodedNextCaMessage.class);
    private AuthorityCertStore authorityCertStore;
    private X509Certificate signatureCert;
    private ASN1ObjectIdentifier digestAlgorithm;
    private Boolean signatureValid;
    private Date signingTime;
    private String failureMessage;

    public AuthorityCertStore getAuthorityCertStore() {
        return this.authorityCertStore;
    }

    public void setAuthorityCertStore(AuthorityCertStore authorityCertStore) {
        this.authorityCertStore = authorityCertStore;
    }

    public X509Certificate getSignatureCert() {
        return this.signatureCert;
    }

    public void setSignatureCert(X509Certificate signatureCert) {
        this.signatureCert = signatureCert;
    }

    public ASN1ObjectIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(ASN1ObjectIdentifier digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public Boolean isSignatureValid() {
        return this.signatureValid;
    }

    public void setSignatureValid(Boolean signatureValid) {
        this.signatureValid = signatureValid;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public Date getSigningTime() {
        return this.signingTime;
    }

    public void setSigningTime(Date signingTime) {
        this.signingTime = signingTime;
    }

    public static DecodedNextCaMessage decode(CMSSignedData pkiMessage, CollectionStore<X509CertificateHolder> certStore) throws MessageDecodingException {
        List<X509Certificate> certs;
        boolean signatureValid;
        SignerInformationVerifier verifier;
        X509Certificate signerCert;
        ScepUtil.requireNonNull("pkiMessage", pkiMessage);
        SignerInformationStore signerStore = pkiMessage.getSignerInfos();
        Collection signerInfos = signerStore.getSigners();
        if (signerInfos.size() != 1) {
            throw new MessageDecodingException("number of signerInfos is not 1, but " + signerInfos.size());
        }
        SignerInformation signerInfo = (SignerInformation)signerInfos.iterator().next();
        SignerId sid = signerInfo.getSID();
        Collection signedDataCerts = null;
        if (certStore != null) {
            signedDataCerts = certStore.getMatches((Selector)sid);
        }
        if (signedDataCerts == null || signedDataCerts.isEmpty()) {
            signedDataCerts = pkiMessage.getCertificates().getMatches((Selector)signerInfo.getSID());
        }
        if (signedDataCerts == null || signedDataCerts.size() != 1) {
            throw new MessageDecodingException("could not find embedded certificate to verify the signature");
        }
        AttributeTable signedAttrs = signerInfo.getSignedAttributes();
        if (signedAttrs == null) {
            throw new MessageDecodingException("missing signed attributes");
        }
        Date signingTime = null;
        ASN1Encodable attrValue = ScepUtil.getFirstAttrValue(signedAttrs, CMSAttributes.signingTime);
        if (attrValue != null) {
            signingTime = Time.getInstance((Object)attrValue).getDate();
        }
        DecodedNextCaMessage ret = new DecodedNextCaMessage();
        if (signingTime != null) {
            ret.setSigningTime(signingTime);
        }
        ASN1ObjectIdentifier digestAlgOid = signerInfo.getDigestAlgorithmID().getAlgorithm();
        ret.setDigestAlgorithm(digestAlgOid);
        String sigAlgOid = signerInfo.getEncryptionAlgOID();
        if (!PKCSObjectIdentifiers.rsaEncryption.getId().equals(sigAlgOid)) {
            ASN1ObjectIdentifier tmpDigestAlgOid;
            try {
                tmpDigestAlgOid = ScepUtil.extractDigesetAlgorithmIdentifier(signerInfo.getEncryptionAlgOID(), signerInfo.getEncryptionAlgParams());
            }
            catch (Exception ex) {
                String msg = "could not extract digest algorithm from signerInfo.signatureAlgorithm: " + ex.getMessage();
                LOG.error(msg);
                LOG.debug(msg, (Throwable)ex);
                ret.setFailureMessage(msg);
                return ret;
            }
            if (!digestAlgOid.equals((Object)tmpDigestAlgOid)) {
                ret.setFailureMessage("digestAlgorithm and encryptionAlgorithm do not use the same digestAlgorithm");
                return ret;
            }
        }
        X509CertificateHolder tmpSignerCert = (X509CertificateHolder)signedDataCerts.iterator().next();
        try {
            signerCert = ScepUtil.toX509Cert(tmpSignerCert.toASN1Structure());
        }
        catch (CertificateException ex) {
            String msg = "could not construct X509CertificateObject: " + ex.getMessage();
            LOG.error(msg);
            LOG.debug(msg, (Throwable)ex);
            ret.setFailureMessage(msg);
            return ret;
        }
        ret.setSignatureCert(signerCert);
        try {
            verifier = new JcaSimpleSignerInfoVerifierBuilder().build(signerCert.getPublicKey());
        }
        catch (OperatorCreationException ex) {
            String msg = "could not build signature verifier: " + ex.getMessage();
            LOG.error(msg);
            LOG.debug(msg, (Throwable)ex);
            ret.setFailureMessage(msg);
            return ret;
        }
        try {
            signatureValid = signerInfo.verify(verifier);
        }
        catch (CMSException ex) {
            String msg = "could not verify the signature: " + ex.getMessage();
            LOG.error(msg);
            LOG.debug(msg, (Throwable)ex);
            ret.setFailureMessage(msg);
            return ret;
        }
        ret.setSignatureValid(signatureValid);
        if (!signatureValid) {
            return ret;
        }
        CMSTypedData signedContent = pkiMessage.getSignedContent();
        ASN1ObjectIdentifier signedContentType = signedContent.getContentType();
        if (!CMSObjectIdentifiers.signedData.equals((Object)signedContentType) && !CMSObjectIdentifiers.data.equals((Object)signedContentType)) {
            ret.setFailureMessage("either id-signedData or id-data is excepted, but not '" + signedContentType.getId());
            return ret;
        }
        ContentInfo contentInfo = ContentInfo.getInstance((Object)((byte[])signedContent.getContent()));
        SignedData signedData = SignedData.getInstance((Object)contentInfo.getContent());
        try {
            certs = ScepUtil.getCertsFromSignedData(signedData);
        }
        catch (CertificateException ex) {
            String msg = "could not extract Certificates from the message: " + ex.getMessage();
            LOG.error(msg);
            LOG.debug(msg, (Throwable)ex);
            ret.setFailureMessage(msg);
            return ret;
        }
        int n = certs.size();
        X509Certificate caCert = null;
        LinkedList<X509Certificate> raCerts = new LinkedList<X509Certificate>();
        for (int i = 0; i < n; ++i) {
            X509Certificate cert = certs.get(i);
            if (cert.getBasicConstraints() > -1) {
                if (caCert != null) {
                    String msg = "multiple CA certificates is returned, but exactly 1 is expected";
                    LOG.error("multiple CA certificates is returned, but exactly 1 is expected");
                    ret.setFailureMessage("multiple CA certificates is returned, but exactly 1 is expected");
                    return ret;
                }
                caCert = cert;
                continue;
            }
            raCerts.add(cert);
        }
        if (caCert == null) {
            String msg = "no CA certificate is returned";
            LOG.error("no CA certificate is returned");
            ret.setFailureMessage("no CA certificate is returned");
            return ret;
        }
        X509Certificate[] locaRaCerts = raCerts.isEmpty() ? null : raCerts.toArray(new X509Certificate[0]);
        AuthorityCertStore authorityCertStore = AuthorityCertStore.getInstance(caCert, locaRaCerts);
        ret.setAuthorityCertStore(authorityCertStore);
        return ret;
    }
}

