/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.message;

import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.xipki.scep.exception.MessageDecodingException;
import org.xipki.scep.message.EnvelopedDataDecryptorInstance;
import org.xipki.scep.util.ScepUtil;

public final class EnvelopedDataDecryptor {
    private final List<EnvelopedDataDecryptorInstance> decryptors;

    public EnvelopedDataDecryptor(List<EnvelopedDataDecryptorInstance> decryptors) {
        ScepUtil.requireNonEmpty("decryptors", decryptors);
        this.decryptors = new ArrayList<EnvelopedDataDecryptorInstance>(decryptors);
    }

    public EnvelopedDataDecryptor(EnvelopedDataDecryptorInstance decryptor) {
        ScepUtil.requireNonNull("decryptor", decryptor);
        this.decryptors = new ArrayList<EnvelopedDataDecryptorInstance>(1);
        this.decryptors.add(decryptor);
    }

    public byte[] decrypt(CMSEnvelopedData envData) throws MessageDecodingException {
        ScepUtil.requireNonNull("envData", envData);
        RecipientInformationStore recipientInfos = envData.getRecipientInfos();
        RecipientInformation recipientInfo = null;
        EnvelopedDataDecryptorInstance decryptor = null;
        for (EnvelopedDataDecryptorInstance m : this.decryptors) {
            recipientInfo = recipientInfos.get(m.getRecipientId());
            if (recipientInfo == null) continue;
            decryptor = m;
            break;
        }
        if (recipientInfo == null || decryptor == null) {
            throw new MessageDecodingException("missing expected key transfer recipient");
        }
        try {
            return recipientInfo.getContent((Recipient)decryptor.getRecipient());
        }
        catch (CMSException ex) {
            throw new MessageDecodingException("could not decrypt the envelopedData");
        }
    }
}

