/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.PasswordResolver;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.jaxb.MechnanismSetsType;
import org.xipki.security.pkcs11.jaxb.ModuleType;
import org.xipki.security.pkcs11.jaxb.ModulesType;
import org.xipki.security.pkcs11.jaxb.ObjectFactory;
import org.xipki.security.pkcs11.jaxb.Pkcs11ConfType;
import org.xipki.util.InvalidConfException;
import org.xipki.util.LogUtil;
import org.xipki.util.ParamUtil;
import org.xml.sax.SAXException;

public class P11Conf {
    private static final Logger LOG = LoggerFactory.getLogger(P11Conf.class);
    private final Map<String, P11ModuleConf> moduleConfs;
    private final Set<String> moduleNames;

    public P11Conf(InputStream confStream, PasswordResolver passwordResolver) throws InvalidConfException, IOException {
        ParamUtil.requireNonNull((String)"confStream", (Object)confStream);
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            SchemaFactory schemaFact = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFact.newSchema(this.getClass().getResource("/xsd/pkcs11-conf.xsd"));
            unmarshaller.setSchema(schema);
            JAXBElement rootElement = (JAXBElement)unmarshaller.unmarshal(confStream);
            Pkcs11ConfType pkcs11Conf = (Pkcs11ConfType)rootElement.getValue();
            ModulesType modulesType = pkcs11Conf.getModules();
            MechnanismSetsType mechanismSets = pkcs11Conf.getMechanismSets();
            HashMap<String, P11ModuleConf> confs = new HashMap<String, P11ModuleConf>();
            for (ModuleType moduleType : modulesType.getModule()) {
                P11ModuleConf conf = new P11ModuleConf(moduleType, mechanismSets, passwordResolver);
                confs.put(conf.getName(), conf);
            }
            if (!confs.containsKey("default")) {
                throw new InvalidConfException("module 'default' is not defined");
            }
            this.moduleConfs = Collections.unmodifiableMap(confs);
            this.moduleNames = Collections.unmodifiableSet(new HashSet(confs.keySet()));
        }
        catch (JAXBException | SAXException ex) {
            String exceptionMsg = ex instanceof JAXBException ? P11Conf.getMessage((JAXBException)ex) : ex.getMessage();
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)exceptionMsg);
            throw new InvalidConfException("invalid PKCS#11 configuration");
        }
        finally {
            confStream.close();
        }
    }

    public Set<String> getModuleNames() {
        return this.moduleNames;
    }

    public P11ModuleConf getModuleConf(String moduleName) {
        return this.moduleConfs.get(moduleName);
    }

    private static String getMessage(JAXBException ex) {
        String ret = ex.getMessage();
        if (ret == null && ex.getLinkedException() != null) {
            ret = ex.getLinkedException().getMessage();
        }
        return ret;
    }
}

