/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.HashAlgo;
import org.xipki.security.XiContentSigner;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.DigestOutputStream;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.exception.P11TokenException;
import org.xipki.security.util.SignerUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ParamUtil;

class P11DSAContentSigner
implements XiContentSigner {
    private static final Logger LOG = LoggerFactory.getLogger(P11DSAContentSigner.class);
    private static final Map<String, HashAlgo> sigAlgHashMap = new HashMap<String, HashAlgo>();
    private static final Map<HashAlgo, Long> hashMechMap = new HashMap<HashAlgo, Long>();
    private final P11CryptService cryptService;
    private final P11IdentityId identityId;
    private final AlgorithmIdentifier algorithmIdentifier;
    private final byte[] encodedAlgorithmIdentifier;
    private final long mechanism;
    private final OutputStream outputStream;
    private final boolean plain;

    P11DSAContentSigner(P11CryptService cryptService, P11IdentityId identityId, AlgorithmIdentifier signatureAlgId, boolean plain) throws XiSecurityException, P11TokenException {
        this.identityId = (P11IdentityId)ParamUtil.requireNonNull((String)"identityId", (Object)identityId);
        this.cryptService = (P11CryptService)ParamUtil.requireNonNull((String)"cryptService", (Object)cryptService);
        this.algorithmIdentifier = (AlgorithmIdentifier)ParamUtil.requireNonNull((String)"signatureAlgId", (Object)signatureAlgId);
        try {
            this.encodedAlgorithmIdentifier = this.algorithmIdentifier.getEncoded();
        }
        catch (IOException ex) {
            throw new XiSecurityException("could not encode AlgorithmIdentifier", (Throwable)ex);
        }
        this.plain = plain;
        String algOid = signatureAlgId.getAlgorithm().getId();
        HashAlgo hashAlgo = sigAlgHashMap.get(algOid);
        if (hashAlgo == null) {
            throw new XiSecurityException("unsupported signature algorithm " + algOid);
        }
        P11SlotIdentifier slotId = identityId.getSlotId();
        P11Slot slot = cryptService.getSlot(slotId);
        if (slot.supportsMechanism(17L)) {
            this.mechanism = 17L;
            Digest digest = hashAlgo.createDigest();
            this.outputStream = new DigestOutputStream(digest);
        } else {
            this.mechanism = hashMechMap.get(hashAlgo);
            if (!slot.supportsMechanism(this.mechanism)) {
                throw new XiSecurityException("unsupported signature algorithm " + algOid);
            }
            this.outputStream = new ByteArrayOutputStream();
        }
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    public byte[] getEncodedAlgorithmIdentifier() {
        return Arrays.copyOf(this.encodedAlgorithmIdentifier, this.encodedAlgorithmIdentifier.length);
    }

    public OutputStream getOutputStream() {
        if (this.outputStream instanceof ByteArrayOutputStream) {
            ((ByteArrayOutputStream)this.outputStream).reset();
        } else {
            ((DigestOutputStream)this.outputStream).reset();
        }
        return this.outputStream;
    }

    public byte[] getSignature() {
        try {
            byte[] plainSignature = this.getPlainSignature();
            return this.plain ? plainSignature : SignerUtil.dsaSigPlainToX962((byte[])plainSignature);
        }
        catch (XiSecurityException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex);
            throw new RuntimeCryptoException("XiSecurityException: " + ex.getMessage());
        }
        catch (Throwable th) {
            LogUtil.warn((Logger)LOG, (Throwable)th);
            throw new RuntimeCryptoException(th.getClass().getName() + ": " + th.getMessage());
        }
    }

    private byte[] getPlainSignature() throws XiSecurityException, P11TokenException {
        byte[] dataToSign;
        if (this.outputStream instanceof ByteArrayOutputStream) {
            dataToSign = ((ByteArrayOutputStream)this.outputStream).toByteArray();
            ((ByteArrayOutputStream)this.outputStream).reset();
        } else {
            dataToSign = ((DigestOutputStream)this.outputStream).digest();
            ((DigestOutputStream)this.outputStream).reset();
        }
        return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, null, dataToSign);
    }

    static {
        sigAlgHashMap.put(X9ObjectIdentifiers.id_dsa_with_sha1.getId(), HashAlgo.SHA1);
        sigAlgHashMap.put(NISTObjectIdentifiers.dsa_with_sha224.getId(), HashAlgo.SHA224);
        sigAlgHashMap.put(NISTObjectIdentifiers.dsa_with_sha256.getId(), HashAlgo.SHA256);
        sigAlgHashMap.put(NISTObjectIdentifiers.dsa_with_sha384.getId(), HashAlgo.SHA384);
        sigAlgHashMap.put(NISTObjectIdentifiers.dsa_with_sha512.getId(), HashAlgo.SHA512);
        sigAlgHashMap.put(NISTObjectIdentifiers.id_dsa_with_sha3_224.getId(), HashAlgo.SHA3_224);
        sigAlgHashMap.put(NISTObjectIdentifiers.id_dsa_with_sha3_256.getId(), HashAlgo.SHA3_256);
        sigAlgHashMap.put(NISTObjectIdentifiers.id_dsa_with_sha3_384.getId(), HashAlgo.SHA3_384);
        sigAlgHashMap.put(NISTObjectIdentifiers.id_dsa_with_sha3_512.getId(), HashAlgo.SHA3_512);
        hashMechMap.put(HashAlgo.SHA1, 18L);
        hashMechMap.put(HashAlgo.SHA224, 19L);
        hashMechMap.put(HashAlgo.SHA256, 20L);
        hashMechMap.put(HashAlgo.SHA384, 21L);
        hashMechMap.put(HashAlgo.SHA512, 22L);
        hashMechMap.put(HashAlgo.SHA3_224, 24L);
        hashMechMap.put(HashAlgo.SHA3_256, 25L);
        hashMechMap.put(HashAlgo.SHA3_384, 26L);
        hashMechMap.put(HashAlgo.SHA3_512, 27L);
    }
}

