/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.pkcs11.P11SlotIdFilter;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ParamUtil;

public class P11PasswordsRetriever {
    private final List<SingleRetriever> singleRetrievers = new LinkedList<SingleRetriever>();
    private PasswordResolver passwordResolver;

    P11PasswordsRetriever() {
    }

    void addPasswordEntry(Set<P11SlotIdFilter> slots, List<String> passwords) {
        this.singleRetrievers.add(new SingleRetriever(slots, passwords));
    }

    public List<char[]> getPassword(P11SlotIdentifier slotId) throws PasswordResolverException {
        ParamUtil.requireNonNull((String)"slotId", (Object)slotId);
        if (CollectionUtil.isEmpty(this.singleRetrievers)) {
            return null;
        }
        for (SingleRetriever sr : this.singleRetrievers) {
            if (!sr.match(slotId)) continue;
            return sr.getPasswords(this.passwordResolver);
        }
        return null;
    }

    public PasswordResolver getPasswordResolver() {
        return this.passwordResolver;
    }

    public void setPasswordResolver(PasswordResolver passwordResolver) {
        this.passwordResolver = passwordResolver;
    }

    private static final class SingleRetriever {
        private final Set<P11SlotIdFilter> slots;
        private final List<String> passwords;

        private SingleRetriever(Set<P11SlotIdFilter> slots, List<String> passwords) {
            this.slots = slots;
            this.passwords = CollectionUtil.isEmpty(passwords) ? null : passwords;
        }

        public boolean match(P11SlotIdentifier slot) {
            if (this.slots == null) {
                return true;
            }
            for (P11SlotIdFilter m : this.slots) {
                if (!m.match(slot)) continue;
                return true;
            }
            return false;
        }

        public List<char[]> getPasswords(PasswordResolver passwordResolver) throws PasswordResolverException {
            if (this.passwords == null) {
                return null;
            }
            ArrayList<char[]> ret = new ArrayList<char[]>(this.passwords.size());
            for (String password : this.passwords) {
                if (passwordResolver == null) {
                    ret.add(password.toCharArray());
                    continue;
                }
                ret.add(passwordResolver.resolvePassword(password));
            }
            return ret;
        }
    }
}

