/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11RSAKeyParameter;
import org.xipki.security.pkcs11.exception.P11TokenException;

public class P11PlainRSASigner
implements AsymmetricBlockCipher {
    private P11RSAKeyParameter param;

    public void init(boolean forEncryption, CipherParameters cipherParam) {
        if (!forEncryption) {
            throw new RuntimeCryptoException("verification mode not supported.");
        }
        if (!(cipherParam instanceof P11RSAKeyParameter)) {
            throw new IllegalArgumentException("invalid param type " + cipherParam.getClass().getName());
        }
        this.param = (P11RSAKeyParameter)cipherParam;
    }

    public int getInputBlockSize() {
        return (this.param.getKeysize() + 7) / 8;
    }

    public int getOutputBlockSize() {
        return (this.param.getKeysize() + 7) / 8;
    }

    public byte[] processBlock(byte[] in, int inOff, int len) throws InvalidCipherTextException {
        byte[] content = new byte[this.getInputBlockSize()];
        System.arraycopy(in, inOff, content, content.length - len, len);
        try {
            P11Identity identity = this.param.getP11CryptService().getIdentity(this.param.getIdentityId());
            return identity.sign(3L, null, content);
        }
        catch (P11TokenException ex) {
            throw new InvalidCipherTextException(ex.getMessage(), (Throwable)ex);
        }
    }
}

