/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.HashAlgo;
import org.xipki.security.XiContentSigner;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.DigestOutputStream;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.exception.P11TokenException;
import org.xipki.security.util.SignerUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ParamUtil;

class P11RSAContentSigner
implements XiContentSigner {
    private static final Logger LOG = LoggerFactory.getLogger(P11RSAContentSigner.class);
    private static final Map<ASN1ObjectIdentifier, HashAlgo> sigAlgHashAlgMap = new HashMap<ASN1ObjectIdentifier, HashAlgo>();
    private static final Map<HashAlgo, Long> hashAlgMecMap = new HashMap<HashAlgo, Long>();
    private final AlgorithmIdentifier algorithmIdentifier;
    private final byte[] encodedAlgorithmIdentifier;
    private final long mechanism;
    private final OutputStream outputStream;
    private final P11CryptService cryptService;
    private final P11IdentityId identityId;
    private final byte[] digestPkcsPrefix;
    private final int modulusBitLen;

    P11RSAContentSigner(P11CryptService cryptService, P11IdentityId identityId, AlgorithmIdentifier signatureAlgId) throws XiSecurityException, P11TokenException {
        this.cryptService = (P11CryptService)ParamUtil.requireNonNull((String)"cryptService", (Object)cryptService);
        this.identityId = (P11IdentityId)ParamUtil.requireNonNull((String)"identityId", (Object)identityId);
        this.algorithmIdentifier = (AlgorithmIdentifier)ParamUtil.requireNonNull((String)"signatureAlgId", (Object)signatureAlgId);
        try {
            this.encodedAlgorithmIdentifier = this.algorithmIdentifier.getEncoded();
        }
        catch (IOException ex) {
            throw new XiSecurityException("could not encode AlgorithmIdentifier", (Throwable)ex);
        }
        ASN1ObjectIdentifier algOid = signatureAlgId.getAlgorithm();
        HashAlgo hashAlgo = sigAlgHashAlgMap.get(algOid);
        if (hashAlgo == null) {
            throw new XiSecurityException("unsupported signature algorithm " + algOid.getId());
        }
        P11SlotIdentifier slotId = identityId.getSlotId();
        P11Slot slot = cryptService.getSlot(slotId);
        if (slot.supportsMechanism(1L)) {
            this.mechanism = 1L;
        } else if (slot.supportsMechanism(3L)) {
            this.mechanism = 3L;
        } else {
            Long mech = hashAlgMecMap.get(hashAlgo);
            if (mech == null) {
                throw new RuntimeException("should not reach here, unknown HashAlgo " + hashAlgo);
            }
            this.mechanism = mech;
            if (!slot.supportsMechanism(this.mechanism)) {
                throw new XiSecurityException("unsupported signature algorithm " + algOid.getId());
            }
        }
        if (this.mechanism == 1L || this.mechanism == 3L) {
            this.digestPkcsPrefix = SignerUtil.getDigestPkcsPrefix((HashAlgo)hashAlgo);
            Digest digest = hashAlgo.createDigest();
            this.outputStream = new DigestOutputStream(digest);
        } else {
            this.digestPkcsPrefix = null;
            this.outputStream = new ByteArrayOutputStream();
        }
        RSAPublicKey rsaPubKey = (RSAPublicKey)cryptService.getIdentity(identityId).getPublicKey();
        this.modulusBitLen = rsaPubKey.getModulus().bitLength();
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    public byte[] getEncodedAlgorithmIdentifier() {
        return Arrays.copyOf(this.encodedAlgorithmIdentifier, this.encodedAlgorithmIdentifier.length);
    }

    public OutputStream getOutputStream() {
        if (this.outputStream instanceof ByteArrayOutputStream) {
            ((ByteArrayOutputStream)this.outputStream).reset();
        } else {
            ((DigestOutputStream)this.outputStream).reset();
        }
        return this.outputStream;
    }

    public byte[] getSignature() {
        byte[] dataToSign;
        if (this.outputStream instanceof ByteArrayOutputStream) {
            dataToSign = ((ByteArrayOutputStream)this.outputStream).toByteArray();
            ((ByteArrayOutputStream)this.outputStream).reset();
        } else {
            byte[] hashValue = ((DigestOutputStream)this.outputStream).digest();
            ((DigestOutputStream)this.outputStream).reset();
            dataToSign = new byte[this.digestPkcsPrefix.length + hashValue.length];
            System.arraycopy(this.digestPkcsPrefix, 0, dataToSign, 0, this.digestPkcsPrefix.length);
            System.arraycopy(hashValue, 0, dataToSign, this.digestPkcsPrefix.length, hashValue.length);
        }
        try {
            if (this.mechanism == 3L) {
                dataToSign = SignerUtil.EMSA_PKCS1_v1_5_encoding((byte[])dataToSign, (int)this.modulusBitLen);
            }
            return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, null, dataToSign);
        }
        catch (XiSecurityException | P11TokenException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not sign");
            throw new RuntimeCryptoException("SignerException: " + ex.getMessage());
        }
    }

    static {
        sigAlgHashAlgMap.put(PKCSObjectIdentifiers.sha1WithRSAEncryption, HashAlgo.SHA1);
        sigAlgHashAlgMap.put(PKCSObjectIdentifiers.sha224WithRSAEncryption, HashAlgo.SHA224);
        sigAlgHashAlgMap.put(PKCSObjectIdentifiers.sha256WithRSAEncryption, HashAlgo.SHA256);
        sigAlgHashAlgMap.put(PKCSObjectIdentifiers.sha384WithRSAEncryption, HashAlgo.SHA384);
        sigAlgHashAlgMap.put(PKCSObjectIdentifiers.sha512WithRSAEncryption, HashAlgo.SHA512);
        sigAlgHashAlgMap.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224, HashAlgo.SHA3_224);
        sigAlgHashAlgMap.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256, HashAlgo.SHA3_256);
        sigAlgHashAlgMap.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384, HashAlgo.SHA3_384);
        sigAlgHashAlgMap.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512, HashAlgo.SHA3_512);
        hashAlgMecMap.put(HashAlgo.SHA1, 6L);
        hashAlgMecMap.put(HashAlgo.SHA224, 70L);
        hashAlgMecMap.put(HashAlgo.SHA256, 64L);
        hashAlgMecMap.put(HashAlgo.SHA384, 65L);
        hashAlgMecMap.put(HashAlgo.SHA512, 66L);
        hashAlgMecMap.put(HashAlgo.SHA3_224, 102L);
        hashAlgMecMap.put(HashAlgo.SHA3_256, 96L);
        hashAlgMecMap.put(HashAlgo.SHA3_384, 97L);
        hashAlgMecMap.put(HashAlgo.SHA3_512, 98L);
    }
}

