/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.exception.P11TokenException;
import org.xipki.util.ParamUtil;

public class P11RSAKeyParameter
extends RSAKeyParameters {
    private final P11CryptService p11CryptService;
    private final P11IdentityId identityId;
    private final int keysize;

    private P11RSAKeyParameter(P11CryptService p11CryptService, P11IdentityId identityId, BigInteger modulus, BigInteger publicExponent) {
        super(true, modulus, publicExponent);
        ParamUtil.requireNonNull((String)"modulus", (Object)modulus);
        ParamUtil.requireNonNull((String)"publicExponent", (Object)publicExponent);
        this.p11CryptService = (P11CryptService)ParamUtil.requireNonNull((String)"p11CryptService", (Object)p11CryptService);
        this.identityId = (P11IdentityId)ParamUtil.requireNonNull((String)"identityId", (Object)identityId);
        this.keysize = modulus.bitLength();
    }

    int getKeysize() {
        return this.keysize;
    }

    P11CryptService getP11CryptService() {
        return this.p11CryptService;
    }

    P11IdentityId getIdentityId() {
        return this.identityId;
    }

    public static P11RSAKeyParameter getInstance(P11CryptService p11CryptService, P11IdentityId identityId) throws InvalidKeyException {
        RSAPublicKey key;
        ParamUtil.requireNonNull((String)"p11CryptService", (Object)p11CryptService);
        ParamUtil.requireNonNull((String)"identityId", (Object)identityId);
        try {
            key = (RSAPublicKey)p11CryptService.getIdentity(identityId).getPublicKey();
        }
        catch (P11TokenException ex) {
            throw new InvalidKeyException(ex.getMessage(), ex);
        }
        BigInteger modulus = key.getModulus();
        BigInteger publicExponent = key.getPublicExponent();
        return new P11RSAKeyParameter(p11CryptService, identityId, modulus, publicExponent);
    }
}

