/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.HashAlgo;
import org.xipki.security.XiContentSigner;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.DigestOutputStream;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11PlainRSASigner;
import org.xipki.security.pkcs11.P11RSAKeyParameter;
import org.xipki.security.pkcs11.P11RSAPkcsPssParams;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.exception.P11TokenException;
import org.xipki.security.util.SignerUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ParamUtil;

class P11RSAPSSContentSigner
implements XiContentSigner {
    private static final Map<HashAlgo, Long> hashAlgMecMap = new HashMap<HashAlgo, Long>();
    private static final Logger LOG;
    private final AlgorithmIdentifier algorithmIdentifier;
    private final byte[] encodedAlgorithmIdentifier;
    private final P11CryptService cryptService;
    private final P11IdentityId identityId;
    private final long mechanism;
    private final P11RSAPkcsPssParams parameters;
    private final OutputStream outputStream;

    P11RSAPSSContentSigner(P11CryptService cryptService, P11IdentityId identityId, AlgorithmIdentifier signatureAlgId, SecureRandom random) throws XiSecurityException, P11TokenException {
        this.cryptService = (P11CryptService)ParamUtil.requireNonNull((String)"cryptService", (Object)cryptService);
        this.identityId = (P11IdentityId)ParamUtil.requireNonNull((String)"identityId", (Object)identityId);
        this.algorithmIdentifier = (AlgorithmIdentifier)ParamUtil.requireNonNull((String)"signatureAlgId", (Object)signatureAlgId);
        try {
            this.encodedAlgorithmIdentifier = this.algorithmIdentifier.getEncoded();
        }
        catch (IOException ex) {
            throw new XiSecurityException("could not encode AlgorithmIdentifier", (Throwable)ex);
        }
        ParamUtil.requireNonNull((String)"random", (Object)random);
        if (!PKCSObjectIdentifiers.id_RSASSA_PSS.equals((Object)signatureAlgId.getAlgorithm())) {
            throw new XiSecurityException("unsupported signature algorithm " + signatureAlgId.getAlgorithm());
        }
        RSASSAPSSparams asn1Params = RSASSAPSSparams.getInstance((Object)signatureAlgId.getParameters());
        ASN1ObjectIdentifier digestAlgOid = asn1Params.getHashAlgorithm().getAlgorithm();
        HashAlgo hashAlgo = HashAlgo.getInstance((ASN1ObjectIdentifier)digestAlgOid);
        if (hashAlgo == null) {
            throw new XiSecurityException("unsupported hash algorithm " + digestAlgOid.getId());
        }
        P11SlotIdentifier slotId = identityId.getSlotId();
        P11Slot slot = cryptService.getSlot(slotId);
        if (slot.supportsMechanism(13L)) {
            this.mechanism = 13L;
            this.parameters = new P11RSAPkcsPssParams(asn1Params);
            Digest digest = hashAlgo.createDigest();
            this.outputStream = new DigestOutputStream(digest);
        } else if (slot.supportsMechanism(3L)) {
            P11RSAKeyParameter keyParam;
            this.mechanism = 3L;
            this.parameters = null;
            P11PlainRSASigner cipher = new P11PlainRSASigner();
            try {
                keyParam = P11RSAKeyParameter.getInstance(cryptService, identityId);
            }
            catch (InvalidKeyException ex) {
                throw new XiSecurityException(ex.getMessage(), (Throwable)ex);
            }
            PSSSigner pssSigner = SignerUtil.createPSSRSASigner((AlgorithmIdentifier)signatureAlgId, (AsymmetricBlockCipher)cipher);
            pssSigner.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)keyParam, random));
            this.outputStream = new PSSSignerOutputStream(pssSigner);
        } else {
            Long mech = hashAlgMecMap.get(hashAlgo);
            if (mech == null) {
                throw new RuntimeException("should not reach here, unknown HashAlgo " + hashAlgo);
            }
            this.mechanism = mech;
            if (!slot.supportsMechanism(this.mechanism)) {
                throw new XiSecurityException("unsupported signature algorithm " + PKCSObjectIdentifiers.id_RSASSA_PSS.getId() + " with " + hashAlgo);
            }
            this.parameters = new P11RSAPkcsPssParams(asn1Params);
            this.outputStream = new ByteArrayOutputStream();
        }
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    public byte[] getEncodedAlgorithmIdentifier() {
        return Arrays.copyOf(this.encodedAlgorithmIdentifier, this.encodedAlgorithmIdentifier.length);
    }

    public OutputStream getOutputStream() {
        if (this.outputStream instanceof ByteArrayOutputStream) {
            ((ByteArrayOutputStream)this.outputStream).reset();
        } else if (this.outputStream instanceof DigestOutputStream) {
            ((DigestOutputStream)this.outputStream).reset();
        } else {
            ((PSSSignerOutputStream)this.outputStream).reset();
        }
        return this.outputStream;
    }

    public byte[] getSignature() {
        if (this.outputStream instanceof PSSSignerOutputStream) {
            try {
                return ((PSSSignerOutputStream)this.outputStream).generateSignature();
            }
            catch (CryptoException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex);
                throw new RuntimeCryptoException("CryptoException: " + ex.getMessage());
            }
        }
        byte[] dataToSign = this.outputStream instanceof ByteArrayOutputStream ? ((ByteArrayOutputStream)this.outputStream).toByteArray() : ((DigestOutputStream)this.outputStream).digest();
        try {
            return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, this.parameters, dataToSign);
        }
        catch (P11TokenException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"could not sign");
            throw new RuntimeCryptoException("SignerException: " + ex.getMessage());
        }
    }

    static {
        hashAlgMecMap.put(HashAlgo.SHA1, 14L);
        hashAlgMecMap.put(HashAlgo.SHA224, 71L);
        hashAlgMecMap.put(HashAlgo.SHA256, 67L);
        hashAlgMecMap.put(HashAlgo.SHA384, 68L);
        hashAlgMecMap.put(HashAlgo.SHA512, 69L);
        hashAlgMecMap.put(HashAlgo.SHA3_224, 103L);
        hashAlgMecMap.put(HashAlgo.SHA3_256, 99L);
        hashAlgMecMap.put(HashAlgo.SHA3_384, 100L);
        hashAlgMecMap.put(HashAlgo.SHA3_512, 101L);
        LOG = LoggerFactory.getLogger(P11RSAPSSContentSigner.class);
    }

    private static class PSSSignerOutputStream
    extends OutputStream {
        private PSSSigner pssSigner;

        PSSSignerOutputStream(PSSSigner pssSigner) {
            this.pssSigner = pssSigner;
        }

        @Override
        public void write(int oneByte) throws IOException {
            this.pssSigner.update((byte)oneByte);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.pssSigner.update(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.pssSigner.update(bytes, off, len);
        }

        public void reset() {
            this.pssSigner.reset();
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        byte[] generateSignature() throws DataLengthException, CryptoException {
            byte[] signature = this.pssSigner.generateSignature();
            this.pssSigner.reset();
            return signature;
        }
    }
}

