/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import org.xipki.security.HashAlgo;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.DigestOutputStream;
import org.xipki.security.pkcs11.P11PrivateKey;
import org.xipki.security.pkcs11.exception.P11TokenException;
import org.xipki.security.util.SignerUtil;

public abstract class P11DSASignatureSpi
extends SignatureSpi {
    private final HashAlgo hashAlgo;
    private long mechanism;
    private OutputStream outputStream;
    private P11PrivateKey signingKey;

    private P11DSASignatureSpi(HashAlgo hashAlgo) {
        this.hashAlgo = hashAlgo;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        throw new UnsupportedOperationException("engineInitVerify unsupported");
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof P11PrivateKey)) {
            throw new InvalidKeyException("privateKey is not instanceof " + P11PrivateKey.class.getName());
        }
        String algo = privateKey.getAlgorithm();
        if (!"DSA".equals(algo)) {
            throw new InvalidKeyException("privateKey is not a DSA private key: " + algo);
        }
        this.signingKey = (P11PrivateKey)privateKey;
        if (this.signingKey.supportsMechanism(17L)) {
            this.mechanism = 17L;
            this.outputStream = this.hashAlgo == null ? new ByteArrayOutputStream() : new DigestOutputStream(this.hashAlgo.createDigest());
        } else {
            if (this.hashAlgo == HashAlgo.SHA1 && this.signingKey.supportsMechanism(18L)) {
                this.mechanism = 18L;
            } else if (this.hashAlgo == HashAlgo.SHA224 && this.signingKey.supportsMechanism(19L)) {
                this.mechanism = 19L;
            } else if (this.hashAlgo == HashAlgo.SHA256 && this.signingKey.supportsMechanism(20L)) {
                this.mechanism = 20L;
            } else if (this.hashAlgo == HashAlgo.SHA384 && this.signingKey.supportsMechanism(21L)) {
                this.mechanism = 21L;
            } else if (this.hashAlgo == HashAlgo.SHA512 && this.signingKey.supportsMechanism(22L)) {
                this.mechanism = 22L;
            } else if (this.hashAlgo == HashAlgo.SHA3_224 && this.signingKey.supportsMechanism(24L)) {
                this.mechanism = 24L;
            } else if (this.hashAlgo == HashAlgo.SHA3_256 && this.signingKey.supportsMechanism(25L)) {
                this.mechanism = 25L;
            } else if (this.hashAlgo == HashAlgo.SHA3_384 && this.signingKey.supportsMechanism(26L)) {
                this.mechanism = 26L;
            } else if (this.hashAlgo == HashAlgo.SHA3_512 && this.signingKey.supportsMechanism(27L)) {
                this.mechanism = 27L;
            } else {
                throw new InvalidKeyException("privateKey and algorithm does not match");
            }
            this.outputStream = new ByteArrayOutputStream();
        }
        this.signingKey = (P11PrivateKey)privateKey;
    }

    @Override
    protected void engineUpdate(byte input) throws SignatureException {
        try {
            this.outputStream.write(input);
        }
        catch (IOException ex) {
            throw new SignatureException("IOException: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected void engineUpdate(byte[] input, int off, int len) throws SignatureException {
        try {
            this.outputStream.write(input, off, len);
        }
        catch (IOException ex) {
            throw new SignatureException("IOException: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] dataToSign;
        if (this.outputStream instanceof ByteArrayOutputStream) {
            dataToSign = ((ByteArrayOutputStream)this.outputStream).toByteArray();
            ((ByteArrayOutputStream)this.outputStream).reset();
        } else {
            dataToSign = ((DigestOutputStream)this.outputStream).digest();
            ((DigestOutputStream)this.outputStream).reset();
        }
        try {
            byte[] plainSignature = this.signingKey.sign(this.mechanism, null, dataToSign);
            return SignerUtil.dsaSigPlainToX962((byte[])plainSignature);
        }
        catch (XiSecurityException | P11TokenException ex) {
            throw new SignatureException(ex.getMessage(), ex);
        }
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        throw new UnsupportedOperationException("engineVerify unsupported");
    }

    public static class SHA3_512
    extends P11DSASignatureSpi {
        public SHA3_512() {
            super(HashAlgo.SHA3_512);
        }
    }

    public static class SHA3_384
    extends P11DSASignatureSpi {
        public SHA3_384() {
            super(HashAlgo.SHA3_384);
        }
    }

    public static class SHA3_256
    extends P11DSASignatureSpi {
        public SHA3_256() {
            super(HashAlgo.SHA3_256);
        }
    }

    public static class SHA3_224
    extends P11DSASignatureSpi {
        public SHA3_224() {
            super(HashAlgo.SHA3_224);
        }
    }

    public static class SHA512
    extends P11DSASignatureSpi {
        public SHA512() {
            super(HashAlgo.SHA512);
        }
    }

    public static class SHA384
    extends P11DSASignatureSpi {
        public SHA384() {
            super(HashAlgo.SHA384);
        }
    }

    public static class SHA256
    extends P11DSASignatureSpi {
        public SHA256() {
            super(HashAlgo.SHA256);
        }
    }

    public static class SHA224
    extends P11DSASignatureSpi {
        public SHA224() {
            super(HashAlgo.SHA224);
        }
    }

    public static class SHA1
    extends P11DSASignatureSpi {
        public SHA1() {
            super(HashAlgo.SHA1);
        }
    }

    public static class NONE
    extends P11DSASignatureSpi {
        public NONE() {
            super(null);
        }
    }
}

