/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs12;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.SignerFactory;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs12.SoftTokenContentSignerBuilder;
import org.xipki.security.pkcs12.SoftTokenMacContentSignerBuilder;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.StringUtil;

public class PKCS12SignerFactory
implements SignerFactory {
    private static final String TYPE_PKCS12 = "pkcs12";
    private static final String TYPE_JKS = "jks";
    private static final String TYPE_JCEKS = "jceks";
    private static final Set<String> types = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("pkcs12", "jks", "jceks")));
    private SecurityFactory securityFactory;

    public void setSecurityFactory(SecurityFactory securityFactory) {
        this.securityFactory = securityFactory;
    }

    public Set<String> getSupportedSignerTypes() {
        return types;
    }

    public boolean canCreateSigner(String type) {
        return types.contains(type.toLowerCase());
    }

    public ConcurrentContentSigner newSigner(String type, SignerConf conf, X509Certificate[] certificateChain) throws ObjectCreationException {
        InputStream keystoreStream;
        char[] password;
        String passwordHint;
        if (!this.canCreateSigner(type)) {
            throw new ObjectCreationException("unknown signer type " + type);
        }
        String str = conf.getConfValue("parallelism");
        int parallelism = this.securityFactory.getDfltSignerParallelism();
        if (str != null) {
            try {
                parallelism = Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                throw new ObjectCreationException("invalid parallelism " + str);
            }
            if (parallelism < 1) {
                throw new ObjectCreationException("invalid parallelism " + str);
            }
        }
        if ((passwordHint = conf.getConfValue("password")) == null) {
            password = null;
        } else {
            PasswordResolver passwordResolver = this.securityFactory.getPasswordResolver();
            if (passwordResolver == null) {
                password = passwordHint.toCharArray();
            } else {
                try {
                    password = passwordResolver.resolvePassword(passwordHint);
                }
                catch (PasswordResolverException ex) {
                    throw new ObjectCreationException("could not resolve password. Message: " + ex.getMessage());
                }
            }
        }
        str = conf.getConfValue("keystore");
        String keyLabel = conf.getConfValue("key-label");
        if (StringUtil.startsWithIgnoreCase((String)str, (String)"base64:")) {
            keystoreStream = new ByteArrayInputStream(Base64.decode((String)str.substring("base64:".length())));
        } else if (StringUtil.startsWithIgnoreCase((String)str, (String)"file:")) {
            String fn = str.substring("file:".length());
            try {
                keystoreStream = new FileInputStream(IoUtil.expandFilepath((String)fn));
            }
            catch (FileNotFoundException ex) {
                throw new ObjectCreationException("file not found: " + fn);
            }
        } else {
            throw new ObjectCreationException("unknown keystore content format");
        }
        try {
            AlgorithmIdentifier signatureAlgId;
            AlgorithmIdentifier macAlgId = null;
            String algoName = conf.getConfValue("algo");
            if (algoName != null) {
                try {
                    macAlgId = AlgorithmUtil.getMacAlgId((String)algoName);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            if (macAlgId != null) {
                SoftTokenMacContentSignerBuilder signerBuilder = new SoftTokenMacContentSignerBuilder(type, keystoreStream, password, keyLabel, password);
                return signerBuilder.createSigner(macAlgId, parallelism, this.securityFactory.getRandom4Sign());
            }
            SoftTokenContentSignerBuilder signerBuilder = new SoftTokenContentSignerBuilder(type, keystoreStream, password, keyLabel, password, certificateChain);
            if (conf.getHashAlgo() == null) {
                signatureAlgId = AlgorithmUtil.getSigAlgId(null, (SignerConf)conf);
            } else {
                PublicKey pubKey = signerBuilder.getCertificate().getPublicKey();
                signatureAlgId = AlgorithmUtil.getSigAlgId((PublicKey)pubKey, (SignerConf)conf);
            }
            return signerBuilder.createSigner(signatureAlgId, parallelism, this.securityFactory.getRandom4Sign());
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException | XiSecurityException ex) {
            throw new ObjectCreationException(String.format("%s: %s", ex.getClass().getName(), ex.getMessage()));
        }
    }
}

