/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.util.Date;
import org.xipki.security.CrlReason;
import org.xipki.util.ConfPairs;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

public class CertRevocationInfo {
    private CrlReason reason;
    private Date revocationTime;
    private Date invalidityTime;

    public CertRevocationInfo(CrlReason reason) {
        this(reason, new Date(), null);
    }

    public CertRevocationInfo(CrlReason reason, Date revocationTime) {
        this(reason, revocationTime, null);
    }

    public CertRevocationInfo(CrlReason reason, Date revocationTime, Date invalidityTime) {
        this.reason = (CrlReason)((Object)ParamUtil.requireNonNull((String)"reason", (Object)((Object)reason)));
        this.revocationTime = (Date)ParamUtil.requireNonNull((String)"revocationTime", (Object)revocationTime);
        this.invalidityTime = invalidityTime;
    }

    public CertRevocationInfo(int reasonCode) {
        this(reasonCode, new Date(), null);
    }

    public CertRevocationInfo(int reasonCode, Date revocationTime) {
        this(reasonCode, revocationTime, null);
    }

    public CertRevocationInfo(int reasonCode, Date revocationTime, Date invalidityTime) {
        this.revocationTime = (Date)ParamUtil.requireNonNull((String)"revocationTime", (Object)revocationTime);
        this.reason = CrlReason.forReasonCode(reasonCode);
        this.invalidityTime = invalidityTime;
    }

    public void setReason(CrlReason reason) {
        this.reason = (CrlReason)((Object)ParamUtil.requireNonNull((String)"reason", (Object)((Object)reason)));
    }

    public CrlReason getReason() {
        return this.reason;
    }

    public void setRevocationTime(Date revocationTime) {
        this.revocationTime = (Date)ParamUtil.requireNonNull((String)"revocationTime", (Object)revocationTime);
    }

    public Date getRevocationTime() {
        if (this.revocationTime == null) {
            this.revocationTime = new Date();
        }
        return this.revocationTime;
    }

    public Date getInvalidityTime() {
        return this.invalidityTime;
    }

    public void setInvalidityTime(Date invalidityTime) {
        this.invalidityTime = invalidityTime;
    }

    public String toString() {
        return StringUtil.concatObjects((Object)"reason: ", (Object[])new Object[]{this.reason, "\nrevocationTime: ", this.revocationTime, "\ninvalidityTime: ", this.invalidityTime});
    }

    public static CertRevocationInfo fromEncoded(String encoded) {
        ConfPairs pairs = new ConfPairs(encoded);
        CrlReason reason = CrlReason.forNameOrText(pairs.value("reason"));
        Date revocationTime = new Date(1000L * Long.parseLong(pairs.value("revocationTime")));
        String str = pairs.value("invalidityTime");
        Date invalidityTime = null;
        if (str != null) {
            invalidityTime = new Date(1000L * Long.parseLong(pairs.value("invalidityTime")));
        }
        return new CertRevocationInfo(reason, revocationTime, invalidityTime);
    }

    public String getEncoded() {
        ConfPairs pairs = new ConfPairs();
        pairs.putPair("reason", this.reason.getDescription());
        pairs.putPair("revocationTime", Long.toString(this.revocationTime.getTime() / 1000L));
        if (this.invalidityTime != null) {
            pairs.putPair("invalidityTime", Long.toString(this.invalidityTime.getTime() / 1000L));
        }
        return pairs.getEncoded();
    }
}

