/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import org.xipki.security.HashAlgo;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.util.ConfPairs;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

public class SignerConf {
    private final ConfPairs confPairs;
    private final HashAlgo hashAlgo;
    private final SignatureAlgoControl signatureAlgoControl;

    public SignerConf(String conf) {
        this.hashAlgo = null;
        this.signatureAlgoControl = null;
        ParamUtil.requireNonBlank((String)"conf", (String)conf);
        this.confPairs = new ConfPairs(conf);
        if (this.getConfValue("algo") == null) {
            throw new IllegalArgumentException("conf must contain the entry 'algo'");
        }
    }

    public SignerConf(String confWithoutAlgo, HashAlgo hashAlgo, SignatureAlgoControl signatureAlgoControl) {
        ParamUtil.requireNonBlank((String)"confWithoutAlgo", (String)confWithoutAlgo);
        this.hashAlgo = (HashAlgo)((Object)ParamUtil.requireNonNull((String)"hashAlgo", (Object)((Object)hashAlgo)));
        this.signatureAlgoControl = signatureAlgoControl;
        this.confPairs = new ConfPairs(confWithoutAlgo);
        if (this.getConfValue("algo") != null) {
            throw new IllegalArgumentException("confWithoutAlgo must not contain the entry 'algo'");
        }
    }

    public HashAlgo getHashAlgo() {
        return this.hashAlgo;
    }

    public SignatureAlgoControl getSignatureAlgoControl() {
        return this.signatureAlgoControl;
    }

    public void putConfEntry(String name, String value) {
        this.confPairs.putPair(name, value);
    }

    public void removeConfEntry(String name) {
        this.confPairs.removePair(name);
    }

    public String getConfValue(String name) {
        return this.confPairs.value(name);
    }

    public String getConf() {
        return this.confPairs.getEncoded();
    }

    public String toString() {
        return this.toString(true, true);
    }

    public String toString(boolean verbose, boolean ignoreSensitiveInfo) {
        String conf = this.getConf();
        if (ignoreSensitiveInfo) {
            conf = SignerConf.eraseSensitiveData(conf);
        }
        StringBuilder sb = new StringBuilder(conf.length() + 50);
        sb.append("conf: ");
        sb.append(conf);
        if (this.hashAlgo != null) {
            sb.append("\nhash algo: ").append(this.hashAlgo.getName());
        }
        if (this.signatureAlgoControl != null) {
            sb.append("\nsiganture algo control: ").append(this.signatureAlgoControl);
        }
        return sb.toString();
    }

    public static String eraseSensitiveData(String conf) {
        if (conf == null || !conf.toLowerCase().contains("password")) {
            return conf;
        }
        try {
            ConfPairs pairs = new ConfPairs(conf);
            for (String name : pairs.names()) {
                String value;
                if (!name.toLowerCase().contains("password") || (value = pairs.value(name)) == null || StringUtil.startsWithIgnoreCase((String)value, (String)"PBE:")) continue;
                pairs.putPair(name, "<sensitive>");
            }
            return pairs.getEncoded();
        }
        catch (Exception ex) {
            return conf;
        }
    }
}

