/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.SignerFactory;
import org.xipki.security.SignerFactoryRegister;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.ParamUtil;

public class SignerFactoryRegisterImpl
implements SignerFactoryRegister {
    private static final Logger LOG = LoggerFactory.getLogger(SignerFactoryRegisterImpl.class);
    private ConcurrentLinkedDeque<SignerFactory> services = new ConcurrentLinkedDeque();

    @Override
    public Set<String> getSupportedSignerTypes() {
        HashSet<String> types = new HashSet<String>();
        for (SignerFactory service : this.services) {
            types.addAll(service.getSupportedSignerTypes());
        }
        return Collections.unmodifiableSet(types);
    }

    public void bindService(SignerFactory service) {
        if (service == null) {
            LOG.info("bindService invoked with null.");
            return;
        }
        boolean replaced = this.services.remove(service);
        this.services.add(service);
        String action = replaced ? "replaced" : "added";
        LOG.info("{} SignerFactory binding for {}", (Object)action, (Object)service);
    }

    public void unbindService(SignerFactory service) {
        if (service == null) {
            LOG.info("unbindService invoked with null.");
            return;
        }
        if (this.services.remove(service)) {
            LOG.info("removed SignerFactory binding for {}", (Object)service);
        } else {
            LOG.info("no SignerFactory binding found to remove for '{}'", (Object)service);
        }
    }

    @Override
    public ConcurrentContentSigner newSigner(SecurityFactory securityFactory, String type, SignerConf conf, X509Certificate[] certificateChain) throws ObjectCreationException {
        ParamUtil.requireNonBlank((String)"type", (String)type);
        for (SignerFactory service : this.services) {
            if (!service.canCreateSigner(type)) continue;
            return service.newSigner(type, conf, certificateChain);
        }
        throw new ObjectCreationException("could not find Factory to create Signer of type " + type);
    }
}

