/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.util;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.dsa.DSAUtil;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.util.BigIntegers;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.DSAParameterCache;
import org.xipki.util.ParamUtil;

public class KeyUtil {
    private static final Map<String, KeyFactory> KEY_FACTORIES = new HashMap<String, KeyFactory>();
    private static final Map<String, KeyPairGenerator> KEYPAIR_GENERATORS = new HashMap<String, KeyPairGenerator>();

    private KeyUtil() {
    }

    public static KeyStore getKeyStore(String storeType) throws KeyStoreException {
        ParamUtil.requireNonBlank((String)"storeType", (String)storeType);
        if ("JKS".equalsIgnoreCase(storeType) || "JCEKS".equalsIgnoreCase(storeType)) {
            return KeyStore.getInstance(storeType);
        }
        try {
            return KeyStore.getInstance(storeType, "BC");
        }
        catch (KeyStoreException | NoSuchProviderException ex) {
            return KeyStore.getInstance(storeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair generateRSAKeypair(int keysize, BigInteger publicExponent, SecureRandom random) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator kpGen;
        BigInteger tmpPublicExponent = publicExponent;
        if (tmpPublicExponent == null) {
            tmpPublicExponent = RSAKeyGenParameterSpec.F4;
        }
        RSAKeyGenParameterSpec params = new RSAKeyGenParameterSpec(keysize, tmpPublicExponent);
        KeyPairGenerator keyPairGenerator = kpGen = KeyUtil.getKeyPairGenerator("RSA");
        synchronized (keyPairGenerator) {
            if (random == null) {
                kpGen.initialize(params);
            } else {
                kpGen.initialize(params, random);
            }
            return kpGen.generateKeyPair();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair generateDSAKeypair(int plength, int qlength, SecureRandom random) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator kpGen;
        DSAParameterSpec dsaParamSpec = DSAParameterCache.getDSAParameterSpec(plength, qlength, random);
        KeyPairGenerator keyPairGenerator = kpGen = KeyUtil.getKeyPairGenerator("DSA");
        synchronized (keyPairGenerator) {
            kpGen.initialize(dsaParamSpec, random);
            return kpGen.generateKeyPair();
        }
    }

    public static KeyPair generateDSAKeypair(DSAParameters dsaParams, SecureRandom random) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        DSAParameterSpec dsaParamSpec = new DSAParameterSpec(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG());
        return KeyUtil.generateDSAKeypair(dsaParamSpec, random);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair generateDSAKeypair(DSAParameterSpec dsaParamSpec, SecureRandom random) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator kpGen;
        KeyPairGenerator keyPairGenerator = kpGen = KeyUtil.getKeyPairGenerator("DSA");
        synchronized (keyPairGenerator) {
            kpGen.initialize(dsaParamSpec, random);
            return kpGen.generateKeyPair();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DSAPublicKey generateDSAPublicKey(DSAPublicKeySpec keySpec) throws InvalidKeySpecException {
        KeyFactory kf;
        ParamUtil.requireNonNull((String)"keySpec", (Object)keySpec);
        KeyFactory keyFactory = kf = KeyUtil.getKeyFactory("DSA");
        synchronized (keyFactory) {
            return (DSAPublicKey)kf.generatePublic(keySpec);
        }
    }

    public static KeyPair generateECKeypairForCurveNameOrOid(String curveNameOrOid, SecureRandom random) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        ASN1ObjectIdentifier oid = AlgorithmUtil.getCurveOidForCurveNameOrOid(curveNameOrOid);
        if (oid == null) {
            throw new IllegalArgumentException("invalid curveNameOrOid '" + curveNameOrOid + "'");
        }
        return KeyUtil.generateECKeypair(oid, random);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair generateECKeypair(ASN1ObjectIdentifier curveId, SecureRandom random) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator kpGen;
        ParamUtil.requireNonNull((String)"curveId", (Object)curveId);
        ECGenParameterSpec spec = new ECGenParameterSpec(curveId.getId());
        KeyPairGenerator keyPairGenerator = kpGen = KeyUtil.getKeyPairGenerator("EC");
        synchronized (keyPairGenerator) {
            if (random == null) {
                kpGen.initialize(spec);
            } else {
                kpGen.initialize(spec, random);
            }
            return kpGen.generateKeyPair();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyFactory getKeyFactory(String algorithm) throws InvalidKeySpecException {
        String alg = algorithm.toUpperCase();
        if ("ECDSA".equals(alg)) {
            alg = "EC";
        }
        Map<String, KeyFactory> map = KEY_FACTORIES;
        synchronized (map) {
            KeyFactory kf = KEY_FACTORIES.get(algorithm);
            if (kf != null) {
                return kf;
            }
            try {
                kf = KeyFactory.getInstance(algorithm, "BC");
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
                throw new InvalidKeySpecException("could not find KeyFactory for " + algorithm + ": " + ex.getMessage());
            }
            KEY_FACTORIES.put(algorithm, kf);
            return kf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyPairGenerator getKeyPairGenerator(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        String alg = algorithm.toUpperCase();
        if ("ECDSA".equals(alg)) {
            alg = "EC";
        }
        Map<String, KeyPairGenerator> map = KEYPAIR_GENERATORS;
        synchronized (map) {
            KeyPairGenerator kg = KEYPAIR_GENERATORS.get(algorithm);
            if (kg != null) {
                return kg;
            }
            kg = KeyPairGenerator.getInstance(algorithm, "BC");
            KEYPAIR_GENERATORS.put(algorithm, kg);
            return kg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKey generatePublicKey(SubjectPublicKeyInfo pkInfo) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory kf;
        String algorithm;
        X509EncodedKeySpec keyspec;
        ParamUtil.requireNonNull((String)"pkInfo", (Object)pkInfo);
        try {
            keyspec = new X509EncodedKeySpec(pkInfo.getEncoded());
        }
        catch (IOException ex) {
            throw new InvalidKeySpecException(ex.getMessage(), ex);
        }
        ASN1ObjectIdentifier aid = pkInfo.getAlgorithm().getAlgorithm();
        if (PKCSObjectIdentifiers.rsaEncryption.equals((Object)aid)) {
            algorithm = "RSA";
        } else if (X9ObjectIdentifiers.id_dsa.equals((Object)aid)) {
            algorithm = "DSA";
        } else if (X9ObjectIdentifiers.id_ecPublicKey.equals((Object)aid)) {
            algorithm = "EC";
        } else {
            throw new InvalidKeySpecException("unsupported key algorithm: " + aid);
        }
        KeyFactory keyFactory = kf = KeyUtil.getKeyFactory(algorithm);
        synchronized (keyFactory) {
            return kf.generatePublic(keyspec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.security.interfaces.RSAPublicKey generateRSAPublicKey(RSAPublicKeySpec keySpec) throws InvalidKeySpecException {
        KeyFactory kf;
        ParamUtil.requireNonNull((String)"keySpec", (Object)keySpec);
        KeyFactory keyFactory = kf = KeyUtil.getKeyFactory("RSA");
        synchronized (keyFactory) {
            return (java.security.interfaces.RSAPublicKey)kf.generatePublic(keySpec);
        }
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        ParamUtil.requireNonNull((String)"key", (Object)key);
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsaKey = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeyParameters(rsaKey.getModulus(), rsaKey.getPublicExponent(), rsaKey.getPrivateExponent(), rsaKey.getPrimeP(), rsaKey.getPrimeQ(), rsaKey.getPrimeExponentP(), rsaKey.getPrimeExponentQ(), rsaKey.getCrtCoefficient());
        }
        if (key instanceof RSAPrivateKey) {
            RSAPrivateKey rsaKey = (RSAPrivateKey)key;
            return new RSAKeyParameters(true, rsaKey.getModulus(), rsaKey.getPrivateExponent());
        }
        if (key instanceof ECPrivateKey) {
            return ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        }
        if (key instanceof DSAPrivateKey) {
            return DSAUtil.generatePrivateKeyParameter((PrivateKey)key);
        }
        throw new InvalidKeyException("unknown key " + key.getClass().getName());
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        ParamUtil.requireNonNull((String)"key", (Object)key);
        if (key instanceof java.security.interfaces.RSAPublicKey) {
            java.security.interfaces.RSAPublicKey rsaKey = (java.security.interfaces.RSAPublicKey)key;
            return new RSAKeyParameters(false, rsaKey.getModulus(), rsaKey.getPublicExponent());
        }
        if (key instanceof ECPublicKey) {
            return ECUtil.generatePublicKeyParameter((PublicKey)key);
        }
        if (key instanceof DSAPublicKey) {
            return DSAUtil.generatePublicKeyParameter((PublicKey)key);
        }
        throw new InvalidKeyException("unknown key " + key.getClass().getName());
    }

    public static SubjectPublicKeyInfo createSubjectPublicKeyInfo(PublicKey publicKey) throws InvalidKeyException {
        ParamUtil.requireNonNull((String)"publicKey", (Object)publicKey);
        if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dsaPubKey = (DSAPublicKey)publicKey;
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)new ASN1Integer(dsaPubKey.getParams().getP()));
            vec.add((ASN1Encodable)new ASN1Integer(dsaPubKey.getParams().getQ()));
            vec.add((ASN1Encodable)new ASN1Integer(dsaPubKey.getParams().getG()));
            DERSequence dssParams = new DERSequence(vec);
            try {
                return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)dssParams), (ASN1Encodable)new ASN1Integer(dsaPubKey.getY()));
            }
            catch (IOException ex) {
                throw new InvalidKeyException(ex.getMessage(), ex);
            }
        }
        if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
            java.security.interfaces.RSAPublicKey rsaPubKey = (java.security.interfaces.RSAPublicKey)publicKey;
            try {
                return new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), (ASN1Encodable)new RSAPublicKey(rsaPubKey.getModulus(), rsaPubKey.getPublicExponent()));
            }
            catch (IOException ex) {
                throw new InvalidKeyException(ex.getMessage(), ex);
            }
        }
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey ecPubKey = (ECPublicKey)publicKey;
            ECParameterSpec paramSpec = ecPubKey.getParams();
            ASN1ObjectIdentifier curveOid = KeyUtil.detectCurveOid(paramSpec);
            if (curveOid == null) {
                throw new InvalidKeyException("Cannot find namedCurve of the given private key");
            }
            ECPoint pointW = ecPubKey.getW();
            BigInteger wx = pointW.getAffineX();
            if (wx.signum() != 1) {
                throw new InvalidKeyException("Wx is not positive");
            }
            BigInteger wy = pointW.getAffineY();
            if (wy.signum() != 1) {
                throw new InvalidKeyException("Wy is not positive");
            }
            int keysize = (paramSpec.getOrder().bitLength() + 7) / 8;
            byte[] wxBytes = BigIntegers.asUnsignedByteArray((int)keysize, (BigInteger)wx);
            byte[] wyBytes = BigIntegers.asUnsignedByteArray((int)keysize, (BigInteger)wy);
            byte[] pubKey = new byte[1 + keysize * 2];
            pubKey[0] = 4;
            System.arraycopy(wxBytes, 0, pubKey, 1, keysize);
            System.arraycopy(wyBytes, 0, pubKey, 1 + keysize, keysize);
            AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)curveOid);
            return new SubjectPublicKeyInfo(algId, pubKey);
        }
        throw new InvalidKeyException("unknown publicKey class " + publicKey.getClass().getName());
    }

    public static ECPublicKey createECPublicKey(byte[] encodedAlgorithmIdParameters, byte[] encodedPoint) throws InvalidKeySpecException {
        KeyFactory kf;
        X509EncodedKeySpec keySpec;
        ParamUtil.requireNonNull((String)"encodedAlgorithmIdParameters", (Object)encodedAlgorithmIdParameters);
        ParamUtil.requireNonNull((String)"encodedPoint", (Object)encodedPoint);
        Object algParams = encodedAlgorithmIdParameters[0] == 6 ? ASN1ObjectIdentifier.getInstance((Object)encodedAlgorithmIdParameters) : X962Parameters.getInstance((Object)encodedAlgorithmIdParameters);
        AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)algParams);
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo(algId, encodedPoint);
        try {
            keySpec = new X509EncodedKeySpec(spki.getEncoded());
        }
        catch (IOException ex) {
            throw new InvalidKeySpecException(ex.getMessage(), ex);
        }
        try {
            kf = KeyFactory.getInstance("EC", "BC");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new InvalidKeySpecException(ex.getMessage(), ex);
        }
        return (ECPublicKey)kf.generatePublic(keySpec);
    }

    private static ASN1ObjectIdentifier detectCurveOid(ECParameterSpec paramSpec) {
        org.bouncycastle.jce.spec.ECParameterSpec bcParamSpec = EC5Util.convertSpec((ECParameterSpec)paramSpec, (boolean)false);
        return ECUtil.getNamedCurveOid((org.bouncycastle.jce.spec.ECParameterSpec)bcParamSpec);
    }
}

