/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.UnsupportedEncodingException;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.operator.RuntimeOperatorException;
import org.xipki.util.Args;
import org.xipki.util.concurrent.ConcurrentBag;
import org.xipki.util.concurrent.ConcurrentBagEntry;

public class FpIdCalculator {
    private static final int PARALLELISM = 50;
    private static final ConcurrentBag<ConcurrentBagEntry<Digest>> MDS = FpIdCalculator.getMD5MessageDigests();

    private FpIdCalculator() {
    }

    private static ConcurrentBag<ConcurrentBagEntry<Digest>> getMD5MessageDigests() {
        ConcurrentBag mds = new ConcurrentBag();
        for (int i = 0; i < 50; ++i) {
            SHA1Digest md = new SHA1Digest();
            mds.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)md));
        }
        return mds;
    }

    public static long hash(String data) {
        byte[] encoded;
        Args.notNull((Object)data, (String)"data");
        try {
            encoded = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            encoded = data.getBytes();
        }
        return FpIdCalculator.hash(encoded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long hash(byte[] data) {
        Args.notNull((Object)data, (String)"data");
        ConcurrentBagEntry md0 = null;
        for (int i = 0; i < 3; ++i) {
            try {
                md0 = (ConcurrentBagEntry)MDS.borrow(10L, TimeUnit.SECONDS);
                break;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
        }
        if (md0 == null) {
            throw new RuntimeOperatorException("could not get idle MessageDigest");
        }
        try {
            Digest md = (Digest)md0.value();
            md.reset();
            md.update(data, 0, data.length);
            byte[] bytes = new byte[md.getDigestSize()];
            md.doFinal(bytes, 0);
            long l = FpIdCalculator.bytesToLong(bytes);
            return l;
        }
        finally {
            MDS.requite((ConcurrentBag.IConcurrentBagEntry)md0);
        }
    }

    private static long bytesToLong(byte[] bs) {
        int hi = bs[0] << 24 | (bs[1] & 0xFF) << 16 | (bs[2] & 0xFF) << 8 | bs[3] & 0xFF;
        int lo = bs[4] << 24 | (bs[5] & 0xFF) << 16 | (bs[6] & 0xFF) << 8 | bs[7] & 0xFF;
        return ((long)hi & 0xFFFFFFFFL) << 32 | (long)lo & 0xFFFFFFFFL;
    }
}

