/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs12;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.bc.BcDSAContentSignerBuilder;
import org.bouncycastle.operator.bc.BcECContentSignerBuilder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.xipki.security.HashAlgo;
import org.xipki.security.pkcs12.KeystoreGenerationParameters;
import org.xipki.security.pkcs12.P12KeyGenerationResult;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;

public class P12KeyGenerator {
    private static final long MIN = 60000L;
    private static final long DAY = 86400000L;

    public P12KeyGenerationResult generateRSAKeypair(int keysize, BigInteger publicExponent, KeystoreGenerationParameters params, String selfSignedCertSubject) throws Exception {
        KeyPairWithSubjectPublicKeyInfo kp = this.genRSAKeypair(keysize, publicExponent, params.getRandom());
        return P12KeyGenerator.generateIdentity(kp, params, selfSignedCertSubject);
    }

    public P12KeyGenerationResult generateDSAKeypair(int plength, int qlength, KeystoreGenerationParameters params, String selfSignedCertSubject) throws Exception {
        KeyPairWithSubjectPublicKeyInfo kp = this.genDSAKeypair(plength, qlength, params.getRandom());
        return P12KeyGenerator.generateIdentity(kp, params, selfSignedCertSubject);
    }

    public P12KeyGenerationResult generateECKeypair(String curveNameOrOid, KeystoreGenerationParameters params, String selfSignedCertSubject) throws Exception {
        KeyPairWithSubjectPublicKeyInfo kp = this.genECKeypair(curveNameOrOid, params.getRandom());
        return P12KeyGenerator.generateIdentity(kp, params, selfSignedCertSubject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P12KeyGenerationResult generateSecretKey(String algorithm, int keyBitLen, KeystoreGenerationParameters params) throws Exception {
        if (keyBitLen % 8 != 0) {
            throw new IllegalArgumentException("keyBitLen (" + keyBitLen + ") must be multiple of 8");
        }
        SecureRandom random = params.getRandom();
        if (random == null) {
            random = new SecureRandom();
        }
        byte[] keyValue = new byte[keyBitLen / 8];
        random.nextBytes(keyValue);
        SecretKeySpec secretKey = new SecretKeySpec(keyValue, algorithm);
        KeyStore ks = KeyUtil.getKeyStore("JCEKS");
        ks.load(null, params.getPassword());
        ks.setKeyEntry("main", secretKey, params.getPassword(), null);
        ByteArrayOutputStream ksStream = new ByteArrayOutputStream();
        try {
            ks.store(ksStream, params.getPassword());
        }
        finally {
            ksStream.flush();
        }
        P12KeyGenerationResult result = new P12KeyGenerationResult(ksStream.toByteArray());
        result.setKeystoreObject(ks);
        return result;
    }

    private KeyPairWithSubjectPublicKeyInfo genECKeypair(String curveNameOrOid, SecureRandom random) throws Exception {
        ASN1ObjectIdentifier curveOid = AlgorithmUtil.getCurveOidForCurveNameOrOid(curveNameOrOid);
        if (curveOid == null) {
            throw new IllegalArgumentException("invalid curveNameOrOid '" + curveNameOrOid + "'");
        }
        KeyPair kp = KeyUtil.generateECKeypair(curveOid, random);
        AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)curveOid);
        ECPublicKey pub = (ECPublicKey)kp.getPublic();
        int orderBitLength = pub.getParams().getOrder().bitLength();
        byte[] keyData = KeyUtil.getUncompressedEncodedECPoint(pub.getW(), orderBitLength);
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algId, keyData);
        return new KeyPairWithSubjectPublicKeyInfo(kp, subjectPublicKeyInfo);
    }

    private KeyPairWithSubjectPublicKeyInfo genRSAKeypair(int keysize, BigInteger publicExponent, SecureRandom random) throws Exception {
        KeyPair kp = KeyUtil.generateRSAKeypair(keysize, publicExponent, random);
        java.security.interfaces.RSAPublicKey rsaPubKey = (java.security.interfaces.RSAPublicKey)kp.getPublic();
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), (ASN1Encodable)new RSAPublicKey(rsaPubKey.getModulus(), rsaPubKey.getPublicExponent()));
        return new KeyPairWithSubjectPublicKeyInfo(kp, spki);
    }

    private KeyPairWithSubjectPublicKeyInfo genDSAKeypair(int plength, int qlength, SecureRandom random) throws Exception {
        KeyPair kp = KeyUtil.generateDSAKeypair(plength, qlength, random);
        SubjectPublicKeyInfo spki = KeyUtil.createSubjectPublicKeyInfo((DSAPublicKey)kp.getPublic());
        return new KeyPairWithSubjectPublicKeyInfo(kp, spki);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static P12KeyGenerationResult generateIdentity(KeyPairWithSubjectPublicKeyInfo kp, KeystoreGenerationParameters params, String selfSignedCertSubject) throws Exception {
        Date now = new Date();
        Date notBefore = new Date(now.getTime() - 600000L);
        Date notAfter = new Date(notBefore.getTime() + 315360000000L);
        String dnStr = selfSignedCertSubject == null ? "CN=DUMMY" : selfSignedCertSubject;
        X500Name subjectDn = new X500Name(dnStr);
        SubjectPublicKeyInfo subjectPublicKeyInfo = kp.getSubjectPublicKeyInfo();
        ContentSigner contentSigner = P12KeyGenerator.getContentSigner(kp.getKeypair().getPrivate());
        X509v3CertificateBuilder certGenerator = new X509v3CertificateBuilder(subjectDn, BigInteger.ONE, notBefore, notAfter, subjectDn, subjectPublicKeyInfo);
        KeyAndCertPair identity = new KeyAndCertPair(certGenerator.build(contentSigner), kp.getKeypair().getPrivate());
        KeyStore ks = KeyUtil.getKeyStore("PKCS12");
        ks.load(null, params.getPassword());
        ks.setKeyEntry("main", identity.getKey(), params.getPassword(), new Certificate[]{identity.getJceCert()});
        ByteArrayOutputStream ksStream = new ByteArrayOutputStream();
        try {
            ks.store(ksStream, params.getPassword());
        }
        finally {
            ksStream.flush();
        }
        P12KeyGenerationResult result = new P12KeyGenerationResult(ksStream.toByteArray());
        result.setKeystoreObject(ks);
        return result;
    }

    private static ContentSigner getContentSigner(PrivateKey key) throws Exception {
        BcRSAContentSignerBuilder builder;
        if (key instanceof RSAPrivateKey) {
            ASN1ObjectIdentifier hashOid = X509ObjectIdentifiers.id_SHA1;
            ASN1ObjectIdentifier sigOid = PKCSObjectIdentifiers.sha1WithRSAEncryption;
            builder = new BcRSAContentSignerBuilder(P12KeyGenerator.buildAlgId(sigOid), P12KeyGenerator.buildAlgId(hashOid));
        } else if (key instanceof DSAPrivateKey) {
            ASN1ObjectIdentifier hashOid = X509ObjectIdentifiers.id_SHA1;
            AlgorithmIdentifier sigId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa_with_sha1);
            builder = new BcDSAContentSignerBuilder(sigId, P12KeyGenerator.buildAlgId(hashOid));
        } else if (key instanceof ECPrivateKey) {
            ASN1ObjectIdentifier sigOid;
            HashAlgo hashAlgo;
            int keysize = ((ECPrivateKey)key).getParams().getOrder().bitLength();
            if (keysize > 384) {
                hashAlgo = HashAlgo.SHA512;
                sigOid = X9ObjectIdentifiers.ecdsa_with_SHA512;
            } else if (keysize > 256) {
                hashAlgo = HashAlgo.SHA384;
                sigOid = X9ObjectIdentifiers.ecdsa_with_SHA384;
            } else if (keysize > 224) {
                hashAlgo = HashAlgo.SHA224;
                sigOid = X9ObjectIdentifiers.ecdsa_with_SHA224;
            } else if (keysize > 160) {
                hashAlgo = HashAlgo.SHA256;
                sigOid = X9ObjectIdentifiers.ecdsa_with_SHA256;
            } else {
                hashAlgo = HashAlgo.SHA1;
                sigOid = X9ObjectIdentifiers.ecdsa_with_SHA1;
            }
            builder = new BcECContentSignerBuilder(new AlgorithmIdentifier(sigOid), P12KeyGenerator.buildAlgId(hashAlgo.getOid()));
        } else {
            throw new IllegalArgumentException("unknown type of key " + key.getClass().getName());
        }
        return builder.build(KeyUtil.generatePrivateKeyParameter(key));
    }

    private static AlgorithmIdentifier buildAlgId(ASN1ObjectIdentifier identifier) {
        return new AlgorithmIdentifier(identifier, (ASN1Encodable)DERNull.INSTANCE);
    }

    static class KeyAndCertPair {
        private final X509CertificateHolder cert;
        private final X509Certificate jceCert;
        private final PrivateKey key;

        KeyAndCertPair(X509CertificateHolder cert, PrivateKey key) throws CertificateException {
            this.cert = cert;
            this.key = key;
            this.jceCert = X509Util.toX509Cert(cert.toASN1Structure());
        }

        public X509CertificateHolder getCert() {
            return this.cert;
        }

        public Certificate getJceCert() {
            return this.jceCert;
        }

        public PrivateKey getKey() {
            return this.key;
        }
    }

    private static class KeyPairWithSubjectPublicKeyInfo {
        private KeyPair keypair;
        private SubjectPublicKeyInfo subjectPublicKeyInfo;

        KeyPairWithSubjectPublicKeyInfo(KeyPair keypair, SubjectPublicKeyInfo subjectPublicKeyInfo) throws InvalidKeySpecException {
            this.keypair = keypair;
            this.subjectPublicKeyInfo = X509Util.toRfc3279Style(subjectPublicKeyInfo);
        }

        public KeyPair getKeypair() {
            return this.keypair;
        }

        public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
            return this.subjectPublicKeyInfo;
        }
    }
}

