/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverImpl;
import org.xipki.password.SinglePasswordResolver;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SecurityFactoryImpl;
import org.xipki.security.SignerFactory;
import org.xipki.security.SignerFactoryRegisterImpl;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11CryptServiceFactoryImpl;
import org.xipki.security.pkcs11.P11ModuleFactoryRegisterImpl;
import org.xipki.security.pkcs11.P11SignerFactory;
import org.xipki.security.pkcs11.emulator.EmulatorP11ModuleFactory;
import org.xipki.security.pkcs11.iaik.IaikP11ModuleFactory;
import org.xipki.security.pkcs11.proxy.ProxyP11ModuleFactory;
import org.xipki.security.pkcs12.P12SignerFactory;
import org.xipki.util.InvalidConfException;

public class Securities
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Securities.class);
    private static final String DFLT_PASSWORD_CFG = "xipki/etc/org.xipki.password.cfg";
    private static final String DFLT_SECURITY_CFG = "xipki/etc/org.xipki.security.cfg";
    private String passwordCfg;
    private String securityCfg;
    private PasswordResolverImpl passwordResolver;
    private P11ModuleFactoryRegisterImpl p11ModuleFactoryRegister;
    private P11CryptServiceFactoryImpl p11CryptServiceFactory;
    private SecurityFactoryImpl securityFactory;

    public void setPasswordCfg(String file) {
        this.passwordCfg = file;
    }

    public void setSecuirtyCfg(String file) {
        this.securityCfg = file;
    }

    public SecurityFactory getSecurityFactory() {
        return this.securityFactory;
    }

    public P11CryptServiceFactory getP11CryptServiceFactory() {
        return this.p11CryptServiceFactory;
    }

    public void init() throws IOException, InvalidConfException {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        this.initPassword();
        this.initSecurityFactory();
    }

    @Override
    public void close() {
        if (this.p11ModuleFactoryRegister != null) {
            try {
                this.p11ModuleFactoryRegister.close();
            }
            catch (Throwable th) {
                LOG.error("error while closing P11ModuleFactoryRegister", th);
            }
            this.p11ModuleFactoryRegister = null;
        }
        if (this.p11CryptServiceFactory != null) {
            try {
                this.p11CryptServiceFactory.close();
            }
            catch (Throwable th) {
                LOG.error("error while closing P11CryptServiceFactory", th);
            }
            this.p11CryptServiceFactory = null;
        }
    }

    private void initPassword() throws IOException, InvalidConfException {
        String[] classNames;
        this.passwordResolver = new PasswordResolverImpl();
        Properties props = Securities.loadProperties(this.passwordCfg, DFLT_PASSWORD_CFG);
        String masterPasswordCallback = Securities.getString(props, "masterPassword.callback", "FILE file=xipki/security/masterpassword.secret");
        this.passwordResolver.setMasterPasswordCallback(masterPasswordCallback);
        this.passwordResolver.init();
        String list = Securities.getString(props, "additional.singlePasswordResolvers", null);
        String[] stringArray = classNames = list == null ? null : list.split(", ");
        if (classNames != null) {
            for (String className : classNames) {
                try {
                    Class<?> clazz = Class.forName(className);
                    SinglePasswordResolver resolver = (SinglePasswordResolver)clazz.newInstance();
                    this.passwordResolver.registResolver(resolver);
                }
                catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    throw new InvalidConfException("error caught while initializing SinglePasswordResolver " + className + ": " + ex.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private void initSecurityFactory() throws IOException, InvalidConfException {
        String[] classNames;
        this.securityFactory = new SecurityFactoryImpl();
        Properties props = Securities.loadProperties(this.securityCfg, DFLT_SECURITY_CFG);
        this.securityFactory.setStrongRandom4SignEnabled(Securities.getBoolean(props, "sign.strongrandom.enabled", false));
        this.securityFactory.setStrongRandom4KeyEnabled(Securities.getBoolean(props, "key.strongrandom.enabled", false));
        this.securityFactory.setDefaultSignerParallelism(Securities.getInt(props, "defaultSignerParallelism", 32));
        SignerFactoryRegisterImpl signerFactoryRegister = new SignerFactoryRegisterImpl();
        this.securityFactory.setSignerFactoryRegister(signerFactoryRegister);
        this.securityFactory.setPasswordResolver((PasswordResolver)this.passwordResolver);
        this.initSecurityPkcs12(signerFactoryRegister);
        String pkcs11ConfFile = Securities.getString(props, "pkcs11.confFile", "xipki/security/pkcs11.json");
        this.initSecurityPkcs11(pkcs11ConfFile, signerFactoryRegister);
        String list = Securities.getString(props, "additional.signerFactories", null);
        String[] stringArray = classNames = list == null ? null : list.split(", ");
        if (classNames != null) {
            for (String className : classNames) {
                try {
                    Class<?> clazz = Class.forName(className);
                    SignerFactory factory = (SignerFactory)clazz.newInstance();
                    signerFactoryRegister.registFactory(factory);
                }
                catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    throw new InvalidConfException("error caught while initializing SignerFactory " + className + ": " + ex.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private void initSecurityPkcs12(SignerFactoryRegisterImpl signerFactoryRegister) throws IOException {
        P12SignerFactory p12SignerFactory = new P12SignerFactory();
        p12SignerFactory.setSecurityFactory(this.securityFactory);
        signerFactoryRegister.registFactory(p12SignerFactory);
    }

    private void initSecurityPkcs11(String pkcs11ConfFile, SignerFactoryRegisterImpl signerFactoryRegister) throws InvalidConfException {
        this.p11ModuleFactoryRegister = new P11ModuleFactoryRegisterImpl();
        this.p11ModuleFactoryRegister.registFactory(new EmulatorP11ModuleFactory());
        this.p11ModuleFactoryRegister.registFactory(new IaikP11ModuleFactory());
        this.p11ModuleFactoryRegister.registFactory(new ProxyP11ModuleFactory());
        this.p11CryptServiceFactory = new P11CryptServiceFactoryImpl();
        this.p11CryptServiceFactory.setP11ModuleFactoryRegister(this.p11ModuleFactoryRegister);
        this.p11CryptServiceFactory.setPasswordResolver((PasswordResolver)this.passwordResolver);
        this.p11CryptServiceFactory.setPkcs11ConfFile(pkcs11ConfFile);
        this.p11CryptServiceFactory.init();
        P11SignerFactory p11SignerFactory = new P11SignerFactory();
        p11SignerFactory.setSecurityFactory(this.securityFactory);
        p11SignerFactory.setP11CryptServiceFactory(this.p11CryptServiceFactory);
        signerFactoryRegister.registFactory(p11SignerFactory);
    }

    public static Properties loadProperties(String path, String dfltPath) throws IOException {
        return Securities.loadProperties(path == null ? dfltPath : path);
    }

    public static Properties loadProperties(String path) throws IOException {
        Path realPath = Paths.get(path, new String[0]);
        if (!Files.exists(realPath, new LinkOption[0])) {
            throw new IOException("File " + path + " does not exist");
        }
        if (!Files.isReadable(realPath)) {
            throw new IOException("File " + path + " is not readable");
        }
        Properties props = new Properties();
        try (InputStream is = Files.newInputStream(realPath, new OpenOption[0]);){
            props.load(is);
        }
        return props;
    }

    public static String getString(Properties props, String key, String dfltValue) {
        String value = props.getProperty(key);
        return value == null ? dfltValue : value;
    }

    public static int getInt(Properties props, String key, int dfltValue) {
        String value = props.getProperty(key);
        return value == null ? dfltValue : Integer.parseInt(value);
    }

    public static boolean getBoolean(Properties props, String key, boolean dfltValue) {
        String value = props.getProperty(key);
        return value == null ? dfltValue : Boolean.parseBoolean(value);
    }
}

