/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.HashSet;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DfltConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.XiContentSigner;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11ContentSigner;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11PrivateKey;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.GMUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;

public class P11ContentSignerBuilder {
    private final PublicKey publicKey;
    private final X509Certificate[] certificateChain;
    private final P11CryptService cryptService;
    private final SecurityFactory securityFactory;
    private final P11IdentityId identityId;

    public P11ContentSignerBuilder(P11CryptService cryptService, SecurityFactory securityFactory, P11IdentityId identityId, X509Certificate[] certificateChain) throws XiSecurityException, P11TokenException {
        int i;
        X509Certificate cert;
        PublicKey publicKeyInP11;
        this.cryptService = (P11CryptService)Args.notNull((Object)cryptService, (String)"cryptService");
        this.securityFactory = (SecurityFactory)Args.notNull((Object)securityFactory, (String)"securityFactory");
        this.identityId = (P11IdentityId)Args.notNull((Object)identityId, (String)"identityId");
        P11Identity identity = cryptService.getIdentity(identityId);
        X509Certificate signerCertInP11 = identity.getCertificate();
        PublicKey publicKey = publicKeyInP11 = signerCertInP11 != null ? signerCertInP11.getPublicKey() : identity.getPublicKey();
        if (publicKeyInP11 == null) {
            throw new XiSecurityException("public key with " + identityId + " does not exist");
        }
        HashSet<X509Certificate> caCerts = new HashSet<X509Certificate>();
        if (certificateChain != null && certificateChain.length > 0) {
            int n = certificateChain.length;
            cert = certificateChain[0];
            if (n > 1) {
                for (i = 1; i < n; ++i) {
                    caCerts.add(certificateChain[i]);
                }
            }
            this.publicKey = cert.getPublicKey();
        } else {
            this.publicKey = publicKeyInP11;
            cert = signerCertInP11;
        }
        if (cert != null) {
            X509Certificate[] certsInKeystore = identity.certificateChain();
            if (certsInKeystore != null && certsInKeystore.length > 1) {
                for (i = 1; i < certsInKeystore.length; ++i) {
                    caCerts.add(certsInKeystore[i]);
                }
            }
            this.certificateChain = X509Util.buildCertPath(cert, caCerts);
        } else {
            this.certificateChain = null;
        }
    }

    public ConcurrentContentSigner createSigner(AlgorithmIdentifier signatureAlgId, int parallelism) throws XiSecurityException, P11TokenException {
        DfltConcurrentContentSigner concurrentSigner;
        Args.positive((int)parallelism, (String)"parallelism");
        ArrayList<XiContentSigner> signers = new ArrayList<XiContentSigner>(parallelism);
        Boolean isSm2p256v1 = null;
        for (int i = 0; i < parallelism; ++i) {
            XiContentSigner signer;
            if (this.publicKey instanceof RSAPublicKey) {
                if (i == 0 && !AlgorithmUtil.isRSASigAlgId(signatureAlgId)) {
                    throw new XiSecurityException("the given algorithm is not a valid RSA signature algorithm '" + signatureAlgId.getAlgorithm().getId() + "'");
                }
                signer = this.createRSAContentSigner(signatureAlgId);
            } else if (this.publicKey instanceof ECPublicKey) {
                ECPublicKey ecKey = (ECPublicKey)this.publicKey;
                if (i == 0) {
                    isSm2p256v1 = GMUtil.isSm2primev2Curve(ecKey.getParams().getCurve());
                    if (isSm2p256v1.booleanValue()) {
                        if (!AlgorithmUtil.isSM2SigAlg(signatureAlgId)) {
                            throw new XiSecurityException("the given algorithm is not a valid SM2 signature algorithm '" + signatureAlgId.getAlgorithm().getId() + "'");
                        }
                    } else if (!AlgorithmUtil.isECSigAlg(signatureAlgId)) {
                        throw new XiSecurityException("the given algorithm is not a valid EC signature algorithm '" + signatureAlgId.getAlgorithm().getId() + "'");
                    }
                }
                if (isSm2p256v1.booleanValue()) {
                    ECPoint w = ecKey.getW();
                    signer = this.createSM2ContentSigner(signatureAlgId, GMObjectIdentifiers.sm2p256v1, w.getAffineX(), w.getAffineY());
                } else {
                    signer = this.createECContentSigner(signatureAlgId);
                }
            } else if (this.publicKey instanceof DSAPublicKey) {
                if (i == 0 && !AlgorithmUtil.isDSASigAlg(signatureAlgId)) {
                    throw new XiSecurityException("the given algorithm is not a valid DSA signature algorithm '" + signatureAlgId.getAlgorithm().getId() + "'");
                }
                signer = this.createDSAContentSigner(signatureAlgId);
            } else {
                throw new XiSecurityException("unsupported key " + this.publicKey.getClass().getName());
            }
            signers.add(signer);
        }
        boolean mac = false;
        P11PrivateKey privateKey = new P11PrivateKey(this.cryptService, this.identityId);
        try {
            concurrentSigner = new DfltConcurrentContentSigner(false, signers, privateKey);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XiSecurityException(ex.getMessage(), ex);
        }
        if (this.certificateChain != null) {
            concurrentSigner.setCertificateChain(this.certificateChain);
        } else {
            concurrentSigner.setPublicKey(this.publicKey);
        }
        return concurrentSigner;
    }

    private XiContentSigner createRSAContentSigner(AlgorithmIdentifier signatureAlgId) throws XiSecurityException, P11TokenException {
        if (PKCSObjectIdentifiers.id_RSASSA_PSS.equals((Object)signatureAlgId.getAlgorithm())) {
            return new P11ContentSigner.RSAPSS(this.cryptService, this.identityId, signatureAlgId, this.securityFactory.getRandom4Sign());
        }
        return new P11ContentSigner.RSA(this.cryptService, this.identityId, signatureAlgId);
    }

    private XiContentSigner createECContentSigner(AlgorithmIdentifier signatureAlgId) throws XiSecurityException, P11TokenException {
        return new P11ContentSigner.ECDSA(this.cryptService, this.identityId, signatureAlgId, AlgorithmUtil.isDSAPlainSigAlg(signatureAlgId));
    }

    private XiContentSigner createSM2ContentSigner(AlgorithmIdentifier signatureAlgId, ASN1ObjectIdentifier curveOid, BigInteger pubPointX, BigInteger pubPointy) throws XiSecurityException, P11TokenException {
        return new P11ContentSigner.SM2(this.cryptService, this.identityId, signatureAlgId, curveOid, pubPointX, pubPointy);
    }

    private XiContentSigner createDSAContentSigner(AlgorithmIdentifier signatureAlgId) throws XiSecurityException, P11TokenException {
        return new P11ContentSigner.DSA(this.cryptService, this.identityId, signatureAlgId, AlgorithmUtil.isDSAPlainSigAlg(signatureAlgId));
    }
}

