/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.iaik;

import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.pkcs11.iaik.IaikP11Slot;
import org.xipki.util.Args;

class IaikP11Identity
extends P11Identity {
    private final Key signingKey;
    private final int expectedSignatureLen;

    IaikP11Identity(IaikP11Slot slot, P11IdentityId identityId, SecretKey signingKey) {
        super(slot, identityId, 0);
        this.signingKey = (Key)Args.notNull((Object)signingKey, (String)"signingKey");
        this.expectedSignatureLen = 0;
    }

    IaikP11Identity(IaikP11Slot slot, P11IdentityId identityId, PrivateKey privateKey, PublicKey publicKey, X509Certificate[] certificateChain) {
        super(slot, identityId, publicKey, certificateChain);
        this.signingKey = (Key)Args.notNull((Object)privateKey, (String)"privateKey");
        int keyBitLen = this.getSignatureKeyBitLength();
        if (publicKey instanceof RSAPublicKey) {
            this.expectedSignatureLen = (keyBitLen + 7) / 8;
        } else if (publicKey instanceof ECPublicKey) {
            this.expectedSignatureLen = (keyBitLen + 7) / 8 * 2;
        } else if (publicKey instanceof DSAPublicKey) {
            this.expectedSignatureLen = (keyBitLen + 7) / 8 * 2;
        } else {
            throw new IllegalArgumentException("currently only RSA, DSA and EC public key are supported, but not " + this.publicKey.getAlgorithm() + " (class: " + publicKey.getClass().getName() + ")");
        }
    }

    @Override
    protected byte[] digestSecretKey0(long mechanism) throws P11TokenException {
        if (!(this.signingKey instanceof SecretKey)) {
            throw new P11TokenException("could not digest asymmetric key");
        }
        Boolean bv = ((SecretKey)this.signingKey).getExtractable().getBooleanValue();
        if (bv != null && !bv.booleanValue()) {
            throw new P11TokenException("could not digest unextractable key");
        }
        bv = ((SecretKey)this.signingKey).getNeverExtractable().getBooleanValue();
        if (bv != null && bv.booleanValue()) {
            throw new P11TokenException("could not digest unextractable key");
        }
        return ((IaikP11Slot)this.slot).digestKey(mechanism, this);
    }

    @Override
    protected byte[] sign0(long mechanism, P11Params parameters, byte[] content) throws P11TokenException {
        return ((IaikP11Slot)this.slot).sign(mechanism, parameters, content, this);
    }

    Key getSigningKey() {
        return this.signingKey;
    }

    int getExpectedSignatureLen() {
        return this.expectedSignatureLen;
    }
}

