/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs12;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DfltConcurrentContentSigner;
import org.xipki.security.HashAlgo;
import org.xipki.security.XiContentSigner;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs12.AESGmacContentSigner;
import org.xipki.security.pkcs12.HmacContentSigner;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.Args;

public class P12MacContentSignerBuilder {
    private final SecretKey key;

    public P12MacContentSignerBuilder(SecretKey key) throws XiSecurityException {
        this.key = (SecretKey)Args.notNull((Object)key, (String)"key");
    }

    public P12MacContentSignerBuilder(String keystoreType, InputStream keystoreStream, char[] keystorePassword, String keyname, char[] keyPassword) throws XiSecurityException {
        if (!"JCEKS".equalsIgnoreCase(keystoreType)) {
            throw new IllegalArgumentException("unsupported keystore type: " + keystoreType);
        }
        Args.notNull((Object)keystoreStream, (String)"keystoreStream");
        Args.notNull((Object)keystorePassword, (String)"keystorePassword");
        Args.notNull((Object)keyPassword, (String)"keyPassword");
        try {
            KeyStore ks = KeyUtil.getKeyStore(keystoreType);
            ks.load(keystoreStream, keystorePassword);
            String tmpKeyname = keyname;
            if (tmpKeyname == null) {
                Enumeration<String> aliases = ks.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (!ks.isKeyEntry(alias)) continue;
                    tmpKeyname = alias;
                    break;
                }
            } else if (!ks.isKeyEntry(tmpKeyname)) {
                throw new XiSecurityException("unknown key named " + tmpKeyname);
            }
            this.key = (SecretKey)ks.getKey(tmpKeyname, keyPassword);
        }
        catch (IOException | ClassCastException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            throw new XiSecurityException(ex.getMessage(), ex);
        }
    }

    public ConcurrentContentSigner createSigner(AlgorithmIdentifier signatureAlgId, int parallelism, SecureRandom random) throws XiSecurityException {
        DfltConcurrentContentSigner concurrentSigner;
        Args.notNull((Object)signatureAlgId, (String)"signatureAlgId");
        Args.positive((int)parallelism, (String)"parallelism");
        ArrayList<XiContentSigner> signers = new ArrayList<XiContentSigner>(parallelism);
        boolean gmac = false;
        ASN1ObjectIdentifier oid = signatureAlgId.getAlgorithm();
        if (oid.equals((Object)NISTObjectIdentifiers.id_aes128_GCM) || oid.equals((Object)NISTObjectIdentifiers.id_aes192_GCM) || oid.equals((Object)NISTObjectIdentifiers.id_aes256_GCM)) {
            gmac = true;
        }
        for (int i = 0; i < parallelism; ++i) {
            XiContentSigner signer = gmac ? new AESGmacContentSigner(oid, this.key) : new HmacContentSigner(signatureAlgId, this.key);
            signers.add(signer);
        }
        boolean mac = true;
        try {
            concurrentSigner = new DfltConcurrentContentSigner(true, signers, this.key);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XiSecurityException(ex.getMessage(), ex);
        }
        concurrentSigner.setSha1DigestOfMacKey(HashAlgo.SHA1.hash(this.key.getEncoded()));
        return concurrentSigner;
    }

    public SecretKey getKey() {
        return this.key;
    }
}

