/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.util;

import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.bsi.BSIObjectIdentifiers;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.xipki.security.AlgorithmCode;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.security.SignerConf;
import org.xipki.util.Args;
import org.xipki.util.StringUtil;

public class AlgorithmUtil {
    private static final List<String> curveNames;
    private static final Map<String, ASN1ObjectIdentifier> curveNameToOidMap;
    private static final Map<ASN1ObjectIdentifier, String> curveOidToNameMap;
    private static final Map<ASN1ObjectIdentifier, AlgorithmCode> algOidToCodeMap;
    private static final Map<ASN1ObjectIdentifier, HashAlgo> sigAlgOidToDigestMap;
    private static final Map<ASN1ObjectIdentifier, HashAlgo> macAlgOidToDigestMap;
    private static final Map<HashAlgo, ASN1ObjectIdentifier> digestToECSigAlgMap;
    private static final Map<HashAlgo, ASN1ObjectIdentifier> digestToECPlainSigAlgMap;
    private static final Map<HashAlgo, ASN1ObjectIdentifier> digestToDSASigAlgMap;
    private static final Map<HashAlgo, ASN1ObjectIdentifier> digestToRSASigAlgMap;
    private static final Map<ASN1ObjectIdentifier, String> macAlgOidToNameMap;
    private static final Map<String, ASN1ObjectIdentifier> macAlgNameToOidMap;
    private static final Map<ASN1ObjectIdentifier, String> sigAlgOidToNameMap;
    private static final Map<String, ASN1ObjectIdentifier> sigAlgNameToOidMap;
    private static final Map<ASN1ObjectIdentifier, AlgorithmCode> digestToMgf1AlgCodeMap;
    private static final Map<ASN1ObjectIdentifier, String> digestOidToMgf1SigNameMap;
    private static final Map<String, HashAlgo> mgf1SigNameToDigestOidMap;

    private static void addOidNameMap(Map<ASN1ObjectIdentifier, String> oidNameMap, Map<String, ASN1ObjectIdentifier> nameOidMap, ASN1ObjectIdentifier oid, String ... names) {
        oidNameMap.put(oid, names[0].toUpperCase());
        nameOidMap.put(oid.getId(), oid);
        for (String name : names) {
            nameOidMap.put(name.toUpperCase(), oid);
        }
    }

    private static void addHashAlgoNameMap(Map<ASN1ObjectIdentifier, String> oidNameMap, Map<String, HashAlgo> nameOidMap, HashAlgo hashAlgo, String ... names) {
        oidNameMap.put(hashAlgo.getOid(), names[0].toUpperCase());
        nameOidMap.put(hashAlgo.getOid().getId(), hashAlgo);
        for (String name : names) {
            nameOidMap.put(name.toUpperCase(), hashAlgo);
        }
    }

    private AlgorithmUtil() {
    }

    public static ASN1ObjectIdentifier getHashAlg(String hashAlgName) throws NoSuchAlgorithmException {
        Args.notBlank((String)hashAlgName, (String)"hashAlgName");
        HashAlgo hashAlgo = HashAlgo.getInstance(hashAlgName.toUpperCase());
        if (hashAlgo == null) {
            throw new NoSuchAlgorithmException("Unsupported hash algorithm " + hashAlgName);
        }
        return hashAlgo.getOid();
    }

    public static int getHashOutputSizeInOctets(ASN1ObjectIdentifier hashAlgo) throws NoSuchAlgorithmException {
        Args.notNull((Object)hashAlgo, (String)"hashAlgo");
        HashAlgo hashAlgoType = HashAlgo.getInstance(hashAlgo);
        if (hashAlgoType == null) {
            throw new NoSuchAlgorithmException("Unsupported hash algorithm " + hashAlgo.getId());
        }
        return hashAlgoType.getLength();
    }

    public static AlgorithmCode getSigOrMacAlgoCode(AlgorithmIdentifier algId) throws NoSuchAlgorithmException {
        ASN1ObjectIdentifier oid = algId.getAlgorithm();
        AlgorithmCode code = algOidToCodeMap.get(oid);
        if (code != null) {
            return code;
        }
        if (PKCSObjectIdentifiers.id_RSASSA_PSS.equals((Object)oid)) {
            RSASSAPSSparams param = RSASSAPSSparams.getInstance((Object)algId.getParameters());
            ASN1ObjectIdentifier digestAlgOid = param.getHashAlgorithm().getAlgorithm();
            code = digestToMgf1AlgCodeMap.get(digestAlgOid);
            if (code == null) {
                throw new NoSuchAlgorithmException("unsupported digest algorithm " + digestAlgOid);
            }
            return code;
        }
        throw new NoSuchAlgorithmException("unsupported signature algorithm " + oid.getId());
    }

    public static String getSigOrMacAlgoName(AlgorithmIdentifier sigAlgId) throws NoSuchAlgorithmException {
        ASN1ObjectIdentifier algOid = ((AlgorithmIdentifier)Args.notNull((Object)sigAlgId, (String)"sigAlgId")).getAlgorithm();
        String name = macAlgOidToNameMap.get(algOid);
        return name != null ? name : AlgorithmUtil.getSignatureAlgoName(sigAlgId);
    }

    public static String getSignatureAlgoName(AlgorithmIdentifier sigAlgId) throws NoSuchAlgorithmException {
        ASN1ObjectIdentifier algOid = ((AlgorithmIdentifier)Args.notNull((Object)sigAlgId, (String)"sigAlgId")).getAlgorithm();
        String name = null;
        if (PKCSObjectIdentifiers.id_RSASSA_PSS.equals((Object)algOid)) {
            RSASSAPSSparams param = RSASSAPSSparams.getInstance((Object)sigAlgId.getParameters());
            ASN1ObjectIdentifier digestAlgOid = param.getHashAlgorithm().getAlgorithm();
            name = digestOidToMgf1SigNameMap.get(digestAlgOid);
            if (name == null) {
                throw new NoSuchAlgorithmException("unsupported digest algorithm " + digestAlgOid);
            }
        } else {
            name = sigAlgOidToNameMap.get(algOid);
        }
        if (name == null) {
            throw new NoSuchAlgorithmException("unsupported signature algorithm " + algOid.getId());
        }
        return name;
    }

    public static boolean isDSAPlainSigAlg(AlgorithmIdentifier algId) {
        return AlgorithmUtil.isPlainECDSASigAlg(algId);
    }

    public static String canonicalizeSignatureAlgo(String algoName) throws NoSuchAlgorithmException {
        return AlgorithmUtil.getSignatureAlgoName(AlgorithmUtil.getSigAlgId(algoName));
    }

    public static AlgorithmIdentifier getMacAlgId(String macAlgName) throws NoSuchAlgorithmException {
        String algoS = ((String)Args.notNull((Object)macAlgName, (String)"macAlgName")).toUpperCase();
        ASN1ObjectIdentifier oid = macAlgNameToOidMap.get(algoS = AlgorithmUtil.canonicalizeAlgoText(algoS));
        if (oid == null) {
            throw new NoSuchAlgorithmException("unsupported MAC algorithm " + algoS);
        }
        return new AlgorithmIdentifier(oid, (ASN1Encodable)DERNull.INSTANCE);
    }

    public static AlgorithmIdentifier getSigAlgId(String sigAlgName) throws NoSuchAlgorithmException {
        AlgorithmIdentifier signatureAlgId;
        String algoS = ((String)Args.notNull((Object)sigAlgName, (String)"sigAlgName")).toUpperCase();
        if ((algoS = AlgorithmUtil.canonicalizeAlgoText(algoS)).contains("MGF1")) {
            HashAlgo ha = mgf1SigNameToDigestOidMap.get(algoS);
            if (ha == null) {
                throw new NoSuchAlgorithmException("unknown algorithm " + algoS);
            }
            signatureAlgId = AlgorithmUtil.buildRSAPSSAlgId(ha);
        } else {
            ASN1ObjectIdentifier algOid = sigAlgNameToOidMap.get(algoS);
            if (algOid == null) {
                throw new NoSuchAlgorithmException("unknown algorithm " + algoS);
            }
            boolean withNullParam = algoS.contains("RSA");
            signatureAlgId = withNullParam ? new AlgorithmIdentifier(algOid, (ASN1Encodable)DERNull.INSTANCE) : new AlgorithmIdentifier(algOid);
        }
        return signatureAlgId;
    }

    public static AlgorithmIdentifier getSigAlgId(PublicKey pubKey, SignerConf signerConf) throws NoSuchAlgorithmException {
        if (((SignerConf)Args.notNull((Object)signerConf, (String)"signerConf")).getHashAlgo() == null) {
            return AlgorithmUtil.getSigAlgId(signerConf.getConfValue("algo"));
        }
        SignatureAlgoControl algoControl = signerConf.getSignatureAlgoControl();
        HashAlgo hashAlgo = signerConf.getHashAlgo();
        if (pubKey instanceof RSAPublicKey) {
            boolean rsaMgf1 = algoControl == null ? false : algoControl.isRsaMgf1();
            return AlgorithmUtil.getRSASigAlgId(hashAlgo, rsaMgf1);
        }
        if (pubKey instanceof ECPublicKey) {
            boolean dsaPlain = algoControl == null ? false : algoControl.isDsaPlain();
            boolean gm = algoControl == null ? false : algoControl.isGm();
            return AlgorithmUtil.getECSigAlgId(hashAlgo, dsaPlain, gm);
        }
        if (pubKey instanceof DSAPublicKey) {
            return AlgorithmUtil.getDSASigAlgId(hashAlgo);
        }
        throw new NoSuchAlgorithmException("Unknown public key '" + pubKey.getClass().getName());
    }

    public static AlgorithmIdentifier getSigAlgId(PublicKey pubKey, HashAlgo hashAlgo, SignatureAlgoControl algoControl) throws NoSuchAlgorithmException {
        Args.notNull((Object)((Object)hashAlgo), (String)"hashAlgo");
        if (pubKey instanceof RSAPublicKey) {
            boolean rsaMgf1 = algoControl == null ? false : algoControl.isRsaMgf1();
            return AlgorithmUtil.getRSASigAlgId(hashAlgo, rsaMgf1);
        }
        if (pubKey instanceof ECPublicKey) {
            boolean dsaPlain = algoControl == null ? false : algoControl.isDsaPlain();
            boolean gm = algoControl == null ? false : algoControl.isGm();
            return AlgorithmUtil.getECSigAlgId(hashAlgo, dsaPlain, gm);
        }
        if (pubKey instanceof DSAPublicKey) {
            return AlgorithmUtil.getDSASigAlgId(hashAlgo);
        }
        throw new NoSuchAlgorithmException("Unknown public key '" + pubKey.getClass().getName());
    }

    public static boolean isRSASigAlgId(AlgorithmIdentifier algId) {
        ASN1ObjectIdentifier oid = ((AlgorithmIdentifier)Args.notNull((Object)algId, (String)"algId")).getAlgorithm();
        return PKCSObjectIdentifiers.sha1WithRSAEncryption.equals((Object)oid) || PKCSObjectIdentifiers.sha224WithRSAEncryption.equals((Object)oid) || PKCSObjectIdentifiers.sha256WithRSAEncryption.equals((Object)oid) || PKCSObjectIdentifiers.sha384WithRSAEncryption.equals((Object)oid) || PKCSObjectIdentifiers.sha512WithRSAEncryption.equals((Object)oid) || NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224.equals((Object)oid) || NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256.equals((Object)oid) || NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384.equals((Object)oid) || NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512.equals((Object)oid) || PKCSObjectIdentifiers.id_RSASSA_PSS.equals((Object)oid);
    }

    public static boolean isECSigAlg(AlgorithmIdentifier algId) {
        return AlgorithmUtil.isECDSASigAlg(algId) || AlgorithmUtil.isPlainECDSASigAlg(algId);
    }

    private static boolean isECDSASigAlg(AlgorithmIdentifier algId) {
        ASN1ObjectIdentifier oid = ((AlgorithmIdentifier)Args.notNull((Object)algId, (String)"algId")).getAlgorithm();
        return X9ObjectIdentifiers.ecdsa_with_SHA1.equals((Object)oid) || X9ObjectIdentifiers.ecdsa_with_SHA224.equals((Object)oid) || X9ObjectIdentifiers.ecdsa_with_SHA256.equals((Object)oid) || X9ObjectIdentifiers.ecdsa_with_SHA384.equals((Object)oid) || X9ObjectIdentifiers.ecdsa_with_SHA512.equals((Object)oid) || NISTObjectIdentifiers.id_ecdsa_with_sha3_224.equals((Object)oid) || NISTObjectIdentifiers.id_ecdsa_with_sha3_256.equals((Object)oid) || NISTObjectIdentifiers.id_ecdsa_with_sha3_384.equals((Object)oid) || NISTObjectIdentifiers.id_ecdsa_with_sha3_512.equals((Object)oid);
    }

    public static boolean isPlainECDSASigAlg(AlgorithmIdentifier algId) {
        ASN1ObjectIdentifier oid = ((AlgorithmIdentifier)Args.notNull((Object)algId, (String)"algId")).getAlgorithm();
        return BSIObjectIdentifiers.ecdsa_plain_SHA1.equals((Object)oid) || BSIObjectIdentifiers.ecdsa_plain_SHA224.equals((Object)oid) || BSIObjectIdentifiers.ecdsa_plain_SHA256.equals((Object)oid) || BSIObjectIdentifiers.ecdsa_plain_SHA384.equals((Object)oid) || BSIObjectIdentifiers.ecdsa_plain_SHA512.equals((Object)oid);
    }

    public static boolean isSM2SigAlg(AlgorithmIdentifier algId) {
        ASN1ObjectIdentifier oid = ((AlgorithmIdentifier)Args.notNull((Object)algId, (String)"algId")).getAlgorithm();
        return GMObjectIdentifiers.sm2sign_with_sm3.equals((Object)oid);
    }

    public static boolean isDSASigAlg(AlgorithmIdentifier algId) {
        ASN1ObjectIdentifier oid = ((AlgorithmIdentifier)Args.notNull((Object)algId, (String)"algId")).getAlgorithm();
        return X9ObjectIdentifiers.id_dsa_with_sha1.equals((Object)oid) || NISTObjectIdentifiers.dsa_with_sha224.equals((Object)oid) || NISTObjectIdentifiers.dsa_with_sha256.equals((Object)oid) || NISTObjectIdentifiers.dsa_with_sha384.equals((Object)oid) || NISTObjectIdentifiers.dsa_with_sha512.equals((Object)oid) || NISTObjectIdentifiers.id_dsa_with_sha3_224.equals((Object)oid) || NISTObjectIdentifiers.id_dsa_with_sha3_256.equals((Object)oid) || NISTObjectIdentifiers.id_dsa_with_sha3_384.equals((Object)oid) || NISTObjectIdentifiers.id_dsa_with_sha3_512.equals((Object)oid);
    }

    private static AlgorithmIdentifier getRSASigAlgId(HashAlgo hashAlgo, boolean mgf1) throws NoSuchAlgorithmException {
        Args.notNull((Object)((Object)hashAlgo), (String)"hashAlgo");
        if (mgf1) {
            return AlgorithmUtil.buildRSAPSSAlgId(hashAlgo);
        }
        ASN1ObjectIdentifier sigAlgOid = digestToRSASigAlgMap.get((Object)hashAlgo);
        if (sigAlgOid == null) {
            throw new NoSuchAlgorithmException("unsupported hash " + (Object)((Object)hashAlgo) + " for RSA key");
        }
        return new AlgorithmIdentifier(sigAlgOid, (ASN1Encodable)DERNull.INSTANCE);
    }

    private static AlgorithmIdentifier getDSASigAlgId(HashAlgo hashAlgo) throws NoSuchAlgorithmException {
        Args.notNull((Object)((Object)hashAlgo), (String)"hashAlgo");
        ASN1ObjectIdentifier sigAlgOid = digestToDSASigAlgMap.get((Object)hashAlgo);
        if (sigAlgOid == null) {
            throw new NoSuchAlgorithmException("unsupported hash " + (Object)((Object)hashAlgo) + " for DSA key");
        }
        return new AlgorithmIdentifier(sigAlgOid);
    }

    private static AlgorithmIdentifier getECSigAlgId(HashAlgo hashAlgo, boolean plainSignature, boolean gm) throws NoSuchAlgorithmException {
        ASN1ObjectIdentifier sigAlgOid;
        block9: {
            block8: {
                Args.notNull((Object)((Object)hashAlgo), (String)"hashAlgo");
                if (gm && plainSignature) {
                    throw new IllegalArgumentException("plainSignature and gm cannot be both true");
                }
                if (!gm) break block8;
                switch (hashAlgo) {
                    case SM3: {
                        sigAlgOid = GMObjectIdentifiers.sm2sign_with_sm3;
                        break block9;
                    }
                    default: {
                        throw new NoSuchAlgorithmException("unsupported hash " + (Object)((Object)hashAlgo) + " for SM2 EC key");
                    }
                }
            }
            if (plainSignature) {
                sigAlgOid = digestToECPlainSigAlgMap.get((Object)hashAlgo);
                if (sigAlgOid == null) {
                    throw new NoSuchAlgorithmException("unsupported hash " + (Object)((Object)hashAlgo) + " for SM2 EC key");
                }
            } else {
                sigAlgOid = digestToECSigAlgMap.get((Object)hashAlgo);
                if (sigAlgOid == null) {
                    throw new NoSuchAlgorithmException("unsupported hash " + (Object)((Object)hashAlgo) + " for EC key");
                }
            }
        }
        return new AlgorithmIdentifier(sigAlgOid);
    }

    public static HashAlgo extractHashAlgoFromMacAlg(AlgorithmIdentifier macAlg) {
        ASN1ObjectIdentifier oid = macAlg.getAlgorithm();
        HashAlgo hashAlgo = macAlgOidToDigestMap.get(oid);
        if (hashAlgo == null) {
            throw new IllegalArgumentException("unknown algorithm identifier " + oid.getId());
        }
        return hashAlgo;
    }

    public static AlgorithmIdentifier extractDigesetAlgFromSigAlg(AlgorithmIdentifier sigAlgId) throws NoSuchAlgorithmException {
        ASN1ObjectIdentifier digestAlgOid;
        ASN1ObjectIdentifier algOid = sigAlgId.getAlgorithm();
        if (PKCSObjectIdentifiers.id_RSASSA_PSS.equals((Object)algOid)) {
            ASN1Encodable asn1Encodable = sigAlgId.getParameters();
            RSASSAPSSparams param = RSASSAPSSparams.getInstance((Object)asn1Encodable);
            digestAlgOid = param.getHashAlgorithm().getAlgorithm();
        } else {
            HashAlgo digestAlg = sigAlgOidToDigestMap.get(algOid);
            if (digestAlg == null) {
                throw new NoSuchAlgorithmException("unknown signature algorithm " + algOid.getId());
            }
            digestAlgOid = digestAlg.getOid();
        }
        return new AlgorithmIdentifier(digestAlgOid, (ASN1Encodable)DERNull.INSTANCE);
    }

    public static boolean equalsAlgoName(String algoNameA, String algoNameB) {
        String tmpB;
        Args.notBlank((String)algoNameA, (String)"algoNameA");
        Args.notBlank((String)algoNameB, (String)"algoNameB");
        if (algoNameA.equalsIgnoreCase(algoNameB)) {
            return true;
        }
        String tmpA = algoNameA;
        if (tmpA.indexOf(45) != -1) {
            tmpA = tmpA.replace("-", "");
        }
        if ((tmpB = algoNameB).indexOf(45) != -1) {
            tmpB = tmpB.replace("-", "");
        }
        if (tmpA.equalsIgnoreCase(tmpB)) {
            return true;
        }
        return AlgorithmUtil.splitAlgoNameTokens(tmpA).equals(AlgorithmUtil.splitAlgoNameTokens(tmpB));
    }

    private static Set<String> splitAlgoNameTokens(String algoName) {
        Args.notBlank((String)algoName, (String)"algoName");
        String tmpAlgoName = algoName.toUpperCase();
        int idx = tmpAlgoName.indexOf("AND");
        HashSet<String> set = new HashSet<String>();
        if (idx == -1) {
            set.add(tmpAlgoName);
            return set;
        }
        int len = tmpAlgoName.length();
        int beginIndex = 0;
        int endIndex = idx;
        while (true) {
            String token;
            if (StringUtil.isNotBlank((String)(token = tmpAlgoName.substring(beginIndex, endIndex)))) {
                set.add(token);
            }
            if (endIndex >= len) {
                return set;
            }
            beginIndex = endIndex + 3;
            if ((endIndex = tmpAlgoName.indexOf("AND", beginIndex)) != -1) continue;
            endIndex = len;
        }
    }

    private static AlgorithmIdentifier buildRSAPSSAlgId(HashAlgo digestAlg) throws NoSuchAlgorithmException {
        RSASSAPSSparams params = AlgorithmUtil.createPSSRSAParams(digestAlg);
        return new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSASSA_PSS, (ASN1Encodable)params);
    }

    private static RSASSAPSSparams createPSSRSAParams(HashAlgo digestAlg) throws NoSuchAlgorithmException {
        int saltSize = ((HashAlgo)((Object)Args.notNull((Object)((Object)digestAlg), (String)"digestAlg"))).getLength();
        AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(digestAlg.getOid(), (ASN1Encodable)DERNull.INSTANCE);
        return new RSASSAPSSparams(digAlgId, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)digAlgId), new ASN1Integer((long)saltSize), RSASSAPSSparams.DEFAULT_TRAILER_FIELD);
    }

    private static ASN1ObjectIdentifier getCurveOidForName(String curveName) {
        return curveNameToOidMap.get(Args.toNonBlankLower((String)curveName, (String)"curveName"));
    }

    public static List<String> getECCurveNames() {
        return curveNames;
    }

    public static String getCurveName(ASN1ObjectIdentifier curveOid) {
        Args.notNull((Object)curveOid, (String)"curveOid");
        return curveOidToNameMap.get(curveOid);
    }

    public static ASN1ObjectIdentifier getCurveOidForCurveNameOrOid(String curveNameOrOid) {
        ASN1ObjectIdentifier oid;
        Args.notBlank((String)curveNameOrOid, (String)"curveNameOrOid");
        try {
            oid = new ASN1ObjectIdentifier(curveNameOrOid);
        }
        catch (Exception ex) {
            oid = AlgorithmUtil.getCurveOidForName(curveNameOrOid);
        }
        return oid;
    }

    private static String canonicalizeAlgoText(String algoText) {
        if (algoText.indexOf(45) == -1) {
            return algoText;
        }
        StringBuilder sb = new StringBuilder(algoText.length());
        for (int i = 0; i < algoText.length(); ++i) {
            char cc = algoText.charAt(i);
            if (cc == '-' && i > 3 && (algoText.charAt(i - 4) != 'S' || algoText.charAt(i - 3) != 'H' || algoText.charAt(i - 2) != 'A' || algoText.charAt(i - 1) != '3')) continue;
            sb.append(cc);
        }
        return sb.toString();
    }

    static {
        LinkedList<String> nameList = new LinkedList<String>();
        HashAlgo[] nameOidMap = new HashMap();
        HashMap<ASN1ObjectIdentifier, String> oidNameMap = new HashMap<ASN1ObjectIdentifier, String>();
        Enumeration names = org.bouncycastle.jce.ECNamedCurveTable.getNames();
        while (names.hasMoreElements()) {
            String name = ((String)names.nextElement()).toLowerCase();
            ASN1ObjectIdentifier oid = ECNamedCurveTable.getOID((String)name);
            if (oid == null) continue;
            nameList.add(name);
            nameOidMap.put(name, oid);
            if (oidNameMap.containsKey(oid)) continue;
            oidNameMap.put(oid, name);
        }
        Collections.sort(nameList);
        curveNames = Collections.unmodifiableList(nameList);
        curveNameToOidMap = Collections.unmodifiableMap(nameOidMap);
        curveOidToNameMap = Collections.unmodifiableMap(oidNameMap);
        HashMap<Object, Enum> map = new HashMap<Object, Enum>();
        map.put(PKCSObjectIdentifiers.id_hmacWithSHA1, AlgorithmCode.HMAC_SHA1);
        map.put(PKCSObjectIdentifiers.id_hmacWithSHA224, AlgorithmCode.HMAC_SHA224);
        map.put(PKCSObjectIdentifiers.id_hmacWithSHA256, AlgorithmCode.HMAC_SHA256);
        map.put(PKCSObjectIdentifiers.id_hmacWithSHA384, AlgorithmCode.HMAC_SHA384);
        map.put(PKCSObjectIdentifiers.id_hmacWithSHA512, AlgorithmCode.HMAC_SHA512);
        map.put(NISTObjectIdentifiers.id_hmacWithSHA3_224, AlgorithmCode.HMAC_SHA224);
        map.put(NISTObjectIdentifiers.id_hmacWithSHA3_256, AlgorithmCode.HMAC_SHA256);
        map.put(NISTObjectIdentifiers.id_hmacWithSHA3_384, AlgorithmCode.HMAC_SHA384);
        map.put(NISTObjectIdentifiers.id_hmacWithSHA3_512, AlgorithmCode.HMAC_SHA512);
        map.put(NISTObjectIdentifiers.id_aes128_GCM, AlgorithmCode.AES128_GMAC);
        map.put(NISTObjectIdentifiers.id_aes192_GCM, AlgorithmCode.AES192_GMAC);
        map.put(NISTObjectIdentifiers.id_aes256_GCM, AlgorithmCode.AES256_GMAC);
        map.put(X9ObjectIdentifiers.ecdsa_with_SHA1, AlgorithmCode.SHA1WITHECDSA);
        map.put(X9ObjectIdentifiers.ecdsa_with_SHA224, AlgorithmCode.SHA224WITHECDSA);
        map.put(X9ObjectIdentifiers.ecdsa_with_SHA256, AlgorithmCode.SHA256WITHECDSA);
        map.put(X9ObjectIdentifiers.ecdsa_with_SHA384, AlgorithmCode.SHA384WITHECDSA);
        map.put(X9ObjectIdentifiers.ecdsa_with_SHA512, AlgorithmCode.SHA512WITHECDSA);
        map.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_224, AlgorithmCode.SHA3_224WITHECDSA);
        map.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_256, AlgorithmCode.SHA3_256WITHECDSA);
        map.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_384, AlgorithmCode.SHA3_384WITHECDSA);
        map.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_512, AlgorithmCode.SHA3_512WITHECDSA);
        map.put(BSIObjectIdentifiers.ecdsa_plain_SHA1, AlgorithmCode.SHA1WITHPLAIN_ECDSA);
        map.put(BSIObjectIdentifiers.ecdsa_plain_SHA224, AlgorithmCode.SHA224WITHPLAIN_ECDSA);
        map.put(BSIObjectIdentifiers.ecdsa_plain_SHA256, AlgorithmCode.SHA256WITHPLAIN_ECDSA);
        map.put(BSIObjectIdentifiers.ecdsa_plain_SHA384, AlgorithmCode.SHA384WITHPLAIN_ECDSA);
        map.put(BSIObjectIdentifiers.ecdsa_plain_SHA512, AlgorithmCode.SHA512WITHPLAIN_ECDSA);
        map.put(X9ObjectIdentifiers.id_dsa_with_sha1, AlgorithmCode.SHA1WITHDSA);
        map.put(NISTObjectIdentifiers.dsa_with_sha224, AlgorithmCode.SHA224WITHDSA);
        map.put(NISTObjectIdentifiers.dsa_with_sha256, AlgorithmCode.SHA256WITHDSA);
        map.put(NISTObjectIdentifiers.dsa_with_sha384, AlgorithmCode.SHA384WITHDSA);
        map.put(NISTObjectIdentifiers.dsa_with_sha512, AlgorithmCode.SHA512WITHDSA);
        map.put(NISTObjectIdentifiers.id_dsa_with_sha3_224, AlgorithmCode.SHA3_224WITHDSA);
        map.put(NISTObjectIdentifiers.id_dsa_with_sha3_256, AlgorithmCode.SHA3_256WITHDSA);
        map.put(NISTObjectIdentifiers.id_dsa_with_sha3_384, AlgorithmCode.SHA3_384WITHDSA);
        map.put(NISTObjectIdentifiers.id_dsa_with_sha3_512, AlgorithmCode.SHA3_512WITHDSA);
        map.put(PKCSObjectIdentifiers.sha1WithRSAEncryption, AlgorithmCode.SHA1WITHRSA);
        map.put(PKCSObjectIdentifiers.sha224WithRSAEncryption, AlgorithmCode.SHA224WITHRSA);
        map.put(PKCSObjectIdentifiers.sha256WithRSAEncryption, AlgorithmCode.SHA256WITHRSA);
        map.put(PKCSObjectIdentifiers.sha384WithRSAEncryption, AlgorithmCode.SHA384WITHRSA);
        map.put(PKCSObjectIdentifiers.sha512WithRSAEncryption, AlgorithmCode.SHA512WITHRSA);
        map.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224, AlgorithmCode.SHA3_224WITHRSA);
        map.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256, AlgorithmCode.SHA3_256WITHRSA);
        map.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384, AlgorithmCode.SHA3_384WITHRSA);
        map.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512, AlgorithmCode.SHA3_512WITHRSA);
        map.put(GMObjectIdentifiers.sm2sign_with_sm3, AlgorithmCode.SM2WITHSM3);
        for (HashAlgo hashAlgo : HashAlgo.values()) {
            map.put(hashAlgo.getOid(), hashAlgo.getAlgorithmCode());
        }
        algOidToCodeMap = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(HashAlgo.SHA1.getOid(), AlgorithmCode.SHA1WITHRSAANDMGF1);
        map.put(HashAlgo.SHA224.getOid(), AlgorithmCode.SHA224WITHRSAANDMGF1);
        map.put(HashAlgo.SHA256.getOid(), AlgorithmCode.SHA256WITHRSAANDMGF1);
        map.put(HashAlgo.SHA384.getOid(), AlgorithmCode.SHA384WITHRSAANDMGF1);
        map.put(HashAlgo.SHA512.getOid(), AlgorithmCode.SHA512WITHRSAANDMGF1);
        map.put(HashAlgo.SHA3_224.getOid(), AlgorithmCode.SHA3_224WITHRSAANDMGF1);
        map.put(HashAlgo.SHA3_256.getOid(), AlgorithmCode.SHA3_256WITHRSAANDMGF1);
        map.put(HashAlgo.SHA3_384.getOid(), AlgorithmCode.SHA3_384WITHRSAANDMGF1);
        map.put(HashAlgo.SHA3_512.getOid(), AlgorithmCode.SHA3_512WITHRSAANDMGF1);
        digestToMgf1AlgCodeMap = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put((Object)HashAlgo.SHA1, (Enum)X9ObjectIdentifiers.ecdsa_with_SHA1);
        map.put((Object)HashAlgo.SHA224, (Enum)X9ObjectIdentifiers.ecdsa_with_SHA224);
        map.put((Object)HashAlgo.SHA256, (Enum)X9ObjectIdentifiers.ecdsa_with_SHA256);
        map.put((Object)HashAlgo.SHA384, (Enum)X9ObjectIdentifiers.ecdsa_with_SHA384);
        map.put((Object)HashAlgo.SHA512, (Enum)X9ObjectIdentifiers.ecdsa_with_SHA512);
        map.put((Object)HashAlgo.SHA3_224, (Enum)NISTObjectIdentifiers.id_ecdsa_with_sha3_224);
        map.put((Object)HashAlgo.SHA3_256, (Enum)NISTObjectIdentifiers.id_ecdsa_with_sha3_256);
        map.put((Object)HashAlgo.SHA3_384, (Enum)NISTObjectIdentifiers.id_ecdsa_with_sha3_384);
        map.put((Object)HashAlgo.SHA3_512, (Enum)NISTObjectIdentifiers.id_ecdsa_with_sha3_512);
        digestToECSigAlgMap = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put((Object)HashAlgo.SHA1, (Enum)BSIObjectIdentifiers.ecdsa_plain_SHA1);
        map.put((Object)HashAlgo.SHA224, (Enum)BSIObjectIdentifiers.ecdsa_plain_SHA224);
        map.put((Object)HashAlgo.SHA256, (Enum)BSIObjectIdentifiers.ecdsa_plain_SHA256);
        map.put((Object)HashAlgo.SHA384, (Enum)BSIObjectIdentifiers.ecdsa_plain_SHA384);
        map.put((Object)HashAlgo.SHA512, (Enum)BSIObjectIdentifiers.ecdsa_plain_SHA512);
        digestToECPlainSigAlgMap = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put((Object)HashAlgo.SHA1, (Enum)X9ObjectIdentifiers.id_dsa_with_sha1);
        map.put((Object)HashAlgo.SHA224, (Enum)NISTObjectIdentifiers.dsa_with_sha224);
        map.put((Object)HashAlgo.SHA256, (Enum)NISTObjectIdentifiers.dsa_with_sha256);
        map.put((Object)HashAlgo.SHA384, (Enum)NISTObjectIdentifiers.dsa_with_sha384);
        map.put((Object)HashAlgo.SHA512, (Enum)NISTObjectIdentifiers.dsa_with_sha512);
        map.put((Object)HashAlgo.SHA3_224, (Enum)NISTObjectIdentifiers.id_dsa_with_sha3_224);
        map.put((Object)HashAlgo.SHA3_256, (Enum)NISTObjectIdentifiers.id_dsa_with_sha3_256);
        map.put((Object)HashAlgo.SHA3_384, (Enum)NISTObjectIdentifiers.id_dsa_with_sha3_384);
        map.put((Object)HashAlgo.SHA3_512, (Enum)NISTObjectIdentifiers.id_dsa_with_sha3_512);
        digestToDSASigAlgMap = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put((Object)HashAlgo.SHA1, (Enum)PKCSObjectIdentifiers.sha1WithRSAEncryption);
        map.put((Object)HashAlgo.SHA224, (Enum)PKCSObjectIdentifiers.sha224WithRSAEncryption);
        map.put((Object)HashAlgo.SHA256, (Enum)PKCSObjectIdentifiers.sha256WithRSAEncryption);
        map.put((Object)HashAlgo.SHA384, (Enum)PKCSObjectIdentifiers.sha384WithRSAEncryption);
        map.put((Object)HashAlgo.SHA512, (Enum)PKCSObjectIdentifiers.sha512WithRSAEncryption);
        map.put((Object)HashAlgo.SHA3_224, (Enum)NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224);
        map.put((Object)HashAlgo.SHA3_256, (Enum)NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256);
        map.put((Object)HashAlgo.SHA3_384, (Enum)NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384);
        map.put((Object)HashAlgo.SHA3_512, (Enum)NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512);
        digestToRSASigAlgMap = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(X9ObjectIdentifiers.ecdsa_with_SHA1, HashAlgo.SHA1);
        map.put(X9ObjectIdentifiers.ecdsa_with_SHA224, HashAlgo.SHA224);
        map.put(X9ObjectIdentifiers.ecdsa_with_SHA256, HashAlgo.SHA256);
        map.put(X9ObjectIdentifiers.ecdsa_with_SHA384, HashAlgo.SHA384);
        map.put(X9ObjectIdentifiers.ecdsa_with_SHA512, HashAlgo.SHA512);
        map.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_224, HashAlgo.SHA3_224);
        map.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_256, HashAlgo.SHA3_256);
        map.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_384, HashAlgo.SHA3_384);
        map.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_512, HashAlgo.SHA3_512);
        map.put(BSIObjectIdentifiers.ecdsa_plain_SHA1, HashAlgo.SHA1);
        map.put(BSIObjectIdentifiers.ecdsa_plain_SHA224, HashAlgo.SHA224);
        map.put(BSIObjectIdentifiers.ecdsa_plain_SHA256, HashAlgo.SHA256);
        map.put(BSIObjectIdentifiers.ecdsa_plain_SHA384, HashAlgo.SHA384);
        map.put(BSIObjectIdentifiers.ecdsa_plain_SHA512, HashAlgo.SHA512);
        map.put(X9ObjectIdentifiers.id_dsa_with_sha1, HashAlgo.SHA1);
        map.put(NISTObjectIdentifiers.dsa_with_sha224, HashAlgo.SHA224);
        map.put(NISTObjectIdentifiers.dsa_with_sha256, HashAlgo.SHA256);
        map.put(NISTObjectIdentifiers.dsa_with_sha384, HashAlgo.SHA384);
        map.put(NISTObjectIdentifiers.dsa_with_sha512, HashAlgo.SHA512);
        map.put(NISTObjectIdentifiers.id_dsa_with_sha3_224, HashAlgo.SHA3_224);
        map.put(NISTObjectIdentifiers.id_dsa_with_sha3_256, HashAlgo.SHA3_256);
        map.put(NISTObjectIdentifiers.id_dsa_with_sha3_384, HashAlgo.SHA3_384);
        map.put(NISTObjectIdentifiers.id_dsa_with_sha3_512, HashAlgo.SHA3_512);
        map.put(PKCSObjectIdentifiers.sha1WithRSAEncryption, HashAlgo.SHA1);
        map.put(PKCSObjectIdentifiers.sha224WithRSAEncryption, HashAlgo.SHA224);
        map.put(PKCSObjectIdentifiers.sha256WithRSAEncryption, HashAlgo.SHA256);
        map.put(PKCSObjectIdentifiers.sha384WithRSAEncryption, HashAlgo.SHA384);
        map.put(PKCSObjectIdentifiers.sha512WithRSAEncryption, HashAlgo.SHA512);
        map.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224, HashAlgo.SHA3_224);
        map.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256, HashAlgo.SHA3_256);
        map.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384, HashAlgo.SHA3_384);
        map.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512, HashAlgo.SHA3_512);
        map.put(GMObjectIdentifiers.sm2sign_with_sm3, HashAlgo.SM3);
        sigAlgOidToDigestMap = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(PKCSObjectIdentifiers.id_hmacWithSHA1, HashAlgo.SHA1);
        map.put(PKCSObjectIdentifiers.id_hmacWithSHA224, HashAlgo.SHA224);
        map.put(PKCSObjectIdentifiers.id_hmacWithSHA256, HashAlgo.SHA256);
        map.put(PKCSObjectIdentifiers.id_hmacWithSHA384, HashAlgo.SHA384);
        map.put(PKCSObjectIdentifiers.id_hmacWithSHA512, HashAlgo.SHA512);
        map.put(NISTObjectIdentifiers.id_hmacWithSHA3_224, HashAlgo.SHA224);
        map.put(NISTObjectIdentifiers.id_hmacWithSHA3_256, HashAlgo.SHA256);
        map.put(NISTObjectIdentifiers.id_hmacWithSHA3_384, HashAlgo.SHA384);
        map.put(NISTObjectIdentifiers.id_hmacWithSHA3_512, HashAlgo.SHA512);
        macAlgOidToDigestMap = Collections.unmodifiableMap(map);
        HashMap<Object, String> m1 = new HashMap<ASN1ObjectIdentifier, String>();
        HashMap<String, Object> m2 = new HashMap<String, ASN1ObjectIdentifier>();
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_aes128_GCM, "AES128GMAC");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_aes192_GCM, "AES192GMAC");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_aes256_GCM, "AES256GMAC");
        AlgorithmUtil.addOidNameMap(m1, m2, PKCSObjectIdentifiers.id_hmacWithSHA1, "HMACSHA1");
        AlgorithmUtil.addOidNameMap(m1, m2, PKCSObjectIdentifiers.id_hmacWithSHA224, "HMACSHA224");
        AlgorithmUtil.addOidNameMap(m1, m2, PKCSObjectIdentifiers.id_hmacWithSHA256, "HMACSHA256");
        AlgorithmUtil.addOidNameMap(m1, m2, PKCSObjectIdentifiers.id_hmacWithSHA384, "HMACSHA384");
        AlgorithmUtil.addOidNameMap(m1, m2, PKCSObjectIdentifiers.id_hmacWithSHA512, "HMACSHA512");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_hmacWithSHA3_224, "HMACSHA3-224");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_hmacWithSHA3_256, "HMACSHA3-256");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_hmacWithSHA3_384, "HMACSHA3-384");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_hmacWithSHA3_512, "HMACSHA3-512");
        macAlgOidToNameMap = Collections.unmodifiableMap(m1);
        macAlgNameToOidMap = Collections.unmodifiableMap(m2);
        m1 = new HashMap();
        m2 = new HashMap();
        AlgorithmUtil.addOidNameMap(m1, m2, X9ObjectIdentifiers.ecdsa_with_SHA1, "SHA1WITHECDSA", "ECDSAWITHSHA1");
        AlgorithmUtil.addOidNameMap(m1, m2, X9ObjectIdentifiers.ecdsa_with_SHA224, "SHA224WITHECDSA", "ECDSAWITHSHA224");
        AlgorithmUtil.addOidNameMap(m1, m2, X9ObjectIdentifiers.ecdsa_with_SHA256, "SHA256WITHECDSA", "ECDSAWITHSHA256");
        AlgorithmUtil.addOidNameMap(m1, m2, X9ObjectIdentifiers.ecdsa_with_SHA384, "SHA384WITHECDSA", "ECDSAWITHSHA384");
        AlgorithmUtil.addOidNameMap(m1, m2, X9ObjectIdentifiers.ecdsa_with_SHA512, "SHA512WITHECDSA", "ECDSAWITHSHA512");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_ecdsa_with_sha3_224, "SHA3-224WITHECDSA", "ECDSAWITHSHA3-224");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_ecdsa_with_sha3_256, "SHA3-256WITHECDSA", "ECDSAWITHSHA3-256");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_ecdsa_with_sha3_384, "SHA3-384WITHECDSA", "ECDSAWITHSHA3-384");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_ecdsa_with_sha3_512, "SHA3-512WITHECDSA", "ECDSAWITHSHA3-512");
        AlgorithmUtil.addOidNameMap(m1, m2, BSIObjectIdentifiers.ecdsa_plain_SHA1, "SHA1WITHPLAINECDSA", "PLAINECDSAWITHSHA1");
        AlgorithmUtil.addOidNameMap(m1, m2, BSIObjectIdentifiers.ecdsa_plain_SHA224, "SHA224WITHPLAIN-ECDSA", "PLAINECDSAWITHSHA224");
        AlgorithmUtil.addOidNameMap(m1, m2, BSIObjectIdentifiers.ecdsa_plain_SHA256, "SHA256WITHPLAINECDSA", "PLAINECDSAWITHSHA256");
        AlgorithmUtil.addOidNameMap(m1, m2, BSIObjectIdentifiers.ecdsa_plain_SHA384, "SHA384WITHPLAINECDSA", "PLAINECDSAWITHSHA384");
        AlgorithmUtil.addOidNameMap(m1, m2, BSIObjectIdentifiers.ecdsa_plain_SHA512, "SHA512WITHPLAINECDSA", "PLAINECDSAWITHSHA512");
        AlgorithmUtil.addOidNameMap(m1, m2, X9ObjectIdentifiers.id_dsa_with_sha1, "SHA1WITHDSA", "DSAWITHSHA1");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.dsa_with_sha224, "SHA224WITHDSA", "DSAWITHSHA224");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.dsa_with_sha256, "SHA256WITHDSA", "DSAWITHSHA256");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.dsa_with_sha384, "SHA384WITHDSA", "DSAWITHSHA384");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.dsa_with_sha512, "SHA512WITHDSA", "DSAWITHSHA512");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_dsa_with_sha3_224, "SHA3-224WITHDSA", "DSAWITHSHA3-224");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_dsa_with_sha3_256, "SHA3-256WITHDSA", "DSAWITHSHA3-256");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_dsa_with_sha3_384, "SHA3-384WITHDSA", "DSAWITHSHA3-384");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_dsa_with_sha3_512, "SHA3-512WITHDSA", "DSAWITHSHA3-512");
        AlgorithmUtil.addOidNameMap(m1, m2, PKCSObjectIdentifiers.sha1WithRSAEncryption, "SHA1WITHRSA", "RSAWITHSHA1");
        AlgorithmUtil.addOidNameMap(m1, m2, PKCSObjectIdentifiers.sha224WithRSAEncryption, "SHA224WITHRSA", "RSAWITHSHA224");
        AlgorithmUtil.addOidNameMap(m1, m2, PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256WITHRSA", "RSAWITHSHA256");
        AlgorithmUtil.addOidNameMap(m1, m2, PKCSObjectIdentifiers.sha384WithRSAEncryption, "SHA384WITHRSA", "RSAWITHSHA384");
        AlgorithmUtil.addOidNameMap(m1, m2, PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512WITHRSA", "RSAWITHSHA512");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224, "SHA3-224WITHRSA", "RSAWITHSHA3-224");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256, "SHA3-256WITHRSA", "RSAWITHSHA3-256");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384, "SHA3-384WITHRSA", "RSAWITHSHA3-384");
        AlgorithmUtil.addOidNameMap(m1, m2, NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512, "SHA3-512WITHRSA", "RSAWITHSHA3-512");
        AlgorithmUtil.addOidNameMap(m1, m2, GMObjectIdentifiers.sm2sign_with_sm3, "SM3WITHSM2", "SM2WITHSM3");
        sigAlgOidToNameMap = Collections.unmodifiableMap(m1);
        sigAlgNameToOidMap = Collections.unmodifiableMap(m2);
        m1 = new HashMap();
        HashMap<String, HashAlgo> m3 = new HashMap<String, HashAlgo>();
        AlgorithmUtil.addHashAlgoNameMap(m1, m3, HashAlgo.SHA1, "SHA1WITHRSAANDMGF1");
        AlgorithmUtil.addHashAlgoNameMap(m1, m3, HashAlgo.SHA224, "SHA224WITHRSAANDMGF1");
        AlgorithmUtil.addHashAlgoNameMap(m1, m3, HashAlgo.SHA256, "SHA256WITHRSAANDMGF1");
        AlgorithmUtil.addHashAlgoNameMap(m1, m3, HashAlgo.SHA384, "SHA384WITHRSAANDMGF1");
        AlgorithmUtil.addHashAlgoNameMap(m1, m3, HashAlgo.SHA512, "SHA512WITHRSAANDMGF1");
        AlgorithmUtil.addHashAlgoNameMap(m1, m3, HashAlgo.SHA3_224, "SHA3-224WITHRSAANDMGF1");
        AlgorithmUtil.addHashAlgoNameMap(m1, m3, HashAlgo.SHA3_256, "SHA3-256WITHRSAANDMGF1");
        AlgorithmUtil.addHashAlgoNameMap(m1, m3, HashAlgo.SHA3_384, "SHA3-384WITHRSAANDMGF1");
        AlgorithmUtil.addHashAlgoNameMap(m1, m3, HashAlgo.SHA3_512, "SHA3-512WITHRSAANDMGF1");
        digestOidToMgf1SigNameMap = Collections.unmodifiableMap(m1);
        mgf1SigNameToDigestOidMap = Collections.unmodifiableMap(m3);
    }
}

