/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import iaik.pkcs.pkcs11.constants.Functions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.Pkcs11conf;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.InvalidConfException;
import org.xipki.util.StringUtil;

public class P11ModuleConf {
    private static final Logger LOG = LoggerFactory.getLogger(P11ModuleConf.class);
    private final String name;
    private final String type;
    private final String nativeLibrary;
    private final boolean readOnly;
    private final Set<P11SlotIdFilter> excludeSlots;
    private final Set<P11SlotIdFilter> includeSlots;
    private final P11PasswordsRetriever passwordRetriever;
    private final P11MechanismFilter mechanismFilter;
    private final int maxMessageSize;
    private final long userType;
    private final P11NewObjectConf newObjectConf;

    public P11ModuleConf(Pkcs11conf.Module moduleType, List<Pkcs11conf.MechanismSet> mechanismSets, PasswordResolver passwordResolver) throws InvalidConfException {
        Args.notNull((Object)((Object)moduleType), (String)"moduleType");
        Args.notEmpty(mechanismSets, (String)"mechanismSets");
        this.name = moduleType.getName();
        this.readOnly = moduleType.isReadonly();
        String userTypeStr = moduleType.getUser().toUpperCase();
        if ("CKU_USER".equals(userTypeStr)) {
            this.userType = 1L;
        } else if ("CKU_SO".equals(userTypeStr)) {
            this.userType = 0L;
        } else if ("CKU_CONTEXT_SPECIFIC".equals(userTypeStr)) {
            this.userType = 2L;
        } else {
            try {
                this.userType = userTypeStr.startsWith("0X") ? Long.parseLong(userTypeStr.substring(2), 16) : Long.parseLong(userTypeStr);
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfException("invalid user " + userTypeStr);
            }
        }
        this.maxMessageSize = moduleType.getMaxMessageSize();
        this.type = moduleType.getType();
        if (this.maxMessageSize < 128) {
            throw new InvalidConfException("invalid maxMessageSize (< 128): " + this.maxMessageSize);
        }
        HashMap mechanismSetsMap = new HashMap(mechanismSets.size() * 3 / 2);
        for (Object m : mechanismSets) {
            String string = m.getName();
            if (mechanismSetsMap.containsKey(string)) {
                throw new InvalidConfException("Duplication mechanismSets named " + string);
            }
            HashSet<Long> mechanisms = new HashSet<Long>();
            for (String mechStr : m.getMechanisms()) {
                if ((mechStr = mechStr.trim().toUpperCase()).equals("ALL")) {
                    mechanisms = null;
                    break;
                }
                Long mech = null;
                if (mechStr.startsWith("CKM_")) {
                    mech = Functions.mechanismStringToCode((String)mechStr);
                } else {
                    int radix = 10;
                    if (mechStr.startsWith("0X")) {
                        radix = 16;
                        mechStr = mechStr.substring(2);
                    }
                    if (mechStr.endsWith("UL")) {
                        mechStr = mechStr.substring(0, mechStr.length() - 2);
                    } else if (mechStr.endsWith("L")) {
                        mechStr = mechStr.substring(0, mechStr.length() - 1);
                    }
                    try {
                        mech = Long.parseLong(mechStr, radix);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (mech == null) {
                    LOG.warn("skipped unknown mechanism '" + mechStr + "'");
                    continue;
                }
                mechanisms.add(mech);
            }
            mechanismSetsMap.put(string, mechanisms);
        }
        this.mechanismFilter = new P11MechanismFilter();
        List<Pkcs11conf.MechanimFilter> mechFilters = moduleType.getMechanismFilters();
        if (mechFilters != null && CollectionUtil.isNonEmpty(mechFilters)) {
            for (Pkcs11conf.MechanimFilter mechanimFilter : mechFilters) {
                Set<P11SlotIdFilter> slots = P11ModuleConf.getSlotIdFilters(mechanimFilter.getSlots());
                String mechanismSetName = mechanimFilter.getMechanismSet();
                if (!mechanismSetsMap.containsKey(mechanismSetName)) {
                    throw new InvalidConfException("MechanismSet '" + mechanismSetName + "' is not defined");
                }
                Set mechanisms = (Set)mechanismSetsMap.get(mechanismSetName);
                if (mechanisms == null) {
                    this.mechanismFilter.addAcceptAllEntry(slots);
                    continue;
                }
                this.mechanismFilter.addEntry(slots, mechanisms);
            }
        }
        this.passwordRetriever = new P11PasswordsRetriever();
        List<Pkcs11conf.PasswordSet> passwordsList = moduleType.getPasswordSets();
        if (passwordsList != null && CollectionUtil.isNonEmpty(passwordsList)) {
            this.passwordRetriever.setPasswordResolver(passwordResolver);
            for (Pkcs11conf.PasswordSet passwordType : passwordsList) {
                Set<P11SlotIdFilter> slots = P11ModuleConf.getSlotIdFilters(passwordType.getSlots());
                this.passwordRetriever.addPasswordEntry(slots, new ArrayList<String>(passwordType.getPasswords()));
            }
        }
        this.includeSlots = P11ModuleConf.getSlotIdFilters(moduleType.getIncludeSlots());
        this.excludeSlots = P11ModuleConf.getSlotIdFilters(moduleType.getExcludeSlots());
        String string = System.getProperty("os.name").toLowerCase();
        String nativeLibraryPath = null;
        for (Pkcs11conf.NativeLibrary library : moduleType.getNativeLibraries()) {
            List<String> osNames = library.getOperationSystems();
            if (CollectionUtil.isEmpty(osNames)) {
                nativeLibraryPath = library.getPath();
            } else {
                for (String entry : osNames) {
                    if (!string.contains(entry.toLowerCase())) continue;
                    nativeLibraryPath = library.getPath();
                    break;
                }
            }
            if (nativeLibraryPath == null) continue;
            break;
        }
        if (nativeLibraryPath == null) {
            throw new InvalidConfException("could not find PKCS#11 library for OS " + string);
        }
        this.nativeLibrary = nativeLibraryPath;
        this.newObjectConf = moduleType.getNewObjectConf() == null ? new P11NewObjectConf() : new P11NewObjectConf(moduleType.getNewObjectConf());
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getNativeLibrary() {
        return this.nativeLibrary;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public long getUserType() {
        return this.userType;
    }

    public P11PasswordsRetriever getPasswordRetriever() {
        return this.passwordRetriever;
    }

    public boolean isSlotIncluded(P11SlotIdentifier slotId) {
        boolean included;
        Args.notNull((Object)slotId, (String)"slotId");
        if (CollectionUtil.isEmpty(this.includeSlots)) {
            included = true;
        } else {
            included = false;
            for (P11SlotIdFilter entry : this.includeSlots) {
                if (!entry.match(slotId)) continue;
                included = true;
                break;
            }
        }
        if (!included) {
            return false;
        }
        if (CollectionUtil.isEmpty(this.excludeSlots)) {
            return included;
        }
        for (P11SlotIdFilter entry : this.excludeSlots) {
            if (!entry.match(slotId)) continue;
            return false;
        }
        return true;
    }

    public P11MechanismFilter getP11MechanismFilter() {
        return this.mechanismFilter;
    }

    public P11NewObjectConf getP11NewObjectConf() {
        return this.newObjectConf;
    }

    private static Set<P11SlotIdFilter> getSlotIdFilters(List<Pkcs11conf.Slot> slotTypes) throws InvalidConfException {
        if (CollectionUtil.isEmpty(slotTypes)) {
            return null;
        }
        HashSet<P11SlotIdFilter> filters = new HashSet<P11SlotIdFilter>();
        for (Pkcs11conf.Slot slotType : slotTypes) {
            Long slotId = null;
            if (slotType.getId() != null) {
                String str = slotType.getId().trim();
                try {
                    slotId = StringUtil.startsWithIgnoreCase((String)str, (String)"0X") ? Long.parseLong(str.substring(2), 16) : Long.parseLong(str);
                }
                catch (NumberFormatException ex) {
                    String message = "invalid slotId '" + str + "'";
                    LOG.error(message);
                    throw new InvalidConfException(message);
                }
            }
            filters.add(new P11SlotIdFilter(slotType.getIndex(), slotId));
        }
        return filters;
    }

    public static class P11NewObjectConf {
        private boolean ignoreLabel;
        private int idLength = 8;
        private Set<Long> setCertObjectAttributes;

        public P11NewObjectConf(Pkcs11conf.NewObjectConf conf) {
            Boolean bb = conf.getIgnoreLabel();
            this.ignoreLabel = bb == null ? false : bb;
            Integer ii = conf.getIdLength();
            this.idLength = ii == null ? 8 : ii;
            List<Pkcs11conf.NewObjectConf.CertAttribute> attrs = conf.getCertAttributes();
            HashSet<Long> set = new HashSet<Long>();
            if (attrs != null) {
                for (Pkcs11conf.NewObjectConf.CertAttribute attr : attrs) {
                    set.add(attr.getPkcs11CkaCode());
                }
            }
            this.setCertObjectAttributes = Collections.unmodifiableSet(set);
        }

        public P11NewObjectConf() {
            this.setCertObjectAttributes = Collections.emptySet();
        }

        public boolean isIgnoreLabel() {
            return this.ignoreLabel;
        }

        public void setIgnoreLabel(boolean ignoreLabel) {
            this.ignoreLabel = ignoreLabel;
        }

        public int getIdLength() {
            return this.idLength;
        }

        public void setIdLength(int idLength) {
            this.idLength = idLength;
        }

        public Set<Long> getSetCertObjectAttributes() {
            return this.setCertObjectAttributes;
        }

        public void setSetCertObjectAttributes(Set<Long> setCertObjectAttributes) {
            this.setCertObjectAttributes = (Set)Args.notNull(setCertObjectAttributes, (String)"setCertObjectAttributes");
        }
    }

    public static class P11PasswordsRetriever {
        private final List<P11SinglePasswordRetriever> singleRetrievers = new LinkedList<P11SinglePasswordRetriever>();
        private PasswordResolver passwordResolver;

        P11PasswordsRetriever() {
        }

        void addPasswordEntry(Set<P11SlotIdFilter> slots, List<String> passwords) {
            this.singleRetrievers.add(new P11SinglePasswordRetriever(slots, passwords));
        }

        public List<char[]> getPassword(P11SlotIdentifier slotId) throws PasswordResolverException {
            Args.notNull((Object)slotId, (String)"slotId");
            if (CollectionUtil.isEmpty(this.singleRetrievers)) {
                return null;
            }
            for (P11SinglePasswordRetriever sr : this.singleRetrievers) {
                if (!sr.match(slotId)) continue;
                return sr.getPasswords(this.passwordResolver);
            }
            return null;
        }

        public PasswordResolver getPasswordResolver() {
            return this.passwordResolver;
        }

        public void setPasswordResolver(PasswordResolver passwordResolver) {
            this.passwordResolver = passwordResolver;
        }

        private static final class P11SinglePasswordRetriever {
            private final Set<P11SlotIdFilter> slots;
            private final List<String> passwords;

            private P11SinglePasswordRetriever(Set<P11SlotIdFilter> slots, List<String> passwords) {
                this.slots = slots;
                this.passwords = CollectionUtil.isEmpty(passwords) ? null : passwords;
            }

            public boolean match(P11SlotIdentifier slot) {
                if (this.slots == null) {
                    return true;
                }
                for (P11SlotIdFilter m : this.slots) {
                    if (!m.match(slot)) continue;
                    return true;
                }
                return false;
            }

            public List<char[]> getPasswords(PasswordResolver passwordResolver) throws PasswordResolverException {
                if (this.passwords == null) {
                    return null;
                }
                ArrayList<char[]> ret = new ArrayList<char[]>(this.passwords.size());
                for (String password : this.passwords) {
                    if (passwordResolver == null) {
                        ret.add(password.toCharArray());
                        continue;
                    }
                    ret.add(passwordResolver.resolvePassword(password));
                }
                return ret;
            }
        }
    }

    public static class P11MechanismFilter {
        private final List<P11SingleMechanismFilter> singleFilters = new LinkedList<P11SingleMechanismFilter>();

        P11MechanismFilter() {
        }

        void addEntry(Set<P11SlotIdFilter> slots, Collection<Long> mechanisms) {
            Args.notNull(mechanisms, (String)"mechanismis");
            this.singleFilters.add(new P11SingleMechanismFilter(slots, mechanisms));
        }

        void addAcceptAllEntry(Set<P11SlotIdFilter> slots) {
            this.singleFilters.add(new P11SingleMechanismFilter(slots, null));
        }

        public boolean isMechanismPermitted(P11SlotIdentifier slotId, long mechanism) {
            Args.notNull((Object)slotId, (String)"slotId");
            if (CollectionUtil.isEmpty(this.singleFilters)) {
                return true;
            }
            for (P11SingleMechanismFilter sr : this.singleFilters) {
                if (!sr.match(slotId)) continue;
                return sr.isMechanismSupported(mechanism);
            }
            return true;
        }
    }

    private static final class P11SingleMechanismFilter {
        private final Set<P11SlotIdFilter> slots;
        private final Collection<Long> mechanisms;

        private P11SingleMechanismFilter(Set<P11SlotIdFilter> slots, Collection<Long> mechanisms) {
            this.slots = slots;
            this.mechanisms = CollectionUtil.isEmpty(mechanisms) ? null : mechanisms;
        }

        public boolean match(P11SlotIdentifier slot) {
            if (this.slots == null) {
                return true;
            }
            for (P11SlotIdFilter m : this.slots) {
                if (!m.match(slot)) continue;
                return true;
            }
            return false;
        }

        public boolean isMechanismSupported(long mechanism) {
            if (this.mechanisms == null) {
                return true;
            }
            return this.mechanisms.contains(mechanism);
        }
    }

    private static class P11SlotIdFilter {
        private final Integer index;
        private final Long id;

        P11SlotIdFilter(Integer index, Long id) {
            if (index == null && id == null) {
                throw new IllegalArgumentException("at least one of index and id may not be null");
            }
            this.index = index;
            this.id = id;
        }

        boolean match(P11SlotIdentifier slotId) {
            if (this.index != null && this.index.intValue() != slotId.getIndex()) {
                return false;
            }
            return this.id == null || this.id.longValue() == slotId.getId();
        }
    }
}

