/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.Digest;

public class DigestOutputStream
extends OutputStream {
    private Digest digest;

    public DigestOutputStream(Digest digest) {
        this.digest = digest;
    }

    public void reset() {
        this.digest.reset();
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        this.digest.update(bytes, off, len);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.digest.update(bytes, 0, bytes.length);
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.digest.update((byte)oneByte);
    }

    public byte[] digest() {
        byte[] result = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(result, 0);
        this.reset();
        return result;
    }
}

