/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.util.Arrays;
import org.xipki.security.BadAsn1ObjectException;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.StringUtil;

public abstract class ProxyMessage
extends ASN1Object {
    private static void requireRange(ASN1Sequence seq, int minSize, int maxSize) throws BadAsn1ObjectException {
        int size = seq.size();
        if (size < minSize || size > maxSize) {
            String msg = String.format("seq.size() must not be out of the range [%d, %d]: %d", minSize, maxSize, size);
            throw new IllegalArgumentException(msg);
        }
    }

    private static Certificate getCertificate0(ASN1Encodable object) throws BadAsn1ObjectException {
        try {
            return Certificate.getInstance((Object)object);
        }
        catch (IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("invalid object Certificate: " + ex.getMessage(), ex);
        }
    }

    private static BigInteger getInteger(ASN1Encodable object) throws BadAsn1ObjectException {
        try {
            return ASN1Integer.getInstance((Object)object).getValue();
        }
        catch (IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("invalid object ASN1Integer: " + ex.getMessage(), ex);
        }
    }

    private static String getUtf8String(ASN1Encodable object) throws BadAsn1ObjectException {
        try {
            return DERUTF8String.getInstance((Object)object).getString();
        }
        catch (IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("invalid object UTF8String: " + ex.getMessage(), ex);
        }
    }

    public static byte[] getOctetStringBytes(ASN1Encodable object) throws BadAsn1ObjectException {
        try {
            return DEROctetString.getInstance((Object)object).getOctets();
        }
        catch (IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("invalid object OctetString: " + ex.getMessage(), ex);
        }
    }

    private static ASN1ObjectIdentifier getObjectIdentifier(ASN1Encodable object) throws BadAsn1ObjectException {
        try {
            return ASN1ObjectIdentifier.getInstance((Object)object);
        }
        catch (IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("invalid object ObjectIdentifier: " + ex.getMessage(), ex);
        }
    }

    public static class SignTemplate
    extends ProxyMessage {
        private final SlotIdentifier slotId;
        private final ObjectIdentifier objectId;
        private final Mechanism mechanism;
        private final byte[] message;

        private SignTemplate(ASN1Sequence seq) throws BadAsn1ObjectException {
            ProxyMessage.requireRange(seq, 4, 4);
            int idx = 0;
            this.slotId = SlotIdentifier.getInstance(seq.getObjectAt(idx++));
            this.objectId = ObjectIdentifier.getInstance(seq.getObjectAt(idx++));
            this.mechanism = Mechanism.getInstance(seq.getObjectAt(idx++));
            this.message = SignTemplate.getOctetStringBytes(seq.getObjectAt(idx++));
        }

        public SignTemplate(SlotIdentifier slotId, ObjectIdentifier objectId, long mechanism, P11Params parameter, byte[] message) {
            this.slotId = (SlotIdentifier)((Object)Args.notNull((Object)((Object)slotId), (String)"slotId"));
            this.objectId = (ObjectIdentifier)((Object)Args.notNull((Object)((Object)objectId), (String)"objectId"));
            this.message = (byte[])Args.notNull((Object)message, (String)"message");
            this.mechanism = new Mechanism(mechanism, parameter);
        }

        public static SignTemplate getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof SignTemplate) {
                return (SignTemplate)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new SignTemplate((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return SignTemplate.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)this.slotId);
            vector.add((ASN1Encodable)this.objectId);
            vector.add((ASN1Encodable)this.mechanism);
            vector.add((ASN1Encodable)new DEROctetString(this.message));
            return new DERSequence(vector);
        }

        public byte[] getMessage() {
            return this.message;
        }

        public SlotIdentifier getSlotId() {
            return this.slotId;
        }

        public ObjectIdentifier getObjectId() {
            return this.objectId;
        }

        public Mechanism getMechanism() {
            return this.mechanism;
        }
    }

    public static class ServerCaps
    extends ProxyMessage {
        private final Set<Short> versions;
        private final boolean readOnly;

        public ServerCaps(boolean readOnly, Set<Short> versions) {
            this.readOnly = readOnly;
            this.versions = Collections.unmodifiableSet(Args.notEmpty(versions, (String)"versions"));
        }

        private ServerCaps(ASN1Sequence seq) throws BadAsn1ObjectException {
            ASN1Sequence vecVersions;
            ProxyMessage.requireRange(seq, 2, 2);
            try {
                this.readOnly = ASN1Boolean.getInstance((Object)seq.getObjectAt(0)).isTrue();
            }
            catch (IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("invalid readOnly: " + ex.getMessage(), ex);
            }
            try {
                vecVersions = ASN1Sequence.getInstance((Object)seq.getObjectAt(1));
            }
            catch (IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("invalid versions: " + ex.getMessage(), ex);
            }
            int count = vecVersions.size();
            HashSet<Short> tmpVersions = new HashSet<Short>(count * 2);
            for (int i = 0; i < count; ++i) {
                ASN1Integer asn1Int;
                try {
                    asn1Int = ASN1Integer.getInstance((Object)vecVersions.getObjectAt(i));
                }
                catch (IllegalArgumentException ex) {
                    throw new BadAsn1ObjectException("invalid version: " + ex.getMessage(), ex);
                }
                tmpVersions.add(asn1Int.getValue().shortValue());
            }
            this.versions = Collections.unmodifiableSet(tmpVersions);
        }

        public static ServerCaps getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof ServerCaps) {
                return (ServerCaps)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new ServerCaps((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return ServerCaps.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
            }
        }

        public Set<Short> getVersions() {
            return this.versions;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vecVersions = new ASN1EncodableVector();
            for (Short version : this.versions) {
                vecVersions.add((ASN1Encodable)new ASN1Integer(BigInteger.valueOf(version.shortValue())));
            }
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)ASN1Boolean.getInstance((boolean)this.readOnly));
            vec.add((ASN1Encodable)new DERSequence(vecVersions));
            return new DERSequence(vec);
        }
    }

    public static class RSAPkcsPssParams
    extends ProxyMessage {
        private final P11Params.P11RSAPkcsPssParams pkcsPssParams;

        public RSAPkcsPssParams(P11Params.P11RSAPkcsPssParams pkcsPssParams) {
            this.pkcsPssParams = (P11Params.P11RSAPkcsPssParams)Args.notNull((Object)pkcsPssParams, (String)"pkcsPssParams");
        }

        private RSAPkcsPssParams(ASN1Sequence seq) throws BadAsn1ObjectException {
            ProxyMessage.requireRange(seq, 3, 3);
            int idx = 0;
            long contentHash = ProxyMessage.getInteger(seq.getObjectAt(idx++)).longValue();
            long mgfHash = ProxyMessage.getInteger(seq.getObjectAt(idx++)).longValue();
            int saltLength = ProxyMessage.getInteger(seq.getObjectAt(idx++)).intValue();
            this.pkcsPssParams = new P11Params.P11RSAPkcsPssParams(contentHash, mgfHash, saltLength);
        }

        public static RSAPkcsPssParams getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof RSAPkcsPssParams) {
                return (RSAPkcsPssParams)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new RSAPkcsPssParams((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return RSAPkcsPssParams.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new ASN1Integer(this.pkcsPssParams.getHashAlgorithm()));
            vector.add((ASN1Encodable)new ASN1Integer(this.pkcsPssParams.getMaskGenerationFunction()));
            vector.add((ASN1Encodable)new ASN1Integer(this.pkcsPssParams.getSaltLength()));
            return new DERSequence(vector);
        }

        public P11Params.P11RSAPkcsPssParams getPkcsPssParams() {
            return this.pkcsPssParams;
        }
    }

    public static class RemoveObjectsParams
    extends ProxyMessage {
        private final P11SlotIdentifier slotId;
        private final byte[] objectId;
        private final String objectLabel;

        public RemoveObjectsParams(P11SlotIdentifier slotId, byte[] objectId, String objectLabel) {
            Args.notNull((Object)slotId, (String)"slotId");
            if ((objectId == null || objectId.length == 0) && StringUtil.isBlank((String)objectLabel)) {
                throw new IllegalArgumentException("at least one of objectId and objectLabel must not be null");
            }
            this.objectId = objectId;
            this.objectLabel = objectLabel;
            this.slotId = slotId;
        }

        private RemoveObjectsParams(ASN1Sequence seq) throws BadAsn1ObjectException {
            ProxyMessage.requireRange(seq, 2, 3);
            int idx = 0;
            this.slotId = SlotIdentifier.getInstance(seq.getObjectAt(idx++)).getValue();
            int size = seq.size();
            ASN1Encodable asn1Id = null;
            ASN1Encodable asn1Label = null;
            if (size == 2) {
                ASN1Encodable asn1 = seq.getObjectAt(1);
                if (asn1 instanceof ASN1String) {
                    asn1Label = asn1;
                } else {
                    asn1Id = asn1;
                }
            } else {
                asn1Id = seq.getObjectAt(idx++);
                asn1Label = seq.getObjectAt(idx++);
            }
            this.objectId = asn1Id == null ? null : RemoveObjectsParams.getOctetStringBytes(asn1Id);
            String string = this.objectLabel = asn1Label == null ? null : ProxyMessage.getUtf8String(seq.getObjectAt(idx++));
            if ((this.objectId == null || this.objectId.length == 0) && StringUtil.isBlank((String)this.objectLabel)) {
                throw new BadAsn1ObjectException("invalid object RemoveObjectsParams: at least one of id and label must not be null");
            }
        }

        public static RemoveObjectsParams getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof RemoveObjectsParams) {
                return (RemoveObjectsParams)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new RemoveObjectsParams((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return RemoveObjectsParams.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new SlotIdentifier(this.slotId));
            vector.add((ASN1Encodable)new DERUTF8String(this.objectLabel));
            return new DERSequence(vector);
        }

        public P11SlotIdentifier getSlotId() {
            return this.slotId;
        }

        public byte[] getOjectId() {
            return this.objectId == null ? null : Arrays.copyOf((byte[])this.objectId, (int)this.objectId.length);
        }

        public String getObjectLabel() {
            return this.objectLabel;
        }
    }

    public static class SlotIdentifier
    extends ProxyMessage {
        private final P11SlotIdentifier value;

        public SlotIdentifier(P11SlotIdentifier value) {
            this.value = (P11SlotIdentifier)Args.notNull((Object)value, (String)"value");
        }

        private SlotIdentifier(ASN1Sequence seq) throws BadAsn1ObjectException {
            ProxyMessage.requireRange(seq, 2, 2);
            int idx = 0;
            long id = ProxyMessage.getInteger(seq.getObjectAt(idx++)).longValue();
            int index = ProxyMessage.getInteger(seq.getObjectAt(idx++)).intValue();
            this.value = new P11SlotIdentifier(index, id);
        }

        public static SlotIdentifier getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof SlotIdentifier) {
                return (SlotIdentifier)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new SlotIdentifier((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return SlotIdentifier.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new ASN1Integer(this.value.getId()));
            vector.add((ASN1Encodable)new ASN1Integer((long)this.value.getIndex()));
            return new DERSequence(vector);
        }

        public P11SlotIdentifier getValue() {
            return this.value;
        }
    }

    public static class SlotIdAndObjectId
    extends ProxyMessage {
        private final SlotIdentifier slotId;
        private final ObjectIdentifier objectId;

        public SlotIdAndObjectId(P11SlotIdentifier slotId, P11ObjectIdentifier objectId) {
            Args.notNull((Object)slotId, (String)"slotId");
            Args.notNull((Object)objectId, (String)"objectId");
            this.slotId = new SlotIdentifier(slotId);
            this.objectId = new ObjectIdentifier(objectId);
        }

        public SlotIdAndObjectId(SlotIdentifier slotId, ObjectIdentifier objectId) {
            this.slotId = (SlotIdentifier)((Object)Args.notNull((Object)((Object)slotId), (String)"slotId"));
            this.objectId = (ObjectIdentifier)((Object)Args.notNull((Object)((Object)objectId), (String)"objectId"));
        }

        private SlotIdAndObjectId(ASN1Sequence seq) throws BadAsn1ObjectException {
            ProxyMessage.requireRange(seq, 2, 2);
            int idx = 0;
            this.slotId = SlotIdentifier.getInstance(seq.getObjectAt(idx++));
            this.objectId = ObjectIdentifier.getInstance(seq.getObjectAt(idx++));
        }

        public static SlotIdAndObjectId getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof SlotIdAndObjectId) {
                return (SlotIdAndObjectId)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new SlotIdAndObjectId((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return SlotIdAndObjectId.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            return new DERSequence(new ASN1Encodable[]{this.slotId, this.objectId});
        }

        public SlotIdentifier getSlotId() {
            return this.slotId;
        }

        public ObjectIdentifier getObjectId() {
            return this.objectId;
        }
    }

    public static class P11Params
    extends ProxyMessage {
        public static final int TAG_RSA_PKCS_PSS = 0;
        public static final int TAG_OPAQUE = 1;
        public static final int TAG_IV = 2;
        private final int tagNo;
        private final ASN1Encodable p11Params;

        public P11Params(int tagNo, ASN1Encodable p11Params) {
            this.tagNo = tagNo;
            this.p11Params = (ASN1Encodable)Args.notNull((Object)p11Params, (String)"p11Params");
        }

        private P11Params(ASN1TaggedObject taggedObject) throws BadAsn1ObjectException {
            this.tagNo = taggedObject.getTagNo();
            this.p11Params = taggedObject.getObject();
        }

        public static P11Params getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof P11Params) {
                return (P11Params)((Object)obj);
            }
            try {
                if (obj instanceof ASN1TaggedObject) {
                    return new P11Params((ASN1TaggedObject)obj);
                }
                if (obj instanceof byte[]) {
                    return P11Params.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            return new DERTaggedObject(this.tagNo, this.p11Params);
        }

        public int getTagNo() {
            return this.tagNo;
        }

        public ASN1Encodable getP11Params() {
            return this.p11Params;
        }
    }

    public static class ObjectIdentifiers
    extends ProxyMessage {
        private final List<ObjectIdentifier> objectIds;

        public ObjectIdentifiers(List<ObjectIdentifier> objectIds) {
            this.objectIds = (List)Args.notNull(objectIds, (String)"objectIds");
        }

        private ObjectIdentifiers(ASN1Sequence seq) throws BadAsn1ObjectException {
            this.objectIds = new LinkedList<ObjectIdentifier>();
            int size = seq.size();
            for (int i = 0; i < size; ++i) {
                this.objectIds.add(ObjectIdentifier.getInstance(seq.getObjectAt(i)));
            }
        }

        public static ObjectIdentifiers getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof ObjectIdentifiers) {
                return (ObjectIdentifiers)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new ObjectIdentifiers((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return ObjectIdentifiers.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            for (ObjectIdentifier objectId : this.objectIds) {
                vec.add((ASN1Encodable)objectId);
            }
            return new DERSequence(vec);
        }

        public List<ObjectIdentifier> getObjectIds() {
            return this.objectIds;
        }
    }

    public static class ObjectIdentifier
    extends ProxyMessage {
        private final P11ObjectIdentifier value;

        public ObjectIdentifier(P11ObjectIdentifier value) {
            this.value = (P11ObjectIdentifier)Args.notNull((Object)value, (String)"value");
        }

        private ObjectIdentifier(ASN1Sequence seq) throws BadAsn1ObjectException {
            ProxyMessage.requireRange(seq, 2, 2);
            int idx = 0;
            byte[] id = ObjectIdentifier.getOctetStringBytes(seq.getObjectAt(idx++));
            String label = ProxyMessage.getUtf8String(seq.getObjectAt(idx++));
            this.value = new P11ObjectIdentifier(id, label);
        }

        public static ObjectIdentifier getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof ObjectIdentifier) {
                return (ObjectIdentifier)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new ObjectIdentifier((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return ObjectIdentifier.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)new DEROctetString(this.value.getId()));
            vec.add((ASN1Encodable)new DERUTF8String(this.value.getLabel()));
            return new DERSequence(vec);
        }

        public P11ObjectIdentifier getValue() {
            return this.value;
        }
    }

    public static class IdentityId
    extends ProxyMessage {
        private final P11IdentityId value;

        public IdentityId(P11IdentityId value) {
            this.value = (P11IdentityId)Args.notNull((Object)value, (String)"value");
        }

        private IdentityId(ASN1Sequence seq) throws BadAsn1ObjectException {
            ProxyMessage.requireRange(seq, 2, 4);
            P11SlotIdentifier slotId = SlotIdentifier.getInstance(seq.getObjectAt(0)).getValue();
            P11ObjectIdentifier keyId = ObjectIdentifier.getInstance(seq.getObjectAt(1)).getValue();
            String publicKeyLabel = null;
            String certLabel = null;
            int n = seq.size();
            for (int i = 2; i < n; ++i) {
                ASN1Encodable asn1 = seq.getObjectAt(i);
                if (!(asn1 instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject tagAsn1 = (ASN1TaggedObject)asn1;
                int tag = tagAsn1.getTagNo();
                if (tag == 1) {
                    publicKeyLabel = DERUTF8String.getInstance((Object)tagAsn1.getObject()).getString();
                    continue;
                }
                if (tag != 2) continue;
                certLabel = DERUTF8String.getInstance((Object)tagAsn1.getObject()).getString();
            }
            this.value = new P11IdentityId(slotId, keyId, publicKeyLabel, certLabel);
        }

        public static IdentityId getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof IdentityId) {
                return (IdentityId)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new IdentityId((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return IdentityId.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            String label;
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new SlotIdentifier(this.value.getSlotId()));
            vector.add((ASN1Encodable)new ObjectIdentifier(this.value.getKeyId()));
            if (this.value.getPublicKeyId() != null) {
                label = this.value.getPublicKeyId().getLabel();
                vector.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)new DERUTF8String(label)));
            }
            if (this.value.getCertId() != null) {
                label = this.value.getCertId().getLabel();
                vector.add((ASN1Encodable)new DERTaggedObject(true, 2, (ASN1Encodable)new DERUTF8String(label)));
            }
            return new DERSequence(vector);
        }

        public P11IdentityId getValue() {
            return this.value;
        }
    }

    public static class ObjectIdAndCert
    extends ProxyMessage {
        private final SlotIdentifier slotId;
        private final ObjectIdentifier objectId;
        private final Certificate certificate;

        public ObjectIdAndCert(SlotIdentifier slotId, ObjectIdentifier objectId, Certificate certificate) {
            this.slotId = (SlotIdentifier)((Object)Args.notNull((Object)((Object)slotId), (String)"slotId"));
            this.objectId = (ObjectIdentifier)((Object)Args.notNull((Object)((Object)objectId), (String)"objectId"));
            this.certificate = (Certificate)Args.notNull((Object)certificate, (String)"certificate");
        }

        public ObjectIdAndCert(SlotIdentifier slotId, ObjectIdentifier objectId, X509Certificate certificate) {
            byte[] encoded;
            this.slotId = (SlotIdentifier)((Object)Args.notNull((Object)((Object)slotId), (String)"slotId"));
            this.objectId = (ObjectIdentifier)((Object)Args.notNull((Object)((Object)objectId), (String)"objectId"));
            Args.notNull((Object)certificate, (String)"certificate");
            try {
                encoded = certificate.getEncoded();
            }
            catch (CertificateEncodingException ex) {
                throw new IllegalArgumentException("could not encode certificate: " + ex.getMessage(), ex);
            }
            this.certificate = Certificate.getInstance((Object)encoded);
        }

        private ObjectIdAndCert(ASN1Sequence seq) throws BadAsn1ObjectException {
            ProxyMessage.requireRange(seq, 3, 3);
            int idx = 0;
            this.slotId = SlotIdentifier.getInstance(seq.getObjectAt(idx++));
            this.objectId = ObjectIdentifier.getInstance(seq.getObjectAt(idx++));
            this.certificate = ProxyMessage.getCertificate0(seq.getObjectAt(idx++));
        }

        public static ObjectIdAndCert getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof ObjectIdAndCert) {
                return (ObjectIdAndCert)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new ObjectIdAndCert((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return ObjectIdAndCert.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)this.slotId);
            vector.add((ASN1Encodable)this.objectId);
            vector.add((ASN1Encodable)this.certificate);
            return new DERSequence(vector);
        }

        public SlotIdentifier getSlotId() {
            return this.slotId;
        }

        public ObjectIdentifier getObjectId() {
            return this.objectId;
        }

        public Certificate getCertificate() {
            return this.certificate;
        }
    }

    public static class NewObjectControl
    extends ProxyMessage {
        private final P11Slot.P11NewObjectControl control;

        public NewObjectControl(P11Slot.P11NewObjectControl control) {
            this.control = (P11Slot.P11NewObjectControl)Args.notNull((Object)control, (String)"control");
        }

        private NewObjectControl(ASN1Sequence seq) throws BadAsn1ObjectException {
            int size = seq.size();
            Args.min((int)size, (String)"seq.size", (int)1);
            String label = DERUTF8String.getInstance((Object)seq.getObjectAt(0)).getString();
            byte[] id = null;
            for (int i = 1; i < size; ++i) {
                ASN1TaggedObject tagObj;
                int tagNo;
                ASN1Encodable obj = seq.getObjectAt(i);
                if (obj instanceof ASN1TaggedObject || (tagNo = (tagObj = (ASN1TaggedObject)obj).getTagNo()) != 0) continue;
                id = DEROctetString.getInstance((Object)tagObj.getObject()).getOctets();
            }
            this.control = new P11Slot.P11NewKeyControl(id, label);
        }

        public static NewObjectControl getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof NewObjectControl) {
                return (NewObjectControl)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new NewObjectControl((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return NewObjectControl.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new DERUTF8String(this.control.getLabel()));
            byte[] id = this.control.getId();
            if (id != null) {
                vector.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)new DEROctetString(id)));
            }
            return new DERSequence(vector);
        }

        public P11Slot.P11NewObjectControl getControl() {
            return this.control;
        }
    }

    public static class NewKeyControl
    extends ProxyMessage {
        private static final Map<Integer, P11Slot.P11KeyUsage> valueToUsageMap = new HashMap<Integer, P11Slot.P11KeyUsage>(10);
        private static final Map<P11Slot.P11KeyUsage, Integer> usageToValueMap;
        private final P11Slot.P11NewKeyControl control;

        public NewKeyControl(P11Slot.P11NewKeyControl control) {
            this.control = (P11Slot.P11NewKeyControl)Args.notNull((Object)control, (String)"control");
        }

        private NewKeyControl(ASN1Sequence seq) throws BadAsn1ObjectException {
            int size = seq.size();
            Args.min((int)size, (String)"seq.size", (int)1);
            String label = DERUTF8String.getInstance((Object)seq.getObjectAt(0)).getString();
            HashSet<P11Slot.P11KeyUsage> usages = new HashSet<P11Slot.P11KeyUsage>();
            byte[] id = null;
            Boolean extractable = null;
            for (int i = 1; i < size; ++i) {
                ASN1Encodable obj = seq.getObjectAt(i);
                if (!(obj instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject tagObj = (ASN1TaggedObject)obj;
                int tagNo = tagObj.getTagNo();
                if (tagNo == 0) {
                    id = DEROctetString.getInstance((Object)tagObj.getObject()).getOctets();
                    continue;
                }
                if (tagNo == 1) {
                    ASN1Sequence usageSeq = ASN1Sequence.getInstance((Object)tagObj.getObject());
                    int usageSize = usageSeq.size();
                    for (int j = 0; j < usageSize; ++j) {
                        ASN1Enumerated usageEnum = ASN1Enumerated.getInstance((Object)usageSeq.getObjectAt(j));
                        int enumValue = usageEnum.getValue().intValue();
                        P11Slot.P11KeyUsage usage = valueToUsageMap.get(enumValue);
                        if (usage == null) {
                            throw new IllegalArgumentException("invalid usage " + enumValue);
                        }
                        usages.add(usage);
                    }
                    continue;
                }
                if (tagNo != 2) continue;
                extractable = ASN1Boolean.getInstance((Object)tagObj.getObject()).isTrue();
            }
            this.control = new P11Slot.P11NewKeyControl(id, label);
            this.control.setUsages(usages);
            this.control.setExtractable(extractable);
        }

        public static NewKeyControl getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof NewKeyControl) {
                return (NewKeyControl)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new NewKeyControl((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return NewKeyControl.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            Set<P11Slot.P11KeyUsage> usages;
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new DERUTF8String(this.control.getLabel()));
            byte[] id = this.control.getId();
            if (id != null) {
                vector.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)new DEROctetString(id)));
            }
            if (CollectionUtil.isNonEmpty(usages = this.control.getUsages())) {
                ASN1EncodableVector asn1Usages = new ASN1EncodableVector();
                for (P11Slot.P11KeyUsage usage : usages) {
                    int value = usageToValueMap.get((Object)usage);
                    asn1Usages.add((ASN1Encodable)new ASN1Enumerated(value));
                }
                vector.add((ASN1Encodable)new DERTaggedObject(1, (ASN1Encodable)new DERSequence(asn1Usages)));
            }
            if (this.control.getExtractable() != null) {
                vector.add((ASN1Encodable)new DERTaggedObject(2, (ASN1Encodable)ASN1Boolean.getInstance((Object)this.control.getExtractable())));
            }
            return new DERSequence(vector);
        }

        public P11Slot.P11NewKeyControl getControl() {
            return this.control;
        }

        static {
            valueToUsageMap.put(0, P11Slot.P11KeyUsage.DECRYPT);
            valueToUsageMap.put(1, P11Slot.P11KeyUsage.DERIVE);
            valueToUsageMap.put(2, P11Slot.P11KeyUsage.SIGN);
            valueToUsageMap.put(3, P11Slot.P11KeyUsage.SIGN_RECOVER);
            valueToUsageMap.put(4, P11Slot.P11KeyUsage.UNWRAP);
            usageToValueMap = new HashMap<P11Slot.P11KeyUsage, Integer>(10);
            for (Integer value : valueToUsageMap.keySet()) {
                P11Slot.P11KeyUsage usage = valueToUsageMap.get(value);
                usageToValueMap.put(usage, value);
            }
        }
    }

    public static class Mechanism
    extends ProxyMessage {
        private final long mechanism;
        private final P11Params params;

        public Mechanism(long mechanism, P11Params params) {
            this.mechanism = mechanism;
            this.params = params;
        }

        private Mechanism(ASN1Sequence seq) throws BadAsn1ObjectException {
            ProxyMessage.requireRange(seq, 1, 2);
            int size = seq.size();
            int idx = 0;
            this.mechanism = ProxyMessage.getInteger(seq.getObjectAt(idx++)).longValue();
            this.params = size > 1 ? P11Params.getInstance(seq.getObjectAt(idx++)) : null;
        }

        public static Mechanism getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof Mechanism) {
                return (Mechanism)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new Mechanism((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return Mechanism.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new ASN1Integer(this.mechanism));
            if (this.params != null) {
                vector.add((ASN1Encodable)this.params);
            }
            return new DERSequence(vector);
        }

        public long getMechanism() {
            return this.mechanism;
        }

        public P11Params getParams() {
            return this.params;
        }
    }

    public static class ImportSecretKeyParams
    extends ProxyMessage {
        private final P11SlotIdentifier slotId;
        private final P11Slot.P11NewKeyControl control;
        private final long keyType;
        private final byte[] keyValue;

        public ImportSecretKeyParams(P11SlotIdentifier slotId, P11Slot.P11NewKeyControl control, long keyType, byte[] keyValue) {
            this.slotId = (P11SlotIdentifier)Args.notNull((Object)slotId, (String)"slotId");
            this.control = (P11Slot.P11NewKeyControl)Args.notNull((Object)control, (String)"control");
            this.keyType = keyType;
            this.keyValue = (byte[])Args.notNull((Object)keyValue, (String)"keyValue");
        }

        private ImportSecretKeyParams(ASN1Sequence seq) throws BadAsn1ObjectException {
            ProxyMessage.requireRange(seq, 4, 4);
            int idx = 0;
            this.slotId = SlotIdentifier.getInstance(seq.getObjectAt(idx++)).getValue();
            this.control = NewKeyControl.getInstance(seq.getObjectAt(idx++)).getControl();
            this.keyType = ProxyMessage.getInteger(seq.getObjectAt(idx++)).longValue();
            this.keyValue = ASN1OctetString.getInstance((Object)seq.getObjectAt(idx++)).getOctets();
        }

        public static ImportSecretKeyParams getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof ImportSecretKeyParams) {
                return (ImportSecretKeyParams)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new ImportSecretKeyParams((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return ImportSecretKeyParams.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new SlotIdentifier(this.slotId));
            vector.add((ASN1Encodable)new ASN1Integer(this.keyType));
            vector.add((ASN1Encodable)new DEROctetString(this.keyValue));
            return new DERSequence(vector);
        }

        public P11SlotIdentifier getSlotId() {
            return this.slotId;
        }

        public P11Slot.P11NewKeyControl getControl() {
            return this.control;
        }

        public long getKeyType() {
            return this.keyType;
        }

        public byte[] getKeyValue() {
            return Arrays.copyOf((byte[])this.keyValue, (int)this.keyValue.length);
        }
    }

    public static class GenSM2KeypairParams
    extends ProxyMessage {
        private final P11SlotIdentifier slotId;
        private final P11Slot.P11NewKeyControl control;

        public GenSM2KeypairParams(P11SlotIdentifier slotId, P11Slot.P11NewKeyControl control) {
            this.slotId = (P11SlotIdentifier)Args.notNull((Object)slotId, (String)"slotId");
            this.control = (P11Slot.P11NewKeyControl)Args.notNull((Object)control, (String)"control");
        }

        private GenSM2KeypairParams(ASN1Sequence seq) throws BadAsn1ObjectException {
            ProxyMessage.requireRange(seq, 2, 2);
            int idx = 0;
            this.slotId = SlotIdentifier.getInstance(seq.getObjectAt(idx++)).getValue();
            this.control = NewKeyControl.getInstance(seq.getObjectAt(idx++)).getControl();
        }

        public static GenSM2KeypairParams getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof GenSM2KeypairParams) {
                return (GenSM2KeypairParams)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new GenSM2KeypairParams((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return GenSM2KeypairParams.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new SlotIdentifier(this.slotId));
            vector.add((ASN1Encodable)new NewKeyControl(this.control));
            return new DERSequence(vector);
        }

        public P11SlotIdentifier getSlotId() {
            return this.slotId;
        }

        public P11Slot.P11NewKeyControl getControl() {
            return this.control;
        }
    }

    public static class GenSecretKeyParams
    extends ProxyMessage {
        private final P11SlotIdentifier slotId;
        private final P11Slot.P11NewKeyControl control;
        private final long keyType;
        private final int keysize;

        public GenSecretKeyParams(P11SlotIdentifier slotId, P11Slot.P11NewKeyControl control, long keyType, int keysize) {
            this.slotId = (P11SlotIdentifier)Args.notNull((Object)slotId, (String)"slotId");
            this.control = (P11Slot.P11NewKeyControl)Args.notNull((Object)control, (String)"control");
            this.keyType = keyType;
            this.keysize = Args.min((int)keysize, (String)"keysize", (int)1);
        }

        private GenSecretKeyParams(ASN1Sequence seq) throws BadAsn1ObjectException {
            ProxyMessage.requireRange(seq, 4, 4);
            int idx = 0;
            this.slotId = SlotIdentifier.getInstance(seq.getObjectAt(idx++)).getValue();
            this.control = NewKeyControl.getInstance(seq.getObjectAt(idx++)).getControl();
            this.keyType = ProxyMessage.getInteger(seq.getObjectAt(idx++)).longValue();
            this.keysize = ProxyMessage.getInteger(seq.getObjectAt(idx++)).intValue();
            Args.min((int)this.keysize, (String)"keysize", (int)1);
        }

        public static GenSecretKeyParams getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof GenSecretKeyParams) {
                return (GenSecretKeyParams)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new GenSecretKeyParams((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return GenSecretKeyParams.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new SlotIdentifier(this.slotId));
            vector.add((ASN1Encodable)new NewKeyControl(this.control));
            vector.add((ASN1Encodable)new ASN1Integer(this.keyType));
            vector.add((ASN1Encodable)new ASN1Integer((long)this.keysize));
            return new DERSequence(vector);
        }

        public P11SlotIdentifier getSlotId() {
            return this.slotId;
        }

        public P11Slot.P11NewKeyControl getControl() {
            return this.control;
        }

        public long getKeyType() {
            return this.keyType;
        }

        public int getKeysize() {
            return this.keysize;
        }
    }

    public static class GenRSAKeypairParams
    extends ProxyMessage {
        private final P11SlotIdentifier slotId;
        private final P11Slot.P11NewKeyControl control;
        private final int keysize;
        private final BigInteger publicExponent;

        public GenRSAKeypairParams(P11SlotIdentifier slotId, P11Slot.P11NewKeyControl control, int keysize, BigInteger publicExponent) {
            this.slotId = (P11SlotIdentifier)Args.notNull((Object)slotId, (String)"slotId");
            this.control = (P11Slot.P11NewKeyControl)Args.notNull((Object)control, (String)"control");
            this.keysize = Args.min((int)keysize, (String)"keysize", (int)1);
            this.publicExponent = publicExponent;
        }

        private GenRSAKeypairParams(ASN1Sequence seq) throws BadAsn1ObjectException {
            ProxyMessage.requireRange(seq, 3, 4);
            int size = seq.size();
            int idx = 0;
            this.slotId = SlotIdentifier.getInstance(seq.getObjectAt(idx++)).getValue();
            this.control = NewKeyControl.getInstance(seq.getObjectAt(idx++)).getControl();
            this.keysize = ProxyMessage.getInteger(seq.getObjectAt(idx++)).intValue();
            Args.min((int)this.keysize, (String)"keysize", (int)1);
            this.publicExponent = size > 3 ? ProxyMessage.getInteger(seq.getObjectAt(idx++)) : null;
        }

        public static GenRSAKeypairParams getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof GenRSAKeypairParams) {
                return (GenRSAKeypairParams)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new GenRSAKeypairParams((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return GenRSAKeypairParams.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new SlotIdentifier(this.slotId));
            vector.add((ASN1Encodable)new NewKeyControl(this.control));
            vector.add((ASN1Encodable)new ASN1Integer((long)this.keysize));
            if (this.publicExponent != null) {
                vector.add((ASN1Encodable)new ASN1Integer(this.publicExponent));
            }
            return new DERSequence(vector);
        }

        public P11SlotIdentifier getSlotId() {
            return this.slotId;
        }

        public P11Slot.P11NewKeyControl getControl() {
            return this.control;
        }

        public int getKeysize() {
            return this.keysize;
        }

        public BigInteger getPublicExponent() {
            return this.publicExponent;
        }
    }

    public static class GenECKeypairParams
    extends ProxyMessage {
        private final P11SlotIdentifier slotId;
        private final P11Slot.P11NewKeyControl control;
        private final ASN1ObjectIdentifier curveId;

        public GenECKeypairParams(P11SlotIdentifier slotId, P11Slot.P11NewKeyControl control, ASN1ObjectIdentifier curveId) {
            this.slotId = (P11SlotIdentifier)Args.notNull((Object)slotId, (String)"slotId");
            this.control = (P11Slot.P11NewKeyControl)Args.notNull((Object)control, (String)"control");
            this.curveId = (ASN1ObjectIdentifier)Args.notNull((Object)curveId, (String)"curveId");
        }

        private GenECKeypairParams(ASN1Sequence seq) throws BadAsn1ObjectException {
            ProxyMessage.requireRange(seq, 3, 3);
            int idx = 0;
            this.slotId = SlotIdentifier.getInstance(seq.getObjectAt(idx++)).getValue();
            this.control = NewKeyControl.getInstance(seq.getObjectAt(idx++)).getControl();
            this.curveId = ProxyMessage.getObjectIdentifier(seq.getObjectAt(idx++));
        }

        public static GenECKeypairParams getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof GenECKeypairParams) {
                return (GenECKeypairParams)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new GenECKeypairParams((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return GenECKeypairParams.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new SlotIdentifier(this.slotId));
            vector.add((ASN1Encodable)new NewKeyControl(this.control));
            vector.add((ASN1Encodable)this.curveId);
            return new DERSequence(vector);
        }

        public P11SlotIdentifier getSlotId() {
            return this.slotId;
        }

        public P11Slot.P11NewKeyControl getControl() {
            return this.control;
        }

        public ASN1ObjectIdentifier getCurveId() {
            return this.curveId;
        }
    }

    public static class GenDSAKeypairParams
    extends ProxyMessage {
        private final P11SlotIdentifier slotId;
        private final P11Slot.P11NewKeyControl control;
        private final BigInteger p;
        private final BigInteger q;
        private final BigInteger g;

        public GenDSAKeypairParams(P11SlotIdentifier slotId, P11Slot.P11NewKeyControl control, BigInteger p, BigInteger q, BigInteger g) {
            this.slotId = (P11SlotIdentifier)Args.notNull((Object)slotId, (String)"slotId");
            this.control = (P11Slot.P11NewKeyControl)Args.notNull((Object)control, (String)"control");
            this.p = (BigInteger)Args.notNull((Object)p, (String)"p");
            this.q = (BigInteger)Args.notNull((Object)q, (String)"q");
            this.g = (BigInteger)Args.notNull((Object)g, (String)"g");
        }

        private GenDSAKeypairParams(ASN1Sequence seq) throws BadAsn1ObjectException {
            ProxyMessage.requireRange(seq, 5, 5);
            int idx = 0;
            this.slotId = SlotIdentifier.getInstance(seq.getObjectAt(idx++)).getValue();
            this.control = NewKeyControl.getInstance(seq.getObjectAt(idx++)).getControl();
            this.p = ProxyMessage.getInteger(seq.getObjectAt(idx++));
            this.q = ProxyMessage.getInteger(seq.getObjectAt(idx++));
            this.g = ProxyMessage.getInteger(seq.getObjectAt(idx++));
        }

        public static GenDSAKeypairParams getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof GenDSAKeypairParams) {
                return (GenDSAKeypairParams)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new GenDSAKeypairParams((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return GenDSAKeypairParams.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new SlotIdentifier(this.slotId));
            vector.add((ASN1Encodable)new NewKeyControl(this.control));
            vector.add((ASN1Encodable)new ASN1Integer(this.p));
            vector.add((ASN1Encodable)new ASN1Integer(this.q));
            vector.add((ASN1Encodable)new ASN1Integer(this.g));
            return new DERSequence(vector);
        }

        public P11SlotIdentifier getSlotId() {
            return this.slotId;
        }

        public P11Slot.P11NewKeyControl getControl() {
            return this.control;
        }

        public BigInteger getP() {
            return this.p;
        }

        public BigInteger getQ() {
            return this.q;
        }

        public BigInteger getG() {
            return this.g;
        }
    }

    public static class DigestSecretKeyTemplate
    extends ProxyMessage {
        private final SlotIdentifier slotId;
        private final ObjectIdentifier objectId;
        private final Mechanism mechanism;

        private DigestSecretKeyTemplate(ASN1Sequence seq) throws BadAsn1ObjectException {
            ProxyMessage.requireRange(seq, 3, 3);
            int idx = 0;
            this.slotId = SlotIdentifier.getInstance(seq.getObjectAt(idx++));
            this.objectId = ObjectIdentifier.getInstance(seq.getObjectAt(idx++));
            this.mechanism = Mechanism.getInstance(seq.getObjectAt(idx++));
        }

        public DigestSecretKeyTemplate(SlotIdentifier slotId, ObjectIdentifier objectId, long mechanism) {
            this.slotId = (SlotIdentifier)((Object)Args.notNull((Object)((Object)slotId), (String)"slotId"));
            this.objectId = (ObjectIdentifier)((Object)Args.notNull((Object)((Object)objectId), (String)"objectId"));
            this.mechanism = new Mechanism(mechanism, null);
        }

        public static DigestSecretKeyTemplate getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof DigestSecretKeyTemplate) {
                return (DigestSecretKeyTemplate)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new DigestSecretKeyTemplate((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return DigestSecretKeyTemplate.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)this.slotId);
            vector.add((ASN1Encodable)this.objectId);
            vector.add((ASN1Encodable)this.mechanism);
            return new DERSequence(vector);
        }

        public SlotIdentifier getSlotId() {
            return this.slotId;
        }

        public ObjectIdentifier getObjectId() {
            return this.objectId;
        }

        public Mechanism getMechanism() {
            return this.mechanism;
        }
    }

    public static class AddCertParams
    extends ProxyMessage {
        private final P11SlotIdentifier slotId;
        private final P11Slot.P11NewObjectControl control;
        private final Certificate certificate;

        public AddCertParams(P11SlotIdentifier slotId, P11Slot.P11NewObjectControl control, Certificate certificate) {
            this.slotId = (P11SlotIdentifier)Args.notNull((Object)slotId, (String)"slotId");
            this.control = (P11Slot.P11NewObjectControl)Args.notNull((Object)control, (String)"control");
            this.certificate = (Certificate)Args.notNull((Object)certificate, (String)"certificate");
        }

        public AddCertParams(P11SlotIdentifier slotId, P11Slot.P11NewObjectControl control, X509Certificate certificate) {
            byte[] encoded;
            this.slotId = (P11SlotIdentifier)Args.notNull((Object)slotId, (String)"slotId");
            this.control = (P11Slot.P11NewObjectControl)Args.notNull((Object)control, (String)"control");
            Args.notNull((Object)certificate, (String)"certificate");
            try {
                encoded = certificate.getEncoded();
            }
            catch (CertificateEncodingException ex) {
                throw new IllegalArgumentException("could not encode certificate: " + ex.getMessage(), ex);
            }
            this.certificate = Certificate.getInstance((Object)encoded);
        }

        private AddCertParams(ASN1Sequence seq) throws BadAsn1ObjectException {
            ProxyMessage.requireRange(seq, 3, 3);
            int idx = 0;
            this.slotId = SlotIdentifier.getInstance(seq.getObjectAt(idx++)).getValue();
            this.control = NewKeyControl.getInstance(seq.getObjectAt(idx++)).getControl();
            this.certificate = ProxyMessage.getCertificate0(seq.getObjectAt(idx++));
        }

        public static AddCertParams getInstance(Object obj) throws BadAsn1ObjectException {
            if (obj == null || obj instanceof AddCertParams) {
                return (AddCertParams)((Object)obj);
            }
            try {
                if (obj instanceof ASN1Sequence) {
                    return new AddCertParams((ASN1Sequence)obj);
                }
                if (obj instanceof byte[]) {
                    return AddCertParams.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
                }
                throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("unable to parse object: " + ex.getMessage(), ex);
            }
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)new SlotIdentifier(this.slotId));
            vector.add((ASN1Encodable)new NewObjectControl(this.control));
            vector.add((ASN1Encodable)this.certificate);
            return new DERSequence(vector);
        }

        public P11SlotIdentifier getSlotId() {
            return this.slotId;
        }

        public P11Slot.P11NewObjectControl getControl() {
            return this.control;
        }

        public Certificate getCertificate() {
            return this.certificate;
        }
    }
}

