/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import iaik.pkcs.pkcs11.constants.PKCS11Constants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.bsi.BSIObjectIdentifiers;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.HashAlgo;
import org.xipki.security.XiContentSigner;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.DigestOutputStream;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11PlainRSASigner;
import org.xipki.security.pkcs11.P11RSAKeyParameter;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.util.GMUtil;
import org.xipki.security.util.SignerUtil;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;

abstract class P11ContentSigner
implements XiContentSigner {
    private static final Logger LOG = LoggerFactory.getLogger(P11ContentSigner.class);
    protected final P11CryptService cryptService;
    protected final P11IdentityId identityId;
    protected final AlgorithmIdentifier algorithmIdentifier;
    protected final byte[] encodedAlgorithmIdentifier;

    P11ContentSigner(P11CryptService cryptService, P11IdentityId identityId, AlgorithmIdentifier signatureAlgId) throws XiSecurityException, P11TokenException {
        this.identityId = (P11IdentityId)Args.notNull((Object)identityId, (String)"identityId");
        this.cryptService = (P11CryptService)Args.notNull((Object)cryptService, (String)"cryptService");
        this.algorithmIdentifier = (AlgorithmIdentifier)Args.notNull((Object)signatureAlgId, (String)"signatureAlgId");
        try {
            this.encodedAlgorithmIdentifier = this.algorithmIdentifier.getEncoded();
        }
        catch (IOException ex) {
            throw new XiSecurityException("could not encode AlgorithmIdentifier", ex);
        }
    }

    public final AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    public final byte[] getEncodedAlgorithmIdentifier() {
        return Arrays.copyOf(this.encodedAlgorithmIdentifier, this.encodedAlgorithmIdentifier.length);
    }

    static class SM2
    extends P11ContentSigner {
        private static final Map<String, HashAlgo> sigAlgHashMap = new HashMap<String, HashAlgo>();
        private static final Map<HashAlgo, Long> hashMechMap = new HashMap<HashAlgo, Long>();
        private final long mechanism;
        private final OutputStream outputStream;
        private final byte[] z;

        SM2(P11CryptService cryptService, P11IdentityId identityId, AlgorithmIdentifier signatureAlgId, ASN1ObjectIdentifier curveOid, BigInteger pubPointX, BigInteger pubPointY) throws XiSecurityException, P11TokenException {
            super(cryptService, identityId, signatureAlgId);
            String algOid = signatureAlgId.getAlgorithm().getId();
            HashAlgo hashAlgo = sigAlgHashMap.get(algOid);
            if (hashAlgo == null) {
                throw new XiSecurityException("unsupported signature algorithm " + algOid);
            }
            P11Slot slot = cryptService.getSlot(identityId.getSlotId());
            if (slot.supportsMechanism(PKCS11Constants.CKM_VENDOR_SM2)) {
                this.z = GMUtil.getSM2Z(curveOid, pubPointX, pubPointY);
                this.mechanism = PKCS11Constants.CKM_VENDOR_SM2;
                Digest digest = hashAlgo.createDigest();
                this.outputStream = new DigestOutputStream(digest);
            } else {
                this.z = null;
                Long ll = hashMechMap.get((Object)hashAlgo);
                if (ll == null) {
                    throw new XiSecurityException("hash algorithm " + (Object)((Object)hashAlgo) + " is not suitable for SM2");
                }
                this.mechanism = ll;
                if (!slot.supportsMechanism(this.mechanism)) {
                    throw new XiSecurityException("unsupported signature algorithm " + algOid);
                }
                this.outputStream = new ByteArrayOutputStream();
            }
        }

        public OutputStream getOutputStream() {
            this.reset();
            return this.outputStream;
        }

        private void reset() {
            if (this.outputStream instanceof ByteArrayOutputStream) {
                ((ByteArrayOutputStream)this.outputStream).reset();
            } else {
                ((DigestOutputStream)this.outputStream).reset();
                try {
                    this.outputStream.write(this.z, 0, this.z.length);
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex.getMessage());
                }
            }
        }

        public byte[] getSignature() {
            try {
                byte[] plainSignature = this.getPlainSignature();
                return SignerUtil.dsaSigPlainToX962(plainSignature);
            }
            catch (XiSecurityException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex);
                throw new RuntimeCryptoException("XiSecurityException: " + ex.getMessage());
            }
            catch (Throwable th) {
                LogUtil.warn((Logger)LOG, (Throwable)th);
                throw new RuntimeCryptoException(th.getClass().getName() + ": " + th.getMessage());
            }
        }

        private byte[] getPlainSignature() throws XiSecurityException, P11TokenException {
            byte[] dataToSign;
            P11Params.P11ByteArrayParams params;
            if (this.outputStream instanceof ByteArrayOutputStream) {
                params = new P11Params.P11ByteArrayParams(GMUtil.getDefaultIDA());
                dataToSign = ((ByteArrayOutputStream)this.outputStream).toByteArray();
            } else {
                params = null;
                dataToSign = ((DigestOutputStream)this.outputStream).digest();
            }
            this.reset();
            return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, params, dataToSign);
        }

        static {
            sigAlgHashMap.put(GMObjectIdentifiers.sm2sign_with_sm3.getId(), HashAlgo.SM3);
            hashMechMap.put(HashAlgo.SM3, PKCS11Constants.CKM_VENDOR_SM2_SM3);
        }
    }

    static class RSAPSS
    extends P11ContentSigner {
        private static final Map<HashAlgo, Long> hashAlgMecMap = new HashMap<HashAlgo, Long>();
        private final long mechanism;
        private final P11Params.P11RSAPkcsPssParams parameters;
        private final OutputStream outputStream;

        RSAPSS(P11CryptService cryptService, P11IdentityId identityId, AlgorithmIdentifier signatureAlgId, SecureRandom random) throws XiSecurityException, P11TokenException {
            super(cryptService, identityId, signatureAlgId);
            Args.notNull((Object)random, (String)"random");
            if (!PKCSObjectIdentifiers.id_RSASSA_PSS.equals((Object)signatureAlgId.getAlgorithm())) {
                throw new XiSecurityException("unsupported signature algorithm " + signatureAlgId.getAlgorithm());
            }
            RSASSAPSSparams asn1Params = RSASSAPSSparams.getInstance((Object)signatureAlgId.getParameters());
            ASN1ObjectIdentifier digestAlgOid = asn1Params.getHashAlgorithm().getAlgorithm();
            HashAlgo hashAlgo = HashAlgo.getInstance(digestAlgOid);
            if (hashAlgo == null) {
                throw new XiSecurityException("unsupported hash algorithm " + digestAlgOid.getId());
            }
            P11SlotIdentifier slotId = identityId.getSlotId();
            P11Slot slot = cryptService.getSlot(slotId);
            if (slot.supportsMechanism(13L)) {
                this.mechanism = 13L;
                this.parameters = new P11Params.P11RSAPkcsPssParams(asn1Params);
                Digest digest = hashAlgo.createDigest();
                this.outputStream = new DigestOutputStream(digest);
            } else if (slot.supportsMechanism(3L)) {
                P11RSAKeyParameter keyParam;
                this.mechanism = 3L;
                this.parameters = null;
                P11PlainRSASigner cipher = new P11PlainRSASigner();
                try {
                    keyParam = P11RSAKeyParameter.getInstance(cryptService, identityId);
                }
                catch (InvalidKeyException ex) {
                    throw new XiSecurityException(ex.getMessage(), ex);
                }
                PSSSigner pssSigner = SignerUtil.createPSSRSASigner(signatureAlgId, cipher);
                pssSigner.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)keyParam, random));
                this.outputStream = new PSSSignerOutputStream(pssSigner);
            } else {
                Long mech = hashAlgMecMap.get((Object)hashAlgo);
                if (mech == null) {
                    throw new IllegalStateException("should not reach here, unknown HashAlgo " + (Object)((Object)hashAlgo));
                }
                this.mechanism = mech;
                if (!slot.supportsMechanism(this.mechanism)) {
                    throw new XiSecurityException("unsupported signature algorithm " + PKCSObjectIdentifiers.id_RSASSA_PSS.getId() + " with " + (Object)((Object)hashAlgo));
                }
                this.parameters = new P11Params.P11RSAPkcsPssParams(asn1Params);
                this.outputStream = new ByteArrayOutputStream();
            }
        }

        public OutputStream getOutputStream() {
            if (this.outputStream instanceof ByteArrayOutputStream) {
                ((ByteArrayOutputStream)this.outputStream).reset();
            } else if (this.outputStream instanceof DigestOutputStream) {
                ((DigestOutputStream)this.outputStream).reset();
            } else {
                ((PSSSignerOutputStream)this.outputStream).reset();
            }
            return this.outputStream;
        }

        public byte[] getSignature() {
            if (this.outputStream instanceof PSSSignerOutputStream) {
                try {
                    return ((PSSSignerOutputStream)this.outputStream).generateSignature();
                }
                catch (CryptoException ex) {
                    LogUtil.warn((Logger)LOG, (Throwable)ex);
                    throw new RuntimeCryptoException("CryptoException: " + ex.getMessage());
                }
            }
            byte[] dataToSign = this.outputStream instanceof ByteArrayOutputStream ? ((ByteArrayOutputStream)this.outputStream).toByteArray() : ((DigestOutputStream)this.outputStream).digest();
            try {
                return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, this.parameters, dataToSign);
            }
            catch (P11TokenException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"could not sign");
                throw new RuntimeCryptoException("SignerException: " + ex.getMessage());
            }
        }

        static {
            hashAlgMecMap.put(HashAlgo.SHA1, 14L);
            hashAlgMecMap.put(HashAlgo.SHA224, 71L);
            hashAlgMecMap.put(HashAlgo.SHA256, 67L);
            hashAlgMecMap.put(HashAlgo.SHA384, 68L);
            hashAlgMecMap.put(HashAlgo.SHA512, 69L);
            hashAlgMecMap.put(HashAlgo.SHA3_224, 103L);
            hashAlgMecMap.put(HashAlgo.SHA3_256, 99L);
            hashAlgMecMap.put(HashAlgo.SHA3_384, 100L);
            hashAlgMecMap.put(HashAlgo.SHA3_512, 101L);
        }

        private static class PSSSignerOutputStream
        extends OutputStream {
            private PSSSigner pssSigner;

            PSSSignerOutputStream(PSSSigner pssSigner) {
                this.pssSigner = pssSigner;
            }

            @Override
            public void write(int oneByte) throws IOException {
                this.pssSigner.update((byte)oneByte);
            }

            @Override
            public void write(byte[] bytes) throws IOException {
                this.pssSigner.update(bytes, 0, bytes.length);
            }

            @Override
            public void write(byte[] bytes, int off, int len) throws IOException {
                this.pssSigner.update(bytes, off, len);
            }

            public void reset() {
                this.pssSigner.reset();
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }

            byte[] generateSignature() throws DataLengthException, CryptoException {
                byte[] signature = this.pssSigner.generateSignature();
                this.pssSigner.reset();
                return signature;
            }
        }
    }

    static class RSA
    extends P11ContentSigner {
        private static final Map<ASN1ObjectIdentifier, HashAlgo> sigAlgHashAlgMap = new HashMap<ASN1ObjectIdentifier, HashAlgo>();
        private static final Map<HashAlgo, Long> hashAlgMecMap = new HashMap<HashAlgo, Long>();
        private final long mechanism;
        private final OutputStream outputStream;
        private final byte[] digestPkcsPrefix;
        private final int modulusBitLen;

        RSA(P11CryptService cryptService, P11IdentityId identityId, AlgorithmIdentifier signatureAlgId) throws XiSecurityException, P11TokenException {
            super(cryptService, identityId, signatureAlgId);
            ASN1ObjectIdentifier algOid = signatureAlgId.getAlgorithm();
            HashAlgo hashAlgo = sigAlgHashAlgMap.get(algOid);
            if (hashAlgo == null) {
                throw new XiSecurityException("unsupported signature algorithm " + algOid.getId());
            }
            P11SlotIdentifier slotId = identityId.getSlotId();
            P11Slot slot = cryptService.getSlot(slotId);
            if (slot.supportsMechanism(1L)) {
                this.mechanism = 1L;
            } else if (slot.supportsMechanism(3L)) {
                this.mechanism = 3L;
            } else {
                Long mech = hashAlgMecMap.get((Object)hashAlgo);
                if (mech == null) {
                    throw new IllegalStateException("should not reach here, unknown HashAlgo " + (Object)((Object)hashAlgo));
                }
                this.mechanism = mech;
                if (!slot.supportsMechanism(this.mechanism)) {
                    throw new XiSecurityException("unsupported signature algorithm " + algOid.getId());
                }
            }
            if (this.mechanism == 1L || this.mechanism == 3L) {
                this.digestPkcsPrefix = SignerUtil.getDigestPkcsPrefix(hashAlgo);
                Digest digest = hashAlgo.createDigest();
                this.outputStream = new DigestOutputStream(digest);
            } else {
                this.digestPkcsPrefix = null;
                this.outputStream = new ByteArrayOutputStream();
            }
            RSAPublicKey rsaPubKey = (RSAPublicKey)cryptService.getIdentity(identityId).getPublicKey();
            this.modulusBitLen = rsaPubKey.getModulus().bitLength();
        }

        public OutputStream getOutputStream() {
            if (this.outputStream instanceof ByteArrayOutputStream) {
                ((ByteArrayOutputStream)this.outputStream).reset();
            } else {
                ((DigestOutputStream)this.outputStream).reset();
            }
            return this.outputStream;
        }

        public byte[] getSignature() {
            byte[] dataToSign;
            if (this.outputStream instanceof ByteArrayOutputStream) {
                dataToSign = ((ByteArrayOutputStream)this.outputStream).toByteArray();
                ((ByteArrayOutputStream)this.outputStream).reset();
            } else {
                byte[] hashValue = ((DigestOutputStream)this.outputStream).digest();
                ((DigestOutputStream)this.outputStream).reset();
                dataToSign = new byte[this.digestPkcsPrefix.length + hashValue.length];
                System.arraycopy(this.digestPkcsPrefix, 0, dataToSign, 0, this.digestPkcsPrefix.length);
                System.arraycopy(hashValue, 0, dataToSign, this.digestPkcsPrefix.length, hashValue.length);
            }
            try {
                if (this.mechanism == 3L) {
                    dataToSign = SignerUtil.EMSA_PKCS1_v1_5_encoding(dataToSign, this.modulusBitLen);
                }
                return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, null, dataToSign);
            }
            catch (XiSecurityException | P11TokenException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not sign");
                throw new RuntimeCryptoException("SignerException: " + ex.getMessage());
            }
        }

        static {
            sigAlgHashAlgMap.put(PKCSObjectIdentifiers.sha1WithRSAEncryption, HashAlgo.SHA1);
            sigAlgHashAlgMap.put(PKCSObjectIdentifiers.sha224WithRSAEncryption, HashAlgo.SHA224);
            sigAlgHashAlgMap.put(PKCSObjectIdentifiers.sha256WithRSAEncryption, HashAlgo.SHA256);
            sigAlgHashAlgMap.put(PKCSObjectIdentifiers.sha384WithRSAEncryption, HashAlgo.SHA384);
            sigAlgHashAlgMap.put(PKCSObjectIdentifiers.sha512WithRSAEncryption, HashAlgo.SHA512);
            sigAlgHashAlgMap.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224, HashAlgo.SHA3_224);
            sigAlgHashAlgMap.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256, HashAlgo.SHA3_256);
            sigAlgHashAlgMap.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384, HashAlgo.SHA3_384);
            sigAlgHashAlgMap.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512, HashAlgo.SHA3_512);
            hashAlgMecMap.put(HashAlgo.SHA1, 6L);
            hashAlgMecMap.put(HashAlgo.SHA224, 70L);
            hashAlgMecMap.put(HashAlgo.SHA256, 64L);
            hashAlgMecMap.put(HashAlgo.SHA384, 65L);
            hashAlgMecMap.put(HashAlgo.SHA512, 66L);
            hashAlgMecMap.put(HashAlgo.SHA3_224, 102L);
            hashAlgMecMap.put(HashAlgo.SHA3_256, 96L);
            hashAlgMecMap.put(HashAlgo.SHA3_384, 97L);
            hashAlgMecMap.put(HashAlgo.SHA3_512, 98L);
        }
    }

    static class Mac
    extends P11ContentSigner {
        private final long mechanism;
        private final ByteArrayOutputStream outputStream;

        Mac(P11CryptService cryptService, P11IdentityId identityId, AlgorithmIdentifier macAlgId) throws XiSecurityException, P11TokenException {
            super(cryptService, identityId, macAlgId);
            ASN1ObjectIdentifier oid = macAlgId.getAlgorithm();
            if (PKCSObjectIdentifiers.id_hmacWithSHA1.equals((Object)oid)) {
                this.mechanism = 545L;
            } else if (PKCSObjectIdentifiers.id_hmacWithSHA224.equals((Object)oid)) {
                this.mechanism = 598L;
            } else if (PKCSObjectIdentifiers.id_hmacWithSHA256.equals((Object)oid)) {
                this.mechanism = 593L;
            } else if (PKCSObjectIdentifiers.id_hmacWithSHA384.equals((Object)oid)) {
                this.mechanism = 609L;
            } else if (PKCSObjectIdentifiers.id_hmacWithSHA512.equals((Object)oid)) {
                this.mechanism = 625L;
            } else if (NISTObjectIdentifiers.id_hmacWithSHA3_224.equals((Object)oid)) {
                this.mechanism = 694L;
            } else if (NISTObjectIdentifiers.id_hmacWithSHA3_256.equals((Object)oid)) {
                this.mechanism = 689L;
            } else if (NISTObjectIdentifiers.id_hmacWithSHA3_384.equals((Object)oid)) {
                this.mechanism = 705L;
            } else if (NISTObjectIdentifiers.id_hmacWithSHA3_512.equals((Object)oid)) {
                this.mechanism = 721L;
            } else {
                throw new IllegalArgumentException("unknown algorithm identifier " + oid.getId());
            }
            this.outputStream = new ByteArrayOutputStream();
        }

        public OutputStream getOutputStream() {
            this.outputStream.reset();
            return this.outputStream;
        }

        public byte[] getSignature() {
            try {
                byte[] dataToSign = this.outputStream.toByteArray();
                this.outputStream.reset();
                return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, null, dataToSign);
            }
            catch (P11TokenException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex);
                throw new RuntimeCryptoException("P11TokenException: " + ex.getMessage());
            }
            catch (Throwable th) {
                LogUtil.warn((Logger)LOG, (Throwable)th);
                throw new RuntimeCryptoException(th.getClass().getName() + ": " + th.getMessage());
            }
        }
    }

    static class ECDSA
    extends P11ContentSigner {
        private static final Map<String, HashAlgo> sigAlgHashMap = new HashMap<String, HashAlgo>();
        private static final Map<HashAlgo, Long> hashMechMap = new HashMap<HashAlgo, Long>();
        private final OutputStream outputStream;
        private final long mechanism;
        private final boolean plain;

        ECDSA(P11CryptService cryptService, P11IdentityId identityId, AlgorithmIdentifier signatureAlgId, boolean plain) throws XiSecurityException, P11TokenException {
            super(cryptService, identityId, signatureAlgId);
            this.plain = plain;
            String algOid = signatureAlgId.getAlgorithm().getId();
            HashAlgo hashAlgo = sigAlgHashMap.get(algOid);
            if (hashAlgo == null) {
                throw new XiSecurityException("unsupported signature algorithm " + algOid);
            }
            P11Slot slot = cryptService.getSlot(identityId.getSlotId());
            if (slot.supportsMechanism(4161L)) {
                this.mechanism = 4161L;
                Digest digest = hashAlgo.createDigest();
                this.outputStream = new DigestOutputStream(digest);
            } else {
                this.mechanism = hashMechMap.get((Object)hashAlgo);
                if (!slot.supportsMechanism(this.mechanism)) {
                    throw new XiSecurityException("unsupported signature algorithm " + algOid);
                }
                this.outputStream = new ByteArrayOutputStream();
            }
        }

        public OutputStream getOutputStream() {
            if (this.outputStream instanceof ByteArrayOutputStream) {
                ((ByteArrayOutputStream)this.outputStream).reset();
            } else {
                ((DigestOutputStream)this.outputStream).reset();
            }
            return this.outputStream;
        }

        public byte[] getSignature() {
            try {
                byte[] plainSignature = this.getPlainSignature();
                return this.plain ? plainSignature : SignerUtil.dsaSigPlainToX962(plainSignature);
            }
            catch (XiSecurityException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex);
                throw new RuntimeCryptoException("XiSecurityException: " + ex.getMessage());
            }
            catch (Throwable th) {
                LogUtil.warn((Logger)LOG, (Throwable)th);
                throw new RuntimeCryptoException(th.getClass().getName() + ": " + th.getMessage());
            }
        }

        private byte[] getPlainSignature() throws XiSecurityException, P11TokenException {
            byte[] dataToSign;
            if (this.outputStream instanceof ByteArrayOutputStream) {
                dataToSign = ((ByteArrayOutputStream)this.outputStream).toByteArray();
                ((ByteArrayOutputStream)this.outputStream).reset();
            } else {
                dataToSign = ((DigestOutputStream)this.outputStream).digest();
                ((DigestOutputStream)this.outputStream).reset();
            }
            return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, null, dataToSign);
        }

        static {
            sigAlgHashMap.put(X9ObjectIdentifiers.ecdsa_with_SHA1.getId(), HashAlgo.SHA1);
            sigAlgHashMap.put(X9ObjectIdentifiers.ecdsa_with_SHA224.getId(), HashAlgo.SHA224);
            sigAlgHashMap.put(X9ObjectIdentifiers.ecdsa_with_SHA256.getId(), HashAlgo.SHA256);
            sigAlgHashMap.put(X9ObjectIdentifiers.ecdsa_with_SHA384.getId(), HashAlgo.SHA384);
            sigAlgHashMap.put(X9ObjectIdentifiers.ecdsa_with_SHA512.getId(), HashAlgo.SHA512);
            sigAlgHashMap.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_224.getId(), HashAlgo.SHA3_224);
            sigAlgHashMap.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_256.getId(), HashAlgo.SHA3_256);
            sigAlgHashMap.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_384.getId(), HashAlgo.SHA3_384);
            sigAlgHashMap.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_512.getId(), HashAlgo.SHA3_512);
            sigAlgHashMap.put(BSIObjectIdentifiers.ecdsa_plain_SHA1.getId(), HashAlgo.SHA1);
            sigAlgHashMap.put(BSIObjectIdentifiers.ecdsa_plain_SHA224.getId(), HashAlgo.SHA224);
            sigAlgHashMap.put(BSIObjectIdentifiers.ecdsa_plain_SHA256.getId(), HashAlgo.SHA256);
            sigAlgHashMap.put(BSIObjectIdentifiers.ecdsa_plain_SHA384.getId(), HashAlgo.SHA384);
            sigAlgHashMap.put(BSIObjectIdentifiers.ecdsa_plain_SHA512.getId(), HashAlgo.SHA512);
            hashMechMap.put(HashAlgo.SHA1, 4162L);
            hashMechMap.put(HashAlgo.SHA224, 4163L);
            hashMechMap.put(HashAlgo.SHA256, 4164L);
            hashMechMap.put(HashAlgo.SHA384, 4165L);
            hashMechMap.put(HashAlgo.SHA512, 4166L);
            hashMechMap.put(HashAlgo.SHA3_224, 4167L);
            hashMechMap.put(HashAlgo.SHA3_256, 4168L);
            hashMechMap.put(HashAlgo.SHA3_384, 4169L);
            hashMechMap.put(HashAlgo.SHA3_512, 4170L);
        }
    }

    static class DSA
    extends P11ContentSigner {
        private static final Map<String, HashAlgo> sigAlgHashMap = new HashMap<String, HashAlgo>();
        private static final Map<HashAlgo, Long> hashMechMap = new HashMap<HashAlgo, Long>();
        private final OutputStream outputStream;
        private final long mechanism;
        private final boolean plain;

        DSA(P11CryptService cryptService, P11IdentityId identityId, AlgorithmIdentifier signatureAlgId, boolean plain) throws XiSecurityException, P11TokenException {
            super(cryptService, identityId, signatureAlgId);
            this.plain = plain;
            String algOid = signatureAlgId.getAlgorithm().getId();
            HashAlgo hashAlgo = sigAlgHashMap.get(algOid);
            if (hashAlgo == null) {
                throw new XiSecurityException("unsupported signature algorithm " + algOid);
            }
            P11SlotIdentifier slotId = identityId.getSlotId();
            P11Slot slot = cryptService.getSlot(slotId);
            if (slot.supportsMechanism(17L)) {
                this.mechanism = 17L;
                Digest digest = hashAlgo.createDigest();
                this.outputStream = new DigestOutputStream(digest);
            } else {
                this.mechanism = hashMechMap.get((Object)hashAlgo);
                if (!slot.supportsMechanism(this.mechanism)) {
                    throw new XiSecurityException("unsupported signature algorithm " + algOid);
                }
                this.outputStream = new ByteArrayOutputStream();
            }
        }

        public OutputStream getOutputStream() {
            if (this.outputStream instanceof ByteArrayOutputStream) {
                ((ByteArrayOutputStream)this.outputStream).reset();
            } else {
                ((DigestOutputStream)this.outputStream).reset();
            }
            return this.outputStream;
        }

        public byte[] getSignature() {
            try {
                byte[] plainSignature = this.getPlainSignature();
                return this.plain ? plainSignature : SignerUtil.dsaSigPlainToX962(plainSignature);
            }
            catch (XiSecurityException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex);
                throw new RuntimeCryptoException("XiSecurityException: " + ex.getMessage());
            }
            catch (Throwable th) {
                LogUtil.warn((Logger)LOG, (Throwable)th);
                throw new RuntimeCryptoException(th.getClass().getName() + ": " + th.getMessage());
            }
        }

        private byte[] getPlainSignature() throws XiSecurityException, P11TokenException {
            byte[] dataToSign;
            if (this.outputStream instanceof ByteArrayOutputStream) {
                dataToSign = ((ByteArrayOutputStream)this.outputStream).toByteArray();
                ((ByteArrayOutputStream)this.outputStream).reset();
            } else {
                dataToSign = ((DigestOutputStream)this.outputStream).digest();
                ((DigestOutputStream)this.outputStream).reset();
            }
            return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, null, dataToSign);
        }

        static {
            sigAlgHashMap.put(X9ObjectIdentifiers.id_dsa_with_sha1.getId(), HashAlgo.SHA1);
            sigAlgHashMap.put(NISTObjectIdentifiers.dsa_with_sha224.getId(), HashAlgo.SHA224);
            sigAlgHashMap.put(NISTObjectIdentifiers.dsa_with_sha256.getId(), HashAlgo.SHA256);
            sigAlgHashMap.put(NISTObjectIdentifiers.dsa_with_sha384.getId(), HashAlgo.SHA384);
            sigAlgHashMap.put(NISTObjectIdentifiers.dsa_with_sha512.getId(), HashAlgo.SHA512);
            sigAlgHashMap.put(NISTObjectIdentifiers.id_dsa_with_sha3_224.getId(), HashAlgo.SHA3_224);
            sigAlgHashMap.put(NISTObjectIdentifiers.id_dsa_with_sha3_256.getId(), HashAlgo.SHA3_256);
            sigAlgHashMap.put(NISTObjectIdentifiers.id_dsa_with_sha3_384.getId(), HashAlgo.SHA3_384);
            sigAlgHashMap.put(NISTObjectIdentifiers.id_dsa_with_sha3_512.getId(), HashAlgo.SHA3_512);
            hashMechMap.put(HashAlgo.SHA1, 18L);
            hashMechMap.put(HashAlgo.SHA224, 19L);
            hashMechMap.put(HashAlgo.SHA256, 20L);
            hashMechMap.put(HashAlgo.SHA384, 21L);
            hashMechMap.put(HashAlgo.SHA512, 22L);
            hashMechMap.put(HashAlgo.SHA3_224, 24L);
            hashMechMap.put(HashAlgo.SHA3_256, 25L);
            hashMechMap.put(HashAlgo.SHA3_384, 26L);
            hashMechMap.put(HashAlgo.SHA3_512, 27L);
        }
    }
}

