/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.provider;

import iaik.pkcs.pkcs11.constants.PKCS11Constants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPoint;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.xipki.security.HashAlgo;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.DigestOutputStream;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11PrivateKey;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.pkcs11.provider.XiSM2ParameterSpec;
import org.xipki.security.util.GMUtil;
import org.xipki.security.util.SignerUtil;
import org.xipki.util.StringUtil;

public class P11SM3WithSM2SignatureSpi
extends SignatureSpi {
    private long mechanism;
    private OutputStream outputStream;
    private P11PrivateKey signingKey;
    private XiSM2ParameterSpec paramSpec;
    private byte[] sm2Z;
    private P11Params p11Params;

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        throw new UnsupportedOperationException("engineInitVerify unsupported");
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        byte[] userId;
        if (!(privateKey instanceof P11PrivateKey)) {
            throw new InvalidKeyException("privateKey is not instanceof " + P11PrivateKey.class.getName());
        }
        this.signingKey = (P11PrivateKey)privateKey;
        if (!(this.signingKey.getPublicKey() instanceof ECPublicKey)) {
            throw new InvalidKeyException("only EC key is allowed");
        }
        ECPublicKey pubKey = (ECPublicKey)this.signingKey.getPublicKey();
        if (!GMUtil.isSm2primev2Curve(pubKey.getParams().getCurve())) {
            throw new InvalidKeyException("only EC key of curve sm2primev2 is allowed");
        }
        String algo = privateKey.getAlgorithm();
        if (!"EC".equals(algo) && !"ECDSA".equals(algo)) {
            throw new InvalidKeyException("privateKey is not an EC private key: " + algo);
        }
        byte[] byArray = userId = this.paramSpec == null ? StringUtil.toUtf8Bytes((String)"1234567812345678") : this.paramSpec.getId();
        if (this.signingKey.supportsMechanism(PKCS11Constants.CKM_VENDOR_SM2)) {
            this.mechanism = PKCS11Constants.CKM_VENDOR_SM2;
            this.outputStream = new DigestOutputStream(HashAlgo.SM3.createDigest());
            this.p11Params = null;
            ECPoint w = pubKey.getW();
            this.sm2Z = GMUtil.getSM2Z(userId, GMObjectIdentifiers.sm2p256v1, w.getAffineX(), w.getAffineY());
            try {
                this.outputStream.write(this.sm2Z, 0, this.sm2Z.length);
            }
            catch (IOException ex) {
                throw new InvalidKeyException("could not compute Z of SM2");
            }
        } else if (this.signingKey.supportsMechanism(PKCS11Constants.CKM_VENDOR_SM2_SM3)) {
            this.mechanism = PKCS11Constants.CKM_VENDOR_SM2_SM3;
            this.outputStream = new ByteArrayOutputStream();
            this.p11Params = new P11Params.P11ByteArrayParams(userId);
        } else {
            throw new InvalidKeyException("privateKey and algorithm does not match");
        }
        this.signingKey = (P11PrivateKey)privateKey;
    }

    @Override
    protected void engineUpdate(byte input) throws SignatureException {
        try {
            this.outputStream.write(input);
        }
        catch (IOException ex) {
            throw new SignatureException("IOException: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected void engineUpdate(byte[] input, int off, int len) throws SignatureException {
        try {
            this.outputStream.write(input, off, len);
        }
        catch (IOException ex) {
            throw new SignatureException("IOException: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] dataToSign;
        if (this.outputStream instanceof ByteArrayOutputStream) {
            dataToSign = ((ByteArrayOutputStream)this.outputStream).toByteArray();
            ((ByteArrayOutputStream)this.outputStream).reset();
        } else {
            dataToSign = ((DigestOutputStream)this.outputStream).digest();
            ((DigestOutputStream)this.outputStream).reset();
            try {
                this.outputStream.write(this.sm2Z, 0, this.sm2Z.length);
            }
            catch (IOException ex) {
                throw new SignatureException(ex.getMessage(), ex);
            }
        }
        try {
            byte[] plainSignature = this.signingKey.sign(this.mechanism, this.p11Params, dataToSign);
            return SignerUtil.dsaSigPlainToX962(plainSignature);
        }
        catch (XiSecurityException | P11TokenException ex) {
            throw new SignatureException(ex.getMessage(), ex);
        }
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (!(params instanceof XiSM2ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("only XiSM2ParameterSpec supported");
        }
        this.paramSpec = (XiSM2ParameterSpec)params;
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        throw new UnsupportedOperationException("engineVerify unsupported");
    }
}

