/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.BadInputException;
import org.xipki.security.FpIdCalculator;
import org.xipki.security.KeyUsage;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.Hex;
import org.xipki.util.IoUtil;
import org.xipki.util.PemEncoder;
import org.xipki.util.StringUtil;

public class X509Util {
    private static final Logger LOG = LoggerFactory.getLogger(X509Util.class);
    private static final byte[] BEGIN_PEM = StringUtil.toUtf8Bytes((String)"-----BEGIN");
    private static final byte[] END_PEM = StringUtil.toUtf8Bytes((String)"-----END");
    private static final byte[] PEM_SEP = StringUtil.toUtf8Bytes((String)"-----");
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private static CertificateFactory certFact;
    private static Object certFactLock;

    private X509Util() {
    }

    public static String getCommonName(X500Principal name) {
        Args.notNull((Object)name, (String)"name");
        return X509Util.getCommonName(X500Name.getInstance((Object)name.getEncoded()));
    }

    public static String getCommonName(X500Name name) {
        Args.notNull((Object)name, (String)"name");
        RDN[] rdns = name.getRDNs(ObjectIdentifiers.DN.CN);
        if (rdns != null && rdns.length > 0) {
            RDN rdn = rdns[0];
            AttributeTypeAndValue atv = null;
            if (rdn.isMultiValued()) {
                for (AttributeTypeAndValue m : rdn.getTypesAndValues()) {
                    if (!m.getType().equals((Object)ObjectIdentifiers.DN.CN)) continue;
                    atv = m;
                    break;
                }
            } else {
                atv = rdn.getFirst();
            }
            return atv == null ? null : X509Util.rdnValueToString(atv.getValue());
        }
        return null;
    }

    public static X500Name reverse(X500Name name) {
        RDN[] orig = ((X500Name)Args.notNull((Object)name, (String)"name")).getRDNs();
        int n = orig.length;
        RDN[] newRdn = new RDN[n];
        for (int i = 0; i < n; ++i) {
            newRdn[i] = orig[n - 1 - i];
        }
        return new X500Name(newRdn);
    }

    public static X509Certificate parseCert(File file) throws IOException, CertificateException {
        Args.notNull((Object)file, (String)"file");
        try (InputStream in = Files.newInputStream(IoUtil.expandFilepath((File)file).toPath(), new OpenOption[0]);){
            X509Certificate x509Certificate = X509Util.parseCert(in);
            return x509Certificate;
        }
    }

    public static X509Certificate parseCert(InputStream certStream) throws IOException, CertificateException {
        Args.notNull((Object)certStream, (String)"certStream");
        return X509Util.parseCert(IoUtil.read((InputStream)certStream));
    }

    public static X509Certificate parseCert(byte[] certBytes) throws CertificateException {
        Args.notNull((Object)certBytes, (String)"certBytes");
        X509Certificate cert = (X509Certificate)X509Util.getCertFactory().generateCertificate(new ByteArrayInputStream(X509Util.toDerEncoded(certBytes)));
        if (cert == null) {
            throw new CertificateEncodingException("the given one is not a valid X.509 certificate");
        }
        return cert;
    }

    public static Certificate parseBcCert(File file) throws IOException, CertificateException {
        Args.notNull((Object)file, (String)"file");
        try (InputStream in = Files.newInputStream(IoUtil.expandFilepath((File)file).toPath(), new OpenOption[0]);){
            Certificate certificate = X509Util.parseBcCert(in);
            return certificate;
        }
    }

    public static Certificate parseBcCert(InputStream certStream) throws IOException, CertificateException {
        Args.notNull((Object)certStream, (String)"certStream");
        return X509Util.parseBcCert(IoUtil.read((InputStream)certStream));
    }

    public static Certificate parseBcCert(byte[] certBytes) throws CertificateException {
        Args.notNull((Object)certBytes, (String)"certBytes");
        try {
            return Certificate.getInstance((Object)X509Util.toDerEncoded(certBytes));
        }
        catch (IllegalArgumentException ex) {
            throw new CertificateEncodingException("the given one is not a valid X.509 certificate");
        }
    }

    public static CertificationRequest parseCsr(File file) throws IOException {
        Args.notNull((Object)file, (String)"file");
        try (InputStream in = Files.newInputStream(IoUtil.expandFilepath((File)file).toPath(), new OpenOption[0]);){
            CertificationRequest certificationRequest = X509Util.parseCsr(in);
            return certificationRequest;
        }
    }

    public static CertificationRequest parseCsr(InputStream csrStream) throws IOException {
        Args.notNull((Object)csrStream, (String)"csrStream");
        return X509Util.parseCsr(IoUtil.read((InputStream)csrStream));
    }

    public static CertificationRequest parseCsr(byte[] csrBytes) {
        Args.notNull((Object)csrBytes, (String)"csrBytes");
        return CertificationRequest.getInstance((Object)X509Util.toDerEncoded(csrBytes));
    }

    public static byte[] toDerEncoded(byte[] bytes) {
        int len = bytes.length;
        if (len > 23 && CompareUtil.areEqual((byte[])bytes, (int)0, (byte[])BEGIN_PEM, (int)0, (int)BEGIN_PEM.length)) {
            int i;
            int base64Start = -1;
            int base64End = -1;
            for (i = BEGIN_PEM.length + 1; i < len; ++i) {
                if (!CompareUtil.areEqual((byte[])bytes, (int)i, (byte[])PEM_SEP, (int)0, (int)PEM_SEP.length)) continue;
                base64Start = i + PEM_SEP.length;
                break;
            }
            if (bytes[base64Start] == 10) {
                ++base64Start;
            }
            for (i = len - END_PEM.length - 6; i > 0; --i) {
                if (!CompareUtil.areEqual((byte[])bytes, (int)i, (byte[])END_PEM, (int)0, (int)END_PEM.length)) continue;
                base64End = i - 1;
                break;
            }
            if (bytes[base64End - 1] == 13) {
                --base64End;
            }
            byte[] base64Bytes = new byte[base64End - base64Start + 1];
            System.arraycopy(bytes, base64Start, base64Bytes, 0, base64Bytes.length);
            return Base64.decode((byte[])base64Bytes);
        }
        if (Base64.containsOnlyBase64Chars((byte[])bytes, (int)0, (int)10)) {
            return Base64.decode((byte[])bytes);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CertificateFactory getCertFactory() throws CertificateException {
        Object object = certFactLock;
        synchronized (object) {
            if (certFact == null) {
                try {
                    certFact = CertificateFactory.getInstance("X.509", "BC");
                }
                catch (NoSuchProviderException ex) {
                    throw new CertificateException("NoSuchProviderException: " + ex.getMessage());
                }
            }
            return certFact;
        }
    }

    public static String toPemCert(X509Certificate cert) throws CertificateException {
        Args.notNull((Object)cert, (String)"cert");
        return new String(PemEncoder.encode((byte[])cert.getEncoded(), (PemEncoder.PemLabel)PemEncoder.PemLabel.CERTIFICATE));
    }

    public static X509Certificate toX509Cert(Certificate asn1Cert) throws CertificateException {
        byte[] encodedCert;
        try {
            encodedCert = asn1Cert.getEncoded();
        }
        catch (IOException ex) {
            throw new CertificateEncodingException("could not get encoded certificate", ex);
        }
        return X509Util.parseCert(encodedCert);
    }

    public static X509CRL toX509Crl(CertificateList asn1CertList) throws CertificateException, CRLException {
        byte[] encodedCrl;
        try {
            encodedCrl = asn1CertList.getEncoded();
        }
        catch (IOException ex) {
            throw new CRLException("could not get encoded CRL", ex);
        }
        return X509Util.parseCrl(encodedCrl);
    }

    public static X509CRL parseCrl(File file) throws IOException, CertificateException, CRLException {
        Args.notNull((Object)file, (String)"file");
        return X509Util.parseCrl(Files.newInputStream(IoUtil.expandFilepath((File)file).toPath(), new OpenOption[0]));
    }

    public static X509CRL parseCrl(byte[] encodedCrl) throws CertificateException, CRLException {
        Args.notNull((Object)encodedCrl, (String)"encodedCrl");
        return X509Util.parseCrl(new ByteArrayInputStream(X509Util.toDerEncoded(encodedCrl)));
    }

    public static X509CRL parseCrl(InputStream crlStream) throws CertificateException, CRLException {
        Args.notNull((Object)crlStream, (String)"crlStream");
        X509CRL crl = (X509CRL)X509Util.getCertFactory().generateCRL(crlStream);
        if (crl == null) {
            throw new CRLException("the given one is not a valid X.509 CRL");
        }
        return crl;
    }

    public static String getRfc4519Name(X500Principal name) {
        Args.notNull((Object)name, (String)"name");
        return X509Util.getRfc4519Name(X500Name.getInstance((Object)name.getEncoded()));
    }

    public static String getRfc4519Name(X500Name name) {
        Args.notNull((Object)name, (String)"name");
        return RFC4519Style.INSTANCE.toString(name);
    }

    public static long fpCanonicalizedName(X500Principal prin) {
        Args.notNull((Object)prin, (String)"prin");
        X500Name x500Name = X500Name.getInstance((Object)prin.getEncoded());
        return X509Util.fpCanonicalizedName(x500Name);
    }

    public static long fpCanonicalizedName(X500Name name) {
        Args.notNull((Object)name, (String)"name");
        String canonicalizedName = X509Util.canonicalizName(name);
        byte[] encoded = StringUtil.toUtf8Bytes((String)canonicalizedName);
        return FpIdCalculator.hash(encoded);
    }

    public static String canonicalizName(X500Name name) {
        Args.notNull((Object)name, (String)"name");
        ASN1ObjectIdentifier[] tmpTypes = name.getAttributeTypes();
        int len = tmpTypes.length;
        ArrayList<String> types = new ArrayList<String>(len);
        for (ASN1ObjectIdentifier type : tmpTypes) {
            types.add(type.getId());
        }
        Collections.sort(types);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            String type = (String)types.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append(type).append("=");
            RDN[] rdns = name.getRDNs(new ASN1ObjectIdentifier(type));
            ArrayList<String> values = new ArrayList<String>(1);
            for (int j = 0; j < rdns.length; ++j) {
                RDN rdn = rdns[j];
                if (rdn.isMultiValued()) {
                    AttributeTypeAndValue[] atvs;
                    for (AttributeTypeAndValue atv : atvs = rdn.getTypesAndValues()) {
                        if (!type.equals(atv.getType().getId())) continue;
                        String textValue = IETFUtils.valueToString((ASN1Encodable)atv.getValue()).toLowerCase();
                        values.add(textValue);
                    }
                    continue;
                }
                String textValue = IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue()).toLowerCase();
                values.add(textValue);
            }
            sb.append((String)values.get(0));
            int n2 = values.size();
            if (n2 <= 1) continue;
            for (int j = 1; j < n2; ++j) {
                sb.append(";").append((String)values.get(j));
            }
        }
        return sb.toString();
    }

    public static byte[] extractSki(X509Certificate cert) throws CertificateEncodingException {
        byte[] extValue = X509Util.getCoreExtValue(cert, Extension.subjectKeyIdentifier);
        if (extValue == null) {
            return null;
        }
        try {
            return ASN1OctetString.getInstance((Object)extValue).getOctets();
        }
        catch (IllegalArgumentException ex) {
            throw new CertificateEncodingException(ex.getMessage());
        }
    }

    public static byte[] extractSki(Certificate cert) throws CertificateEncodingException {
        Args.notNull((Object)cert, (String)"cert");
        Extension encodedSkiValue = cert.getTBSCertificate().getExtensions().getExtension(Extension.subjectKeyIdentifier);
        if (encodedSkiValue == null) {
            return null;
        }
        try {
            return ASN1OctetString.getInstance((Object)encodedSkiValue.getParsedValue()).getOctets();
        }
        catch (IllegalArgumentException ex) {
            throw new CertificateEncodingException("invalid extension SubjectKeyIdentifier: " + ex.getMessage());
        }
    }

    public static byte[] extractAki(X509Certificate cert) throws CertificateEncodingException {
        byte[] extValue = X509Util.getCoreExtValue(cert, Extension.authorityKeyIdentifier);
        if (extValue == null) {
            return null;
        }
        try {
            AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.getInstance((Object)extValue);
            return aki.getKeyIdentifier();
        }
        catch (IllegalArgumentException ex) {
            throw new CertificateEncodingException("invalid extension AuthorityKeyIdentifier: " + ex.getMessage());
        }
    }

    public static byte[] extractAki(Certificate cert) throws CertificateEncodingException {
        Args.notNull((Object)cert, (String)"cert");
        try {
            AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.fromExtensions((Extensions)cert.getTBSCertificate().getExtensions());
            return aki == null ? null : aki.getKeyIdentifier();
        }
        catch (IllegalArgumentException ex) {
            throw new CertificateEncodingException("invalid extension AuthorityKeyIdentifier: " + ex.getMessage());
        }
    }

    public static String rdnValueToString(ASN1Encodable value) {
        Args.notNull((Object)value, (String)"value");
        if (value instanceof ASN1String && !(value instanceof DERUniversalString)) {
            return ((ASN1String)value).getString();
        }
        try {
            return "#" + Hex.encode((byte[])value.toASN1Primitive().getEncoded("DER"));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("other value has no encoded form");
        }
    }

    public static org.bouncycastle.asn1.x509.KeyUsage createKeyUsage(Set<KeyUsage> usages) {
        if (CollectionUtil.isEmpty(usages)) {
            return null;
        }
        int usage = 0;
        for (KeyUsage keyUsage : usages) {
            usage |= keyUsage.getBcUsage();
        }
        return new org.bouncycastle.asn1.x509.KeyUsage(usage);
    }

    public static ExtendedKeyUsage createExtendedUsage(Collection<ASN1ObjectIdentifier> usages) {
        if (CollectionUtil.isEmpty(usages)) {
            return null;
        }
        ArrayList<ASN1ObjectIdentifier> list = new ArrayList<ASN1ObjectIdentifier>(usages);
        List<ASN1ObjectIdentifier> sortedUsages = X509Util.sortOidList(list);
        KeyPurposeId[] kps = new KeyPurposeId[sortedUsages.size()];
        int idx = 0;
        for (ASN1ObjectIdentifier oid : sortedUsages) {
            kps[idx++] = KeyPurposeId.getInstance((Object)oid);
        }
        return new ExtendedKeyUsage(kps);
    }

    public static List<ASN1ObjectIdentifier> sortOidList(List<ASN1ObjectIdentifier> oids) {
        Args.notNull(oids, (String)"oids");
        ArrayList<String> list = new ArrayList<String>(oids.size());
        for (ASN1ObjectIdentifier m : oids) {
            list.add(m.getId());
        }
        Collections.sort(list);
        ArrayList<ASN1ObjectIdentifier> sorted = new ArrayList<ASN1ObjectIdentifier>(oids.size());
        for (String m : list) {
            for (ASN1ObjectIdentifier n : oids) {
                if (!m.equals(n.getId()) || sorted.contains(n)) continue;
                sorted.add(n);
            }
        }
        return sorted;
    }

    public static boolean hasKeyusage(X509Certificate cert, KeyUsage usage) {
        Args.notNull((Object)cert, (String)"cert");
        boolean[] keyusage = cert.getKeyUsage();
        if (keyusage != null && keyusage.length > usage.getBit()) {
            return keyusage[usage.getBit()];
        }
        return false;
    }

    public static byte[] getCoreExtValue(X509Certificate cert, ASN1ObjectIdentifier type) throws CertificateEncodingException {
        Args.notNull((Object)cert, (String)"cert");
        Args.notNull((Object)type, (String)"type");
        byte[] fullExtValue = cert.getExtensionValue(type.getId());
        if (fullExtValue == null) {
            return null;
        }
        try {
            return ASN1OctetString.getInstance((Object)fullExtValue).getOctets();
        }
        catch (IllegalArgumentException ex) {
            throw new CertificateEncodingException("invalid extension " + type.getId() + ": " + ex.getMessage());
        }
    }

    public static byte[] getCoreExtValue(X509AttributeCertificateHolder cert, ASN1ObjectIdentifier type) throws CertificateEncodingException {
        Args.notNull((Object)cert, (String)"cert");
        Args.notNull((Object)type, (String)"type");
        Extension ext = cert.getExtension(type);
        if (ext == null) {
            return null;
        }
        return ext.getExtnValue().getOctets();
    }

    public static X509Certificate[] buildCertPath(X509Certificate targetCert, Collection<? extends java.security.cert.Certificate> certs) throws CertPathBuilderException {
        return X509Util.buildCertPath(targetCert, certs, true);
    }

    public static X509Certificate[] buildCertPath(X509Certificate targetCert, Collection<? extends java.security.cert.Certificate> certs, boolean includeTargetCert) throws CertPathBuilderException {
        LinkedList<X509Certificate> certChain;
        block7: {
            Args.notNull((Object)targetCert, (String)"cert");
            certChain = new LinkedList<X509Certificate>();
            certChain.add(targetCert);
            try {
                X509Certificate caCert;
                if (certs == null || X509Util.isSelfSigned(targetCert)) break block7;
                while ((caCert = X509Util.getCaCertOf((X509Certificate)certChain.get(certChain.size() - 1), certs)) != null) {
                    certChain.add(caCert);
                    if (!X509Util.isSelfSigned(caCert)) continue;
                    break;
                }
            }
            catch (CertificateEncodingException ex) {
                LOG.warn("CertificateEncodingException: {}", (Object)ex.getMessage());
            }
        }
        int n = certChain.size();
        if (n == 1) {
            return includeTargetCert ? certChain.toArray(new X509Certificate[0]) : null;
        }
        int targetPathLen = targetCert.getBasicConstraints();
        int minPathLen = targetPathLen != -1 ? 0 : (targetPathLen == Integer.MAX_VALUE ? 1 : targetPathLen + 1);
        for (int i = 1; i < n; ++i) {
            int pathLen = ((X509Certificate)certChain.get(i)).getBasicConstraints();
            if (pathLen < minPathLen) {
                throw new CertPathBuilderException("PathLen too small of certificate " + ((X509Certificate)certChain.get(i)).getSubjectX500Principal().getName());
            }
            minPathLen = 1 + (pathLen == Integer.MAX_VALUE ? minPathLen : pathLen);
        }
        if (!includeTargetCert) {
            certChain.remove(0);
        }
        return certChain.toArray(new X509Certificate[0]);
    }

    public static String encodeCertificates(X509Certificate[] certchain) throws CertificateException, IOException {
        if (CollectionUtil.isEmpty((Object[])certchain)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (X509Certificate m : certchain) {
            if (!first) {
                sb.append("\r\n");
                first = false;
            }
            sb.append(X509Util.toPemCert(m));
        }
        return sb.toString();
    }

    public static String encodeCertificates(X509Cert[] certchain) throws CertificateException, IOException {
        if (CollectionUtil.isEmpty((Object[])certchain)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (X509Cert m : certchain) {
            if (!first) {
                sb.append("\r\n");
                first = false;
            }
            sb.append(new String(PemEncoder.encode((byte[])m.getEncodedCert(), (PemEncoder.PemLabel)PemEncoder.PemLabel.CERTIFICATE)));
        }
        return sb.toString();
    }

    public static List<X509Certificate> listCertificates(String encodedCerts) throws CertificateException, IOException {
        LinkedList<X509Certificate> certs = new LinkedList<X509Certificate>();
        try (BufferedReader reader = new BufferedReader(new StringReader(encodedCerts));){
            String line;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            while ((line = reader.readLine()) != null) {
                if (BEGIN_CERTIFICATE.equals(line)) {
                    bout.reset();
                    continue;
                }
                if (END_CERTIFICATE.equals(line)) {
                    certs.add(X509Util.parseCert(bout.toByteArray()));
                    bout.reset();
                    continue;
                }
                bout.write(StringUtil.toUtf8Bytes((String)line));
            }
        }
        return certs;
    }

    private static X509Certificate getCaCertOf(X509Certificate cert, Collection<? extends java.security.cert.Certificate> caCerts) throws CertificateEncodingException {
        Args.notNull((Object)cert, (String)"cert");
        if (X509Util.isSelfSigned(cert)) {
            return null;
        }
        for (java.security.cert.Certificate certificate : caCerts) {
            X509Certificate x509CaCert;
            if (!(certificate instanceof X509Certificate) || !X509Util.issues(x509CaCert = (X509Certificate)certificate, cert)) continue;
            try {
                cert.verify(x509CaCert.getPublicKey());
                return x509CaCert;
            }
            catch (Exception ex) {
                LOG.warn("could not verify certificate: {}", (Object)ex.getMessage());
            }
        }
        return null;
    }

    public static boolean isSelfSigned(X509Certificate cert) throws CertificateEncodingException {
        Args.notNull((Object)cert, (String)"cert");
        boolean equals = cert.getSubjectX500Principal().equals(cert.getIssuerX500Principal());
        if (equals) {
            byte[] ski = X509Util.extractSki(cert);
            byte[] aki = X509Util.extractAki(cert);
            if (ski != null && aki != null) {
                equals = Arrays.equals(ski, aki);
            }
        }
        return equals;
    }

    public static boolean issues(X509Certificate issuerCert, X509Certificate cert) throws CertificateEncodingException {
        Args.notNull((Object)issuerCert, (String)"issuerCert");
        Args.notNull((Object)cert, (String)"cert");
        boolean issues = issuerCert.getSubjectX500Principal().equals(cert.getIssuerX500Principal());
        if (issues) {
            byte[] ski = X509Util.extractSki(issuerCert);
            byte[] aki = X509Util.extractAki(cert);
            if (ski != null && aki != null) {
                issues = Arrays.equals(ski, aki);
            }
        }
        if (issues) {
            long issuerNotBefore = issuerCert.getNotBefore().getTime();
            long issuerNotAfter = issuerCert.getNotAfter().getTime();
            long notBefore = cert.getNotBefore().getTime();
            issues = notBefore <= issuerNotAfter && notBefore >= issuerNotBefore;
        }
        return issues;
    }

    public static boolean issues(Certificate issuerCert, Certificate cert) throws CertificateEncodingException {
        Args.notNull((Object)issuerCert, (String)"issuerCert");
        Args.notNull((Object)cert, (String)"cert");
        boolean issues = issuerCert.getSubject().equals((Object)cert.getIssuer());
        if (issues) {
            byte[] ski = X509Util.extractSki(issuerCert);
            byte[] aki = X509Util.extractAki(cert);
            if (ski != null && aki != null) {
                issues = Arrays.equals(ski, aki);
            }
        }
        if (issues) {
            long issuerNotBefore = issuerCert.getStartDate().getDate().getTime();
            long issuerNotAfter = issuerCert.getEndDate().getDate().getTime();
            long notBefore = cert.getStartDate().getDate().getTime();
            issues = notBefore <= issuerNotAfter && notBefore >= issuerNotBefore;
        }
        return issues;
    }

    public static SubjectPublicKeyInfo toRfc3279Style(SubjectPublicKeyInfo publicKeyInfo) throws InvalidKeySpecException {
        Args.notNull((Object)publicKeyInfo, (String)"publicKeyInfo");
        ASN1ObjectIdentifier algOid = publicKeyInfo.getAlgorithm().getAlgorithm();
        ASN1Encodable keyParameters = publicKeyInfo.getAlgorithm().getParameters();
        if (PKCSObjectIdentifiers.rsaEncryption.equals((Object)algOid)) {
            if (DERNull.INSTANCE.equals((Object)keyParameters)) {
                return publicKeyInfo;
            }
            AlgorithmIdentifier keyAlgId = new AlgorithmIdentifier(algOid, (ASN1Encodable)DERNull.INSTANCE);
            return new SubjectPublicKeyInfo(keyAlgId, publicKeyInfo.getPublicKeyData().getBytes());
        }
        if (X9ObjectIdentifiers.id_dsa.equals((Object)algOid)) {
            if (keyParameters == null) {
                return publicKeyInfo;
            }
            if (DERNull.INSTANCE.equals((Object)keyParameters)) {
                AlgorithmIdentifier keyAlgId = new AlgorithmIdentifier(algOid);
                return new SubjectPublicKeyInfo(keyAlgId, publicKeyInfo.getPublicKeyData().getBytes());
            }
            try {
                DSAParameter.getInstance((Object)keyParameters);
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidKeySpecException("keyParameters is not null and Dss-Parms");
            }
            return publicKeyInfo;
        }
        if (X9ObjectIdentifiers.id_ecPublicKey.equals((Object)algOid)) {
            if (keyParameters == null) {
                throw new InvalidKeySpecException("keyParameters is not an OBJECT IDENTIFIER");
            }
            try {
                ASN1ObjectIdentifier.getInstance((Object)keyParameters);
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidKeySpecException("keyParameters is not an OBJECT IDENTIFIER");
            }
            return publicKeyInfo;
        }
        return publicKeyInfo;
    }

    public static String cutText(String text, int maxLen) {
        Args.notNull((Object)text, (String)"text");
        if (text.length() <= maxLen) {
            return text;
        }
        return StringUtil.concat((String)text.substring(0, maxLen - 13), (String[])new String[]{"...skipped..."});
    }

    public static String cutX500Name(X500Name name, int maxLen) {
        String text = X509Util.getRfc4519Name(name);
        return X509Util.cutText(text, maxLen);
    }

    public static String cutX500Name(X500Principal name, int maxLen) {
        String text = X509Util.getRfc4519Name(name);
        return X509Util.cutText(text, maxLen);
    }

    public static Extension createExtnSubjectAltName(List<String> taggedValues, boolean critical) throws BadInputException {
        GeneralNames names = X509Util.createGeneralNames(taggedValues);
        if (names == null) {
            return null;
        }
        try {
            return new Extension(Extension.subjectAlternativeName, critical, names.getEncoded());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public static Extension createExtnSubjectInfoAccess(List<String> accessMethodAndLocations, boolean critical) throws BadInputException {
        if (CollectionUtil.isEmpty(accessMethodAndLocations)) {
            return null;
        }
        ASN1EncodableVector vector = new ASN1EncodableVector();
        for (String accessMethodAndLocation : accessMethodAndLocations) {
            vector.add((ASN1Encodable)X509Util.createAccessDescription(accessMethodAndLocation));
        }
        DERSequence seq = new DERSequence(vector);
        try {
            return new Extension(Extension.subjectInfoAccess, critical, seq.getEncoded());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public static AccessDescription createAccessDescription(String accessMethodAndLocation) throws BadInputException {
        ConfPairs pairs;
        Args.notNull((Object)accessMethodAndLocation, (String)"accessMethodAndLocation");
        try {
            pairs = new ConfPairs(accessMethodAndLocation);
        }
        catch (IllegalArgumentException ex) {
            throw new BadInputException("invalid accessMethodAndLocation " + accessMethodAndLocation);
        }
        Set oids = pairs.names();
        if (oids == null || oids.size() != 1) {
            throw new BadInputException("invalid accessMethodAndLocation " + accessMethodAndLocation);
        }
        String accessMethodS = (String)oids.iterator().next();
        String taggedValue = pairs.value(accessMethodS);
        ASN1ObjectIdentifier accessMethod = new ASN1ObjectIdentifier(accessMethodS);
        GeneralName location = X509Util.createGeneralName(taggedValue);
        return new AccessDescription(accessMethod, location);
    }

    public static GeneralNames createGeneralNames(List<String> taggedValues) throws BadInputException {
        if (CollectionUtil.isEmpty(taggedValues)) {
            return null;
        }
        int len = taggedValues.size();
        GeneralName[] names = new GeneralName[len];
        for (int i = 0; i < len; ++i) {
            names[i] = X509Util.createGeneralName(taggedValues.get(i));
        }
        return new GeneralNames(names);
    }

    public static GeneralName createGeneralName(String taggedValue) throws BadInputException {
        int idx;
        Args.notBlank((String)taggedValue, (String)"taggedValue");
        int tag = -1;
        String value = null;
        if (taggedValue.charAt(0) == '[' && (idx = taggedValue.indexOf(93, 1)) > 1 && idx < taggedValue.length() - 1) {
            String tagS = taggedValue.substring(1, idx);
            try {
                tag = Integer.parseInt(tagS);
                value = taggedValue.substring(idx + 1);
            }
            catch (NumberFormatException ex) {
                throw new BadInputException("invalid tag '" + tagS + "'");
            }
        }
        if (tag == -1) {
            throw new BadInputException("invalid taggedValue " + taggedValue);
        }
        switch (tag) {
            case 0: {
                if (value == null) {
                    throw new BadInputException("invalid otherName: no value specified");
                }
                int idxSep = value.indexOf("=");
                if (idxSep == -1 || idxSep == 0 || idxSep == value.length() - 1) {
                    throw new BadInputException("invalid otherName " + value);
                }
                String otherTypeOid = value.substring(0, idxSep);
                ASN1ObjectIdentifier type = new ASN1ObjectIdentifier(otherTypeOid);
                String otherValue = value.substring(idxSep + 1);
                ASN1EncodableVector vector = new ASN1EncodableVector();
                vector.add((ASN1Encodable)type);
                vector.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERUTF8String(otherValue)));
                DERSequence seq = new DERSequence(vector);
                return new GeneralName(0, (ASN1Encodable)seq);
            }
            case 1: {
                return new GeneralName(tag, value);
            }
            case 2: {
                return new GeneralName(tag, value);
            }
            case 4: {
                X500Name x500Name = X509Util.reverse(new X500Name(value));
                return new GeneralName(4, (ASN1Encodable)x500Name);
            }
            case 5: {
                if (value == null) {
                    throw new BadInputException("invalid ediPartyName: no value specified");
                }
                int idxSep = value.indexOf("=");
                if (idxSep == -1 || idxSep == value.length() - 1) {
                    throw new BadInputException("invalid ediPartyName " + value);
                }
                String nameAssigner = idxSep == 0 ? null : value.substring(0, idxSep);
                String partyName = value.substring(idxSep + 1);
                ASN1EncodableVector vector = new ASN1EncodableVector();
                if (nameAssigner != null) {
                    vector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)new DirectoryString(nameAssigner)));
                }
                vector.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)new DirectoryString(partyName)));
                DERSequence seq = new DERSequence(vector);
                return new GeneralName(5, (ASN1Encodable)seq);
            }
            case 6: {
                return new GeneralName(tag, value);
            }
            case 7: {
                return new GeneralName(tag, value);
            }
            case 8: {
                return new GeneralName(tag, value);
            }
        }
        throw new IllegalStateException("unsupported tag " + tag);
    }

    static {
        certFactLock = new Object();
    }
}

