/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import com.alibaba.fastjson.JSON;
import java.io.Closeable;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.PasswordResolver;
import org.xipki.password.Passwords;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SecurityFactoryImpl;
import org.xipki.security.SignerFactory;
import org.xipki.security.SignerFactoryRegisterImpl;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11CryptServiceFactoryImpl;
import org.xipki.security.pkcs11.P11ModuleFactoryRegisterImpl;
import org.xipki.security.pkcs11.P11SignerFactory;
import org.xipki.security.pkcs11.Pkcs11conf;
import org.xipki.security.pkcs11.emulator.EmulatorP11ModuleFactory;
import org.xipki.security.pkcs11.iaik.IaikP11ModuleFactory;
import org.xipki.security.pkcs11.proxy.ProxyP11ModuleFactory;
import org.xipki.security.pkcs12.P12SignerFactory;
import org.xipki.util.CollectionUtil;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.InvalidConfException;
import org.xipki.util.ValidatableConf;

public class Securities
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Securities.class);
    private P11ModuleFactoryRegisterImpl p11ModuleFactoryRegister;
    private P11CryptServiceFactoryImpl p11CryptServiceFactory;
    private SecurityFactoryImpl securityFactory;

    public SecurityFactory getSecurityFactory() {
        return this.securityFactory;
    }

    public P11CryptServiceFactory getP11CryptServiceFactory() {
        return this.p11CryptServiceFactory;
    }

    public void init() throws IOException, InvalidConfException {
        this.init(null);
    }

    public void init(SecurityConf conf) throws IOException, InvalidConfException {
        if (Security.getProvider("BC") == null) {
            LOG.info("add BouncyCastleProvider");
            Security.addProvider((Provider)new BouncyCastleProvider());
        } else {
            LOG.info("BouncyCastleProvider already added");
        }
        if (conf == null) {
            conf = SecurityConf.DEFAULT;
        }
        this.initSecurityFactory(conf);
    }

    @Override
    public void close() {
        if (this.p11ModuleFactoryRegister != null) {
            try {
                this.p11ModuleFactoryRegister.close();
            }
            catch (Throwable th) {
                LOG.error("error while closing P11ModuleFactoryRegister", th);
            }
            this.p11ModuleFactoryRegister = null;
        }
        if (this.p11CryptServiceFactory != null) {
            try {
                this.p11CryptServiceFactory.close();
            }
            catch (Throwable th) {
                LOG.error("error while closing P11CryptServiceFactory", th);
            }
            this.p11CryptServiceFactory = null;
        }
    }

    private void initSecurityFactory(SecurityConf conf) throws IOException, InvalidConfException {
        Passwords passwords = new Passwords();
        passwords.init(conf.getPassword());
        this.securityFactory = new SecurityFactoryImpl();
        this.securityFactory.setStrongRandom4SignEnabled(conf.isSignStrongrandomEnabled());
        this.securityFactory.setStrongRandom4KeyEnabled(conf.isKeyStrongrandomEnabled());
        this.securityFactory.setDefaultSignerParallelism(conf.getDefaultSignerParallelism());
        SignerFactoryRegisterImpl signerFactoryRegister = new SignerFactoryRegisterImpl();
        this.securityFactory.setSignerFactoryRegister(signerFactoryRegister);
        this.securityFactory.setPasswordResolver(passwords.getPasswordResolver());
        this.initSecurityPkcs12(signerFactoryRegister);
        if (conf.getPkcs11Conf() != null) {
            this.initSecurityPkcs11(conf.getPkcs11Conf(), signerFactoryRegister, passwords.getPasswordResolver());
        }
        if (CollectionUtil.isNonEmpty(conf.getSignerFactories())) {
            for (String className : conf.getSignerFactories()) {
                try {
                    Class<?> clazz = Class.forName(className);
                    SignerFactory factory = (SignerFactory)clazz.newInstance();
                    signerFactoryRegister.registFactory(factory);
                }
                catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    throw new InvalidConfException("error caught while initializing SignerFactory " + className + ": " + ex.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private void initSecurityPkcs12(SignerFactoryRegisterImpl signerFactoryRegister) throws IOException {
        P12SignerFactory p12SignerFactory = new P12SignerFactory();
        p12SignerFactory.setSecurityFactory(this.securityFactory);
        signerFactoryRegister.registFactory(p12SignerFactory);
    }

    private void initSecurityPkcs11(FileOrValue pkcs11Conf, SignerFactoryRegisterImpl signerFactoryRegister, PasswordResolver passwordResolver) throws InvalidConfException {
        Pkcs11conf pkcs11ConfObj;
        this.p11ModuleFactoryRegister = new P11ModuleFactoryRegisterImpl();
        this.p11ModuleFactoryRegister.registFactory(new EmulatorP11ModuleFactory());
        this.p11ModuleFactoryRegister.registFactory(new IaikP11ModuleFactory());
        this.p11ModuleFactoryRegister.registFactory(new ProxyP11ModuleFactory());
        this.p11CryptServiceFactory = new P11CryptServiceFactoryImpl();
        this.p11CryptServiceFactory.setP11ModuleFactoryRegister(this.p11ModuleFactoryRegister);
        this.p11CryptServiceFactory.setPasswordResolver(passwordResolver);
        try {
            pkcs11ConfObj = (Pkcs11conf)((Object)JSON.parseObject((String)pkcs11Conf.readContent(), Pkcs11conf.class));
        }
        catch (IOException ex) {
            throw new InvalidConfException("could not create P11Conf: " + ex.getMessage(), (Throwable)ex);
        }
        this.p11CryptServiceFactory.setPkcs11Conf(pkcs11ConfObj);
        this.p11CryptServiceFactory.init();
        P11SignerFactory p11SignerFactory = new P11SignerFactory();
        p11SignerFactory.setSecurityFactory(this.securityFactory);
        p11SignerFactory.setP11CryptServiceFactory(this.p11CryptServiceFactory);
        signerFactoryRegister.registFactory(p11SignerFactory);
    }

    public static class SecurityConf
    extends ValidatableConf {
        private boolean keyStrongrandomEnabled;
        private boolean signStrongrandomEnabled;
        private int defaultSignerParallelism = 32;
        private FileOrValue pkcs11Conf;
        private Passwords.PasswordConf password;
        public static final SecurityConf DEFAULT = new SecurityConf();
        private List<String> signerFactories;

        public boolean isKeyStrongrandomEnabled() {
            return this.keyStrongrandomEnabled;
        }

        public void setKeyStrongrandomEnabled(boolean keyStrongrandomEnabled) {
            this.keyStrongrandomEnabled = keyStrongrandomEnabled;
        }

        public boolean isSignStrongrandomEnabled() {
            return this.signStrongrandomEnabled;
        }

        public void setSignStrongrandomEnabled(boolean signStrongrandomEnabled) {
            this.signStrongrandomEnabled = signStrongrandomEnabled;
        }

        public int getDefaultSignerParallelism() {
            return this.defaultSignerParallelism;
        }

        public void setDefaultSignerParallelism(int defaultSignerParallelism) {
            this.defaultSignerParallelism = defaultSignerParallelism;
        }

        public FileOrValue getPkcs11Conf() {
            return this.pkcs11Conf;
        }

        public void setPkcs11Conf(FileOrValue pkcs11Conf) {
            this.pkcs11Conf = pkcs11Conf;
        }

        public Passwords.PasswordConf getPassword() {
            return this.password == null ? Passwords.PasswordConf.DEFAULT : this.password;
        }

        public void setPassword(Passwords.PasswordConf password) {
            this.password = password;
        }

        public List<String> getSignerFactories() {
            return this.signerFactories;
        }

        public void setSignerFactories(List<String> signerFactories) {
            this.signerFactories = signerFactories;
        }

        public void validate() throws InvalidConfException {
            SecurityConf.validate((ValidatableConf)this.password);
        }
    }

    public static class KeystoreConf
    extends ValidatableConf {
        private String type;
        private FileOrBinary keystore;
        private String password;

        public String getType() {
            return this.type;
        }

        public void setType(String value) {
            this.type = value;
        }

        public FileOrBinary getKeystore() {
            return this.keystore;
        }

        public void setKeystore(FileOrBinary value) {
            this.keystore = value;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String value) {
            this.password = value;
        }

        public void validate() throws InvalidConfException {
            KeystoreConf.notEmpty((String)this.type, (String)"type");
            KeystoreConf.validate((ValidatableConf)this.keystore);
        }
    }
}

