/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.bc;

import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcRSAContentVerifierProviderBuilder;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.SignerUtil;

public class XiRSAContentVerifierProviderBuilder
extends BcRSAContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public XiRSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmFinder) {
        super(digestAlgorithmFinder);
        this.digestAlgorithmFinder = digestAlgorithmFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        if (PKCSObjectIdentifiers.id_RSASSA_PSS.equals((Object)sigAlgId.getAlgorithm())) {
            try {
                return SignerUtil.createPSSRSASigner(sigAlgId);
            }
            catch (XiSecurityException ex) {
                throw new OperatorCreationException(ex.getMessage(), (Throwable)ex);
            }
        }
        AlgorithmIdentifier digAlg = this.digestAlgorithmFinder.find(sigAlgId);
        return new RSADigestSigner((Digest)this.digestProvider.get(digAlg));
    }
}

