/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.xipki.security.BadAsn1ObjectException;
import org.xipki.security.X509Cert;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.pkcs11.P11UnknownEntityException;
import org.xipki.security.pkcs11.proxy.ProxyMessage;
import org.xipki.security.pkcs11.proxy.ProxyP11Identity;
import org.xipki.security.pkcs11.proxy.ProxyP11Module;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.StringUtil;

public class ProxyP11Slot
extends P11Slot {
    private final ProxyP11Module module;
    private final P11SlotIdentifier slotId;
    private final ProxyMessage.SlotIdentifier asn1SlotId;

    ProxyP11Slot(ProxyP11Module module, P11SlotIdentifier slotId, boolean readOnly, P11ModuleConf.P11MechanismFilter mechanismFilter) throws P11TokenException {
        super(module.getName(), slotId, readOnly, mechanismFilter);
        this.module = module;
        this.slotId = slotId;
        this.asn1SlotId = new ProxyMessage.SlotIdentifier(slotId);
        this.refresh();
    }

    @Override
    protected P11Slot.P11SlotRefreshResult refresh0() throws P11TokenException {
        P11Slot.P11SlotRefreshResult refreshResult = new P11Slot.P11SlotRefreshResult();
        List<Long> mechs = this.getMechanismsFromServer();
        for (Long l : mechs) {
            refreshResult.addMechanism(l);
        }
        List<P11ObjectIdentifier> certIds = this.getObjectIdsFromServer((short)261);
        for (P11ObjectIdentifier certId : certIds) {
            X509Cert cert = this.getCertificate(certId);
            if (cert == null) continue;
            refreshResult.addCertificate(certId, cert);
        }
        List<P11ObjectIdentifier> list = this.getObjectIdsFromServer((short)262);
        List<P11ObjectIdentifier> keyIds = this.getObjectIdsFromServer((short)260);
        for (P11ObjectIdentifier keyId : keyIds) {
            ProxyP11Identity identity;
            byte[] id = keyId.getId();
            P11ObjectIdentifier pubkeyid = null;
            for (P11ObjectIdentifier m : list) {
                if (!m.matchesId(id)) continue;
                pubkeyid = m;
                break;
            }
            PublicKey pubKey = null;
            X509Cert cert = refreshResult.getCertForId(id);
            pubKey = cert != null ? cert.getCert().getPublicKey() : this.getPublicKey(keyId);
            P11IdentityId entityId = new P11IdentityId(this.slotId, keyId, pubkeyid == null ? null : pubkeyid.getLabel(), refreshResult.getCertLabelForId(id));
            if (pubKey == null) {
                identity = new ProxyP11Identity(this, entityId);
            } else {
                X509Certificate[] x509CertificateArray;
                if (cert == null) {
                    x509CertificateArray = null;
                } else {
                    X509Certificate[] x509CertificateArray2 = new X509Certificate[1];
                    x509CertificateArray = x509CertificateArray2;
                    x509CertificateArray2[0] = cert.getCert();
                }
                X509Certificate[] certs = x509CertificateArray;
                identity = new ProxyP11Identity(this, entityId, pubKey, certs);
            }
            refreshResult.addIdentity(identity);
        }
        return refreshResult;
    }

    @Override
    public void close() {
    }

    private PublicKey getPublicKey(P11ObjectIdentifier objectId) throws P11UnknownEntityException, P11TokenException {
        ProxyMessage.SlotIdAndObjectId req = new ProxyMessage.SlotIdAndObjectId(this.asn1SlotId, new ProxyMessage.ObjectIdentifier(objectId));
        byte[] resp = this.module.send((short)257, req);
        if (resp == null) {
            return null;
        }
        SubjectPublicKeyInfo pkInfo = SubjectPublicKeyInfo.getInstance((Object)resp);
        try {
            return KeyUtil.generatePublicKey(pkInfo);
        }
        catch (InvalidKeySpecException ex) {
            throw new P11TokenException("could not generate Public Key from SubjectPublicKeyInfo:" + ex.getMessage(), ex);
        }
    }

    private X509Cert getCertificate(P11ObjectIdentifier objectId) throws P11TokenException {
        ProxyMessage.SlotIdAndObjectId req = new ProxyMessage.SlotIdAndObjectId(this.asn1SlotId, new ProxyMessage.ObjectIdentifier(objectId));
        byte[] resp = this.module.send((short)258, req);
        if (resp == null) {
            return null;
        }
        try {
            return new X509Cert(X509Util.parseCert(resp), resp);
        }
        catch (CertificateException ex) {
            throw new P11TokenException("could not parse certificate:" + ex.getMessage(), ex);
        }
    }

    @Override
    public int removeObjects(byte[] id, String label) throws P11TokenException {
        if ((id == null || id.length == 0) && StringUtil.isBlank((String)label)) {
            throw new IllegalArgumentException("at least one of id and label must not be null");
        }
        ProxyMessage.RemoveObjectsParams params = new ProxyMessage.RemoveObjectsParams(this.slotId, id, label);
        byte[] resp = this.module.send((short)324, params);
        try {
            return ASN1Integer.getInstance((Object)resp).getValue().intValue();
        }
        catch (IllegalArgumentException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
    }

    @Override
    protected void removeIdentity0(P11IdentityId identityId) throws P11TokenException {
        ProxyMessage.SlotIdAndObjectId req = new ProxyMessage.SlotIdAndObjectId(this.asn1SlotId, new ProxyMessage.ObjectIdentifier(identityId.getKeyId()));
        this.module.send((short)321, req);
    }

    @Override
    protected P11ObjectIdentifier addCert0(X509Certificate cert, P11Slot.P11NewObjectControl control) throws P11TokenException, CertificateException {
        ProxyMessage.ObjectIdentifier objId;
        ProxyMessage.AddCertParams asn1 = new ProxyMessage.AddCertParams(this.slotId, control, cert);
        byte[] resp = this.module.send((short)320, asn1);
        if (resp == null) {
            return null;
        }
        try {
            objId = ProxyMessage.ObjectIdentifier.getInstance(resp);
        }
        catch (BadAsn1ObjectException ex) {
            throw new P11TokenException("invalid ASN1 object Asn1P11ObjectIdentifier: " + ex.getMessage(), ex);
        }
        return objId.getValue();
    }

    @Override
    protected void removeCerts0(P11ObjectIdentifier objectId) throws P11TokenException {
        ProxyMessage.SlotIdAndObjectId req = new ProxyMessage.SlotIdAndObjectId(this.asn1SlotId, new ProxyMessage.ObjectIdentifier(objectId));
        this.module.send((short)322, req);
    }

    @Override
    protected P11Identity generateSecretKey0(long keyType, int keysize, P11Slot.P11NewKeyControl control) throws P11TokenException {
        ProxyMessage.GenSecretKeyParams asn1 = new ProxyMessage.GenSecretKeyParams(this.slotId, control, keyType, keysize);
        byte[] resp = this.module.send((short)309, asn1);
        return this.parseGenerateSecretKeyResult(resp);
    }

    @Override
    protected P11Identity importSecretKey0(long keyType, byte[] keyValue, P11Slot.P11NewKeyControl control) throws P11TokenException {
        ProxyMessage.ImportSecretKeyParams asn1 = new ProxyMessage.ImportSecretKeyParams(this.slotId, control, keyType, keyValue);
        byte[] resp = this.module.send((short)310, asn1);
        return this.parseGenerateSecretKeyResult(resp);
    }

    @Override
    protected P11Identity generateRSAKeypair0(int keysize, BigInteger publicExponent, P11Slot.P11NewKeyControl control) throws P11TokenException {
        ProxyMessage.GenRSAKeypairParams asn1 = new ProxyMessage.GenRSAKeypairParams(this.slotId, control, keysize, publicExponent);
        byte[] resp = this.module.send((short)304, asn1);
        return this.parseGenerateKeypairResult(resp);
    }

    @Override
    protected P11Identity generateDSAKeypair0(BigInteger p, BigInteger q, BigInteger g, P11Slot.P11NewKeyControl control) throws P11TokenException {
        ProxyMessage.GenDSAKeypairParams asn1 = new ProxyMessage.GenDSAKeypairParams(this.slotId, control, p, q, g);
        byte[] resp = this.module.send((short)305, asn1);
        return this.parseGenerateKeypairResult(resp);
    }

    @Override
    protected P11Identity generateECKeypair0(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) throws P11TokenException {
        ProxyMessage.GenECKeypairParams asn1 = new ProxyMessage.GenECKeypairParams(this.slotId, control, curveId);
        byte[] resp = this.module.send((short)307, asn1);
        return this.parseGenerateKeypairResult(resp);
    }

    @Override
    protected P11Identity generateECEdwardsKeypair0(String curveName, P11Slot.P11NewKeyControl control) throws P11TokenException {
        ProxyMessage.GenECEdwardsOrMontgomeryKeypairParams asn1 = new ProxyMessage.GenECEdwardsOrMontgomeryKeypairParams(this.slotId, control, curveName);
        byte[] resp = this.module.send((short)326, asn1);
        return this.parseGenerateKeypairResult(resp);
    }

    @Override
    protected P11Identity generateECMontgomeryKeypair0(String curveName, P11Slot.P11NewKeyControl control) throws P11TokenException {
        ProxyMessage.GenECEdwardsOrMontgomeryKeypairParams asn1 = new ProxyMessage.GenECEdwardsOrMontgomeryKeypairParams(this.slotId, control, curveName);
        byte[] resp = this.module.send((short)307, asn1);
        return this.parseGenerateKeypairResult(resp);
    }

    @Override
    protected P11Identity generateSM2Keypair0(P11Slot.P11NewKeyControl control) throws P11TokenException {
        ProxyMessage.GenSM2KeypairParams asn1 = new ProxyMessage.GenSM2KeypairParams(this.slotId, control);
        byte[] resp = this.module.send((short)325, asn1);
        return this.parseGenerateKeypairResult(resp);
    }

    private P11Identity parseGenerateKeypairResult(byte[] resp) throws P11TokenException {
        return this.parseGenerateKeyResult(resp, true);
    }

    private P11Identity parseGenerateSecretKeyResult(byte[] resp) throws P11TokenException {
        return this.parseGenerateKeyResult(resp, false);
    }

    private P11Identity parseGenerateKeyResult(byte[] resp, boolean needsPublicKey) throws P11TokenException {
        ProxyMessage.IdentityId ei;
        if (resp == null) {
            throw new P11TokenException("server returned no result");
        }
        try {
            ei = ProxyMessage.IdentityId.getInstance(resp);
        }
        catch (BadAsn1ObjectException ex) {
            throw new P11TokenException("invalid ASN1 object Asn1P11EntityIdentifier: " + ex.getMessage(), ex);
        }
        if (!this.slotId.equals(ei.getValue().getSlotId())) {
            throw new P11TokenException("returned identity has different slodId");
        }
        P11IdentityId identityId = ei.getValue();
        if (needsPublicKey) {
            PublicKey publicKey = this.getPublicKey(identityId.getPublicKeyId());
            return new ProxyP11Identity(this, identityId, publicKey, null);
        }
        return new ProxyP11Identity(this, identityId);
    }

    @Override
    protected void updateCertificate0(P11ObjectIdentifier objectId, X509Certificate newCert) throws P11TokenException, CertificateException {
        ProxyMessage.ObjectIdAndCert asn1 = new ProxyMessage.ObjectIdAndCert(this.asn1SlotId, new ProxyMessage.ObjectIdentifier(objectId), newCert);
        this.module.send((short)323, asn1);
    }

    private List<Long> getMechanismsFromServer() throws P11TokenException {
        ProxyMessage.SlotIdentifier asn1SlotId = new ProxyMessage.SlotIdentifier(this.slotId);
        byte[] resp = this.module.send((short)2, asn1SlotId);
        ASN1Sequence seq = this.requireSequence(resp);
        int n = seq.size();
        ArrayList<Long> mechs = new ArrayList<Long>(n);
        for (int i = 0; i < n; ++i) {
            long mech = ASN1Integer.getInstance((Object)seq.getObjectAt(i)).getValue().longValue();
            mechs.add(mech);
        }
        return mechs;
    }

    private List<P11ObjectIdentifier> getObjectIdsFromServer(short action) throws P11TokenException {
        List<ProxyMessage.ObjectIdentifier> asn1ObjectIds;
        ProxyMessage.SlotIdentifier asn1SlotId = new ProxyMessage.SlotIdentifier(this.slotId);
        byte[] resp = this.module.send(action, asn1SlotId);
        try {
            asn1ObjectIds = ProxyMessage.ObjectIdentifiers.getInstance(resp).getObjectIds();
        }
        catch (BadAsn1ObjectException ex) {
            throw new P11TokenException("bad ASN1 object: " + ex.getMessage(), ex);
        }
        ArrayList<P11ObjectIdentifier> objectIds = new ArrayList<P11ObjectIdentifier>(asn1ObjectIds.size());
        for (ProxyMessage.ObjectIdentifier asn1Id : asn1ObjectIds) {
            objectIds.add(asn1Id.getValue());
        }
        return objectIds;
    }

    private ASN1Sequence requireSequence(byte[] response) throws P11TokenException {
        try {
            return ASN1Sequence.getInstance((Object)response);
        }
        catch (IllegalArgumentException ex) {
            throw new P11TokenException("response is not ASN1Sequence", ex);
        }
    }

    ProxyP11Module getModule() {
        return this.module;
    }

    ProxyMessage.SlotIdentifier getAsn1SlotId() {
        return this.asn1SlotId;
    }
}

