/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DfltConcurrentContentSigner;
import org.xipki.security.XiContentSigner;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11ContentSigner;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;

public class P11MacContentSignerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(P11MacContentSignerBuilder.class);
    private final P11CryptService cryptService;
    private final P11IdentityId identityId;

    public P11MacContentSignerBuilder(P11CryptService cryptService, P11IdentityId identityId) {
        this.cryptService = (P11CryptService)Args.notNull((Object)cryptService, (String)"cryptService");
        this.identityId = (P11IdentityId)Args.notNull((Object)identityId, (String)"identityId");
    }

    public ConcurrentContentSigner createSigner(AlgorithmIdentifier signatureAlgId, int parallelism) throws XiSecurityException, P11TokenException {
        DfltConcurrentContentSigner concurrentSigner;
        Args.positive((int)parallelism, (String)"parallelism");
        ArrayList<XiContentSigner> signers = new ArrayList<XiContentSigner>(parallelism);
        for (int i = 0; i < parallelism; ++i) {
            P11ContentSigner.Mac signer = new P11ContentSigner.Mac(this.cryptService, this.identityId, signatureAlgId);
            signers.add(signer);
        }
        boolean mac = true;
        try {
            concurrentSigner = new DfltConcurrentContentSigner(true, signers, null);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XiSecurityException(ex.getMessage(), ex);
        }
        try {
            byte[] sha1HashOfKey = this.cryptService.getIdentity(this.identityId).digestSecretKey(544L);
            concurrentSigner.setSha1DigestOfMacKey(sha1HashOfKey);
        }
        catch (XiSecurityException | P11TokenException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("could not compute the digest of secret key " + this.identityId));
        }
        return concurrentSigner;
    }
}

