/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.util;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.xipki.util.Args;
import org.xipki.util.StringUtil;

public class CmpFailureUtil {
    private static final Map<Integer, String> STATUS_TEXT_MAP = new HashMap<Integer, String>();
    private static final String[] FAILUREINFO_TEXTS = new String[]{"incorrectData", "wrongAuthority", "badDataFormat", "badCertId", "badTime", "badRequest", "badMessageCheck", "badAlg", "unacceptedPolicy", "timeNotAvailable", "badRecipientNonce", "wrongIntegrity", "certConfirmed", "certRevoked", "badPOP", "missingTimeStamp", "notAuthorized", "unsupportedVersion", "transactionIdInUse", "signerNotTrusted", "badCertTemplate", "badSenderNonce", "addInfoNotAvailable", "unacceptedExtension", "-", "-", "-", "-", "-", "duplicateCertReq", "systemFailure", "systemUnavail"};

    private CmpFailureUtil() {
    }

    public static String formatPkiStatusInfo(PKIStatusInfo pkiStatusInfo) {
        int status = ((PKIStatusInfo)Args.notNull((Object)pkiStatusInfo, (String)"pkiStatusInfo")).getStatus().intValue();
        int failureInfo = pkiStatusInfo.getFailInfo().intValue();
        PKIFreeText text = pkiStatusInfo.getStatusString();
        String statusMessage = text == null ? null : text.getStringAt(0).getString();
        return CmpFailureUtil.formatPkiStatusInfo(status, failureInfo, statusMessage);
    }

    public static String formatPkiStatusInfo(int status, int failureInfo, String statusMessage) {
        return StringUtil.concatObjectsCap((int)200, (Object)"PKIStatusInfo {status = ", (Object[])new Object[]{status, " (", STATUS_TEXT_MAP.get(status), "), ", "failureInfo = ", failureInfo, " (", CmpFailureUtil.getFailureInfoText(failureInfo), "), ", "statusMessage = ", statusMessage, "}"});
    }

    public static String getFailureInfoText(int failureInfo) {
        BigInteger bi = BigInteger.valueOf(failureInfo);
        int n = Math.min(bi.bitLength(), FAILUREINFO_TEXTS.length);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (!bi.testBit(i)) continue;
            sb.append(", ").append(FAILUREINFO_TEXTS[i]);
        }
        return sb.length() < 3 ? "" : sb.substring(2);
    }

    static {
        STATUS_TEXT_MAP.put(-2, "xipki_noAnswer");
        STATUS_TEXT_MAP.put(-1, "xipki_responseError");
        STATUS_TEXT_MAP.put(0, "accepted");
        STATUS_TEXT_MAP.put(1, "grantedWithMods");
        STATUS_TEXT_MAP.put(2, "rejection");
        STATUS_TEXT_MAP.put(3, "waiting");
        STATUS_TEXT_MAP.put(4, "revocationWarning");
        STATUS_TEXT_MAP.put(5, "revocationNotification");
        STATUS_TEXT_MAP.put(6, "keyUpdateWarning");
    }
}

