/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.PasswordResolver;
import org.xipki.security.AlgorithmCode;
import org.xipki.security.ConcurrentBagEntrySigner;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.NoIdleSignerException;
import org.xipki.security.X509Cert;
import org.xipki.security.XiContentSigner;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.concurrent.ConcurrentBag;

public class DfltConcurrentContentSigner
implements ConcurrentContentSigner {
    private static final Logger LOG = LoggerFactory.getLogger(DfltConcurrentContentSigner.class);
    private static final AtomicInteger NAME_INDEX = new AtomicInteger(1);
    private static int defaultSignServiceTimeout = 10000;
    private final ConcurrentBag<ConcurrentBagEntrySigner> signers = new ConcurrentBag();
    private final String name;
    private final String algorithmName;
    private final boolean mac;
    private byte[] sha1OfMacKey;
    private final Key signingKey;
    private final AlgorithmCode algorithmCode;
    private PublicKey publicKey;
    private X509Cert[] certificateChain;

    public DfltConcurrentContentSigner(boolean mac, List<XiContentSigner> signers) throws NoSuchAlgorithmException {
        this(mac, signers, null);
    }

    public DfltConcurrentContentSigner(boolean mac, List<XiContentSigner> signers, Key signingKey) throws NoSuchAlgorithmException {
        Args.notEmpty(signers, (String)"signers");
        this.mac = mac;
        AlgorithmIdentifier algorithmIdentifier = signers.get(0).getAlgorithmIdentifier();
        this.algorithmName = AlgorithmUtil.getSigOrMacAlgoName(algorithmIdentifier);
        this.algorithmCode = AlgorithmUtil.getSigOrMacAlgoCode(algorithmIdentifier);
        for (XiContentSigner signer : signers) {
            this.signers.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntrySigner(signer));
        }
        this.signingKey = signingKey;
        this.name = "defaultSigner-" + NAME_INDEX.getAndIncrement();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isMac() {
        return this.mac;
    }

    public void setSha1DigestOfMacKey(byte[] digest) {
        if (digest == null) {
            this.sha1OfMacKey = null;
        } else if (digest.length == 20) {
            this.sha1OfMacKey = Arrays.copyOf(digest, 20);
        } else {
            throw new IllegalArgumentException("invalid sha1Digest.length (" + digest.length + " != 20)");
        }
    }

    @Override
    public byte[] getSha1OfMacKey() {
        return this.sha1OfMacKey == null ? null : Arrays.copyOf(this.sha1OfMacKey, 20);
    }

    @Override
    public AlgorithmCode getAlgorithmCode() {
        return this.algorithmCode;
    }

    @Override
    public ConcurrentBagEntrySigner borrowSigner() throws NoIdleSignerException {
        return this.borrowSigner(defaultSignServiceTimeout);
    }

    @Override
    public ConcurrentBagEntrySigner borrowSigner(int soTimeout) throws NoIdleSignerException {
        ConcurrentBagEntrySigner signer = null;
        try {
            signer = (ConcurrentBagEntrySigner)this.signers.borrow((long)soTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (signer == null) {
            throw new NoIdleSignerException("no idle signer available");
        }
        return signer;
    }

    @Override
    public void requiteSigner(ConcurrentBagEntrySigner signer) {
        this.signers.requite((ConcurrentBag.IConcurrentBagEntry)signer);
    }

    @Override
    public void initialize(String conf, PasswordResolver passwordResolver) throws XiSecurityException {
    }

    @Override
    public Key getSigningKey() {
        return this.signingKey;
    }

    @Override
    public void setCertificateChain(X509Cert[] certificateChain) {
        if (CollectionUtil.isEmpty((Object[])certificateChain)) {
            this.certificateChain = null;
            return;
        }
        this.certificateChain = certificateChain;
        this.setPublicKey(certificateChain[0].getPublicKey());
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public X509Cert getCertificate() {
        return CollectionUtil.isEmpty((Object[])this.certificateChain) ? null : this.certificateChain[0];
    }

    @Override
    public X509Cert[] getCertificateChain() {
        return this.certificateChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isHealthy() {
        ConcurrentBagEntrySigner signer = null;
        try {
            signer = this.borrowSigner();
            OutputStream stream = ((XiContentSigner)signer.value()).getOutputStream();
            stream.write(new byte[]{1, 2, 3, 4});
            byte[] signature = ((XiContentSigner)signer.value()).getSignature();
            boolean bl = signature != null && signature.length > 0;
            return bl;
        }
        catch (Exception ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (signer != null) {
                this.requiteSigner(signer);
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] sign(byte[] data) throws NoIdleSignerException, SignatureException {
        ConcurrentBagEntrySigner signer = this.borrowSigner();
        try {
            OutputStream signatureStream = ((XiContentSigner)signer.value()).getOutputStream();
            try {
                signatureStream.write(data);
            }
            catch (IOException ex) {
                throw new SignatureException("could not write data to SignatureStream: " + ex.getMessage(), ex);
            }
            byte[] byArray = ((XiContentSigner)signer.value()).getSignature();
            return byArray;
        }
        finally {
            this.requiteSigner(signer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[][] sign(byte[][] data) throws NoIdleSignerException, SignatureException {
        byte[][] signatures = new byte[data.length][];
        ConcurrentBagEntrySigner signer = this.borrowSigner();
        try {
            XiContentSigner xiSigner = (XiContentSigner)signer.value();
            for (int i = 0; i < data.length; ++i) {
                OutputStream signatureStream = xiSigner.getOutputStream();
                try {
                    signatureStream.write(data[i]);
                }
                catch (IOException ex) {
                    throw new SignatureException("could not write data to SignatureStream: " + ex.getMessage(), ex);
                }
                signatures[i] = xiSigner.getSignature();
            }
        }
        finally {
            this.requiteSigner(signer);
        }
        return signatures;
    }

    static {
        String propKey = "org.xipki.security.signservice.timeout";
        String str = System.getProperty("org.xipki.security.signservice.timeout");
        if (str != null) {
            int vi = Integer.parseInt(str);
            if (vi < 0 || vi > 60000) {
                LOG.error("invalid {}: {}", (Object)"org.xipki.security.signservice.timeout", (Object)vi);
            } else {
                LOG.info("use {}: {}", (Object)"org.xipki.security.signservice.timeout", (Object)vi);
                defaultSignServiceTimeout = vi;
            }
        }
    }
}

