/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs12;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Enumeration;
import java.util.HashSet;
import org.bouncycastle.jcajce.interfaces.EdDSAKey;
import org.bouncycastle.jcajce.interfaces.XDHKey;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;

public class KeypairWithCert {
    private final PrivateKey key;
    private final PublicKey publicKey;
    private final X509Cert[] certificateChain;

    public KeypairWithCert(PrivateKey key, X509Cert[] certificateChain) {
        this.key = (PrivateKey)Args.notNull((Object)key, (String)"key");
        this.certificateChain = (X509Cert[])Args.notNull((Object)certificateChain, (String)"certificateChain");
        Args.min((int)certificateChain.length, (String)"certificateChain.length", (int)1);
        this.publicKey = certificateChain[0].getPublicKey();
    }

    public static KeypairWithCert fromKeystore(String keystoreType, InputStream keystoreStream, char[] keystorePassword, String keyname, char[] keyPassword, X509Cert cert) throws XiSecurityException {
        X509Cert[] x509CertArray;
        if (cert == null) {
            x509CertArray = null;
        } else {
            X509Cert[] x509CertArray2 = new X509Cert[1];
            x509CertArray = x509CertArray2;
            x509CertArray2[0] = cert;
        }
        return KeypairWithCert.fromKeystore(keystoreType, keystoreStream, keystorePassword, keyname, keyPassword, x509CertArray);
    }

    public static KeypairWithCert fromKeystore(String keystoreType, InputStream keystoreStream, char[] keystorePassword, String keyname, char[] keyPassword, X509Cert[] certchain) throws XiSecurityException {
        KeyStore keystore;
        if (!"PKCS12".equalsIgnoreCase(keystoreType) && !"JCEKS".equalsIgnoreCase(keystoreType)) {
            throw new IllegalArgumentException("unsupported keystore type: " + keystoreType);
        }
        Args.notNull((Object)keystoreStream, (String)"keystoreStream");
        Args.notNull((Object)keystorePassword, (String)"keystorePassword");
        Args.notNull((Object)keyPassword, (String)"keyPassword");
        try {
            keystore = KeyUtil.getKeyStore(keystoreType);
        }
        catch (KeyStoreException ex) {
            throw new XiSecurityException(ex.getMessage(), ex);
        }
        try {
            keystore.load(keystoreStream, keystorePassword);
            KeypairWithCert ex = KeypairWithCert.fromKeystore(keystore, keyname, keyPassword, certchain);
            return ex;
        }
        catch (IOException | ClassCastException | NoSuchAlgorithmException | CertificateException ex) {
            throw new XiSecurityException(ex.getMessage(), ex);
        }
        finally {
            try {
                keystoreStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static KeypairWithCert fromKeystore(KeyStore keystore, String keyname, char[] keyPassword, X509Cert[] certchain) throws XiSecurityException {
        Args.notNull((Object)keyPassword, (String)"keyPassword");
        try {
            Certificate[] certsInKeystore;
            int i;
            X509Cert cert;
            PrivateKey key;
            String tmpKeyname = keyname;
            if (tmpKeyname == null) {
                Enumeration<String> aliases = keystore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (!keystore.isKeyEntry(alias)) continue;
                    tmpKeyname = alias;
                    break;
                }
            } else if (!keystore.isKeyEntry(tmpKeyname)) {
                throw new XiSecurityException("unknown key named " + tmpKeyname);
            }
            if (!((key = (PrivateKey)keystore.getKey(tmpKeyname, keyPassword)) instanceof RSAPrivateKey || key instanceof DSAPrivateKey || key instanceof ECPrivateKey || key instanceof EdDSAKey || key instanceof XDHKey)) {
                throw new XiSecurityException("unsupported key " + key.getClass().getName());
            }
            HashSet<X509Cert> caCerts = new HashSet<X509Cert>();
            if (certchain != null && certchain.length > 0) {
                cert = certchain[0];
                int n = certchain.length;
                if (n > 1) {
                    for (i = 1; i < n; ++i) {
                        caCerts.add(certchain[i]);
                    }
                }
            } else {
                cert = new X509Cert((X509Certificate)keystore.getCertificate(tmpKeyname));
            }
            if ((certsInKeystore = keystore.getCertificateChain(tmpKeyname)).length > 1) {
                for (i = 1; i < certsInKeystore.length; ++i) {
                    caCerts.add(new X509Cert((X509Certificate)certsInKeystore[i]));
                }
            }
            X509Cert[] certificateChain = X509Util.buildCertPath(cert, caCerts);
            return new KeypairWithCert(key, certificateChain);
        }
        catch (ClassCastException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertPathBuilderException ex) {
            throw new XiSecurityException(ex.getMessage(), ex);
        }
    }

    public PrivateKey getKey() {
        return this.key;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public X509Cert[] getCertificateChain() {
        return this.certificateChain;
    }
}

