/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.util.Arrays;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;

public class DHSigStaticKeyCertPair {
    private final PrivateKey privateKey;
    private final X500Name issuer;
    private final X500Name subject;
    private final BigInteger serialNumber;
    private final byte[] encodedIssuer;
    private final byte[] encodedSubject;

    public DHSigStaticKeyCertPair(PrivateKey privateKey, X509Cert certificate) {
        this.privateKey = (PrivateKey)Args.notNull((Object)privateKey, (String)"privateKey");
        Args.notNull((Object)certificate, (String)"certificate");
        this.serialNumber = certificate.getSerialNumber();
        try {
            this.encodedIssuer = certificate.getIssuer().getEncoded();
            this.encodedSubject = certificate.getSubject().getEncoded();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("error encoding certificate", ex);
        }
        this.issuer = X500Name.getInstance((Object)this.encodedIssuer);
        this.subject = X500Name.getInstance((Object)this.encodedSubject);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public byte[] getEncodedIssuer() {
        return Arrays.copyOf(this.encodedIssuer, this.encodedIssuer.length);
    }

    public byte[] getEncodedSubject() {
        return Arrays.copyOf(this.encodedSubject, this.encodedSubject.length);
    }
}

