/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.xipki.security.EdECConstants;
import org.xipki.util.Args;
import org.xipki.util.StringUtil;

public class ObjectIdentifiers {
    private static final ASN1ObjectIdentifier id_pkix = new ASN1ObjectIdentifier("1.3.6.1.5.5.7");
    private static final ASN1ObjectIdentifier id_pen = new ASN1ObjectIdentifier("1.3.6.1.4.1");
    private static final ASN1ObjectIdentifier id_xipki = id_pen.branch("45522");
    private static final ASN1ObjectIdentifier id_microsoft = id_pen.branch("311");

    private ObjectIdentifiers() {
    }

    public static String oidToDisplayName(ASN1ObjectIdentifier type) {
        Args.notNull((Object)type, (String)"type");
        String name = ObjectIdentifiers.getName(type);
        return name == null ? type.getId() : type.getId() + " (" + name + ")";
    }

    public static String getName(ASN1ObjectIdentifier type) {
        Args.notNull((Object)type, (String)"type");
        String name = (String)OidNameMap.oidNameMap.get(type);
        if (StringUtil.isBlank((String)name)) {
            try {
                name = RFC4519Style.INSTANCE.oidToDisplayName(type);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return name;
    }

    public static ASN1ObjectIdentifier nameToOid(String name) {
        Args.notNull((Object)name, (String)"name");
        for (ASN1ObjectIdentifier oid : OidNameMap.oidNameMap.keySet()) {
            if (!((String)OidNameMap.oidNameMap.get(oid)).equalsIgnoreCase(name)) continue;
            return oid;
        }
        try {
            return RFC4519Style.INSTANCE.attrNameToOID(name);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    static /* synthetic */ ASN1ObjectIdentifier access$000() {
        return id_xipki;
    }

    static /* synthetic */ ASN1ObjectIdentifier access$300() {
        return id_pkix;
    }

    private static class OidNameMap {
        private static final Map<ASN1ObjectIdentifier, String> oidNameMap = new HashMap<ASN1ObjectIdentifier, String>();

        private OidNameMap() {
        }

        static {
            oidNameMap.put(DN.countryOfCitizenship, "countryOfCitizenship");
            oidNameMap.put(DN.countryOfResidence, "countryOfResidence");
            oidNameMap.put(DN.dateOfBirth, "dateOfBirth");
            oidNameMap.put(DN.dmdName, "dmdName");
            oidNameMap.put(DN.emailAddress, "emailAddress");
            oidNameMap.put(DN.gender, "gender");
            oidNameMap.put(DN.nameAtBirth, "nameAtBirth");
            oidNameMap.put(DN.organizationIdentifier, "organizationIdentifier");
            oidNameMap.put(DN.placeOfBirth, "placeOfBirth");
            oidNameMap.put(DN.pseudonym, "pseudonym");
            oidNameMap.put(DN.unstructuredName, "unstructuredName");
            oidNameMap.put(DN.unstructuredAddress, "unstructuredAddress");
            oidNameMap.put(DN.NIF, "NIF, Tax ID number, for individuals (Spain)");
            oidNameMap.put(DN.CIF, "CIF, Tax ID code, for companies (Spain)");
            oidNameMap.put(DN.jurisdictionOfIncorporationCountryName, "jurisdictionOfIncorporationCountryName");
            oidNameMap.put(DN.jurisdictionOfIncorporationStateOrProvinceName, "jurisdictionOfIncorporationStateOrProvinceName");
            oidNameMap.put(DN.jurisdictionOfIncorporationLocalityName, "jurisdictionOfIncorporationLocalityName");
            oidNameMap.put(Extn.id_pkix_ocsp_extendedRevoke, "pkix-ocsp-extendedRevoke");
            oidNameMap.put(Extn.id_pkix_ocsp_prefSigAlgs, "pkix-ocsp-prefSigAlgs");
            oidNameMap.put(Extn.id_extension_pkix_ocsp_nocheck, "pkix-ocsp-nocheck");
            oidNameMap.put(Extn.id_extension_restriction, "restriction");
            oidNameMap.put(Extn.id_extension_additionalInformation, "additionalInformation");
            oidNameMap.put(Extn.id_extension_admission, "admission");
            oidNameMap.put(Extn.id_extension_validityModel, "validityModel");
            oidNameMap.put(Extn.id_ad_caRepository, "ad-caRepository");
            oidNameMap.put(Extn.id_ad_timeStamping, "ad-timeStamping");
            oidNameMap.put(Extn.id_qcs_pkixQCSyntax_v1, "qcs-pkixQCSyntax-v2");
            oidNameMap.put(Extn.id_qcs_pkixQCSyntax_v2, "qcs-pkixQCSyntax-v2");
            oidNameMap.put(Extn.id_etsi_qcs_QcCompliance, "etsi-qcs-QcCompliance");
            oidNameMap.put(Extn.id_etsi_qcs_QcLimitValue, "etsi-qcs-QcLimitValue");
            oidNameMap.put(Extn.id_etsi_qcs_QcRetentionPeriod, "etsi-qcs-QcRetentionPeriod");
            oidNameMap.put(Extn.id_etsi_qcs_QcSSCD, "etsi-qcs-QcSSCD");
            oidNameMap.put(Extn.id_pe_tlsfeature, "tlsFeature");
            oidNameMap.put(Extn.id_smimeCapabilities, "SMIMECapatibilities");
            oidNameMap.put(Extn.id_GMT_0015_ICRegistrationNumber, "GMT 0015 ICRegistrationNumber");
            oidNameMap.put(Extn.id_GMT_0015_IdentityCode, "GMT 0015 IdentityCode");
            oidNameMap.put(Extn.id_GMT_0015_InsuranceNumber, "GMT 0015 InsuranceNumber");
            oidNameMap.put(Extn.id_GMT_0015_OrganizationCode, "GMT 0015 OrganizationCode");
            oidNameMap.put(Extn.id_GMT_0015_TaxationNumber, "GMT 0015 TaxationNumber");
            oidNameMap.put(Extn.id_precertificate, "CT Precertificate Indication");
            oidNameMap.put(Extn.id_SCTs, "CT Precertificate SCTs");
            oidNameMap.put(Extension.auditIdentity, "auditIdentity");
            oidNameMap.put(Extension.authorityInfoAccess, "authorityInfoAccess");
            oidNameMap.put(Extension.authorityKeyIdentifier, "authorityKeyIdentifier");
            oidNameMap.put(Extension.basicConstraints, "basicConstraints");
            oidNameMap.put(Extension.biometricInfo, "biometricInfo");
            oidNameMap.put(Extension.certificateIssuer, "certificateIssuer");
            oidNameMap.put(Extension.certificatePolicies, "certificatePolicies");
            oidNameMap.put(Extension.cRLDistributionPoints, "cRLDistributionPoints");
            oidNameMap.put(Extension.cRLNumber, "cRLNumber");
            oidNameMap.put(Extension.deltaCRLIndicator, "deltaCRLIndicator");
            oidNameMap.put(Extension.extendedKeyUsage, "extendedKeyUsage");
            oidNameMap.put(Extension.freshestCRL, "freshestCRL");
            oidNameMap.put(Extension.inhibitAnyPolicy, "inhibitAnyPolicy");
            oidNameMap.put(Extension.instructionCode, "instructionCode");
            oidNameMap.put(Extension.invalidityDate, "invalidityDate");
            oidNameMap.put(Extension.issuerAlternativeName, "issuerAlternativeName");
            oidNameMap.put(Extension.issuingDistributionPoint, "issuingDistributionPoint");
            oidNameMap.put(Extension.keyUsage, "keyUsage");
            oidNameMap.put(Extension.logoType, "logoType");
            oidNameMap.put(Extension.nameConstraints, "nameConstraints");
            oidNameMap.put(Extension.noRevAvail, "noRevAvail");
            oidNameMap.put(Extension.policyConstraints, "policyConstraints");
            oidNameMap.put(Extension.policyMappings, "policyMappings");
            oidNameMap.put(Extension.privateKeyUsagePeriod, "privateKeyUsagePeriod");
            oidNameMap.put(Extension.qCStatements, "qCStatements");
            oidNameMap.put(Extension.reasonCode, "reasonCode");
            oidNameMap.put(Extension.subjectAlternativeName, "subjectAlternativeName");
            oidNameMap.put(Extension.subjectDirectoryAttributes, "subjectDirectoryAttributes");
            oidNameMap.put(Extension.subjectInfoAccess, "subjectInfoAccess");
            oidNameMap.put(Extension.subjectKeyIdentifier, "subjectKeyIdentifier");
            oidNameMap.put(Extension.targetInformation, "targetInformation");
            oidNameMap.put(Secg.id_aes128_cbc_in_ecies, "aes128-cbc-in-ecies");
            oidNameMap.put(Secg.id_ecies_specifiedParameters, "ecies-specifiedParameters");
            oidNameMap.put(Secg.id_hmac_full_ecies, "hmac-full-ecies");
            oidNameMap.put(Misc.id_iso18033_kdf2, "kdf2");
            oidNameMap.put(XKU.id_kp_anyExtendedKeyUsage, "Any ExtendedKeyUsage");
            oidNameMap.put(XKU.id_kp_clientAuth, "TLS WWW client authentication");
            oidNameMap.put(XKU.id_kp_codeSigning, "Code signing");
            oidNameMap.put(XKU.id_kp_csn369791TlsClient, "CSN 369791 TLS client");
            oidNameMap.put(XKU.id_kp_csn369791TlsServer, "CSN 369791 TLS server");
            oidNameMap.put(XKU.id_kp_eapOverLan, "EAP over LAN (EAPOL)");
            oidNameMap.put(XKU.id_kp_eapOverPpp, "EAP over PPP");
            oidNameMap.put(XKU.id_kp_emailProtection, "Email protection");
            oidNameMap.put(XKU.id_kp_etsiTslSigning, "ETSI TSL Signing");
            oidNameMap.put(XKU.id_kp_icaoMasterListSigning, "ICAO Master List Signing");
            oidNameMap.put(XKU.id_kp_ikeForIpsec, "Internet Key Exchange for IPsec");
            oidNameMap.put(XKU.id_kp_intelAmtManagement, "Intel AMT management");
            oidNameMap.put(XKU.id_kp_ipsecEndSystem, "IP security end system");
            oidNameMap.put(XKU.id_kp_ipsecTunnel, "IP security tunnel termination");
            oidNameMap.put(XKU.id_kp_ipsecUser, "IP security user");
            oidNameMap.put(XKU.id_kp_kerberosClientAuthentication, "Kerberos Client Authentication");
            oidNameMap.put(XKU.id_kp_kerberosKdc, "Kerberos Key Distribution Center");
            oidNameMap.put(XKU.id_kp_microsoftCommercialCodeSigning, "Microsoft Commercial Code Signing");
            oidNameMap.put(XKU.id_kp_microsoftDocumentSigning, "Microsoft Document Signing");
            oidNameMap.put(XKU.id_kp_microsoftEfs, "Microsoft Encrypted File System");
            oidNameMap.put(XKU.id_kp_microsoftEfsRecovery, "Microsoft EFS Recovery");
            oidNameMap.put(XKU.id_kp_microsoftIndividualCodeSigning, "Microsoft Individual Code Signing");
            oidNameMap.put(XKU.id_kp_microsoftSmartCardLogon, "Microsoft Smart Card Logon");
            oidNameMap.put(XKU.id_kp_ocspSigning, "Signing OCSP responses");
            oidNameMap.put(XKU.id_kp_pivCardAuthentication, "PIV Card Authentication");
            oidNameMap.put(XKU.id_kp_pdfSigning, "PDF Signing");
            oidNameMap.put(XKU.id_kp_scvpClient, "SCVP Client");
            oidNameMap.put(XKU.id_kp_scvpServer, "SCVP Server");
            oidNameMap.put(XKU.id_kp_serverAuth, "TLS WWW server authentication");
            oidNameMap.put(XKU.id_kp_sipDomain, "SIP Domain");
            oidNameMap.put(XKU.id_kp_sshClient, "SSH Client");
            oidNameMap.put(XKU.id_kp_sshServer, "SSH Server");
            oidNameMap.put(XKU.id_kp_timeStamping, "TimeStamping");
            oidNameMap.put(XKU.id_kp_appleSafariExtensionSigning, "Apple Safari Extension Signing");
            oidNameMap.put(XKU.id_kp_macInstallerPackageSigning, "Apple Mac Installer Package Signing");
            oidNameMap.put(XKU.id_kp_macAppStoreInstallerPackageSigning, "Apple Mac AppStore Installer Package Signing");
            oidNameMap.put(EdECConstants.id_ED25519, "ED25519");
            oidNameMap.put(EdECConstants.id_ED448, "ED448");
            oidNameMap.put(EdECConstants.id_X25519, "X25519");
            oidNameMap.put(EdECConstants.id_X448, "X448");
        }
    }

    public static final class Misc {
        public static final ASN1ObjectIdentifier id_iso18033_kdf2 = new ASN1ObjectIdentifier("1.0.18033.2.5.2");
    }

    public static final class Secg {
        private static final ASN1ObjectIdentifier id_secg_scheme = new ASN1ObjectIdentifier("1.3.132.1");
        public static final ASN1ObjectIdentifier id_aes128_cbc_in_ecies = id_secg_scheme.branch("20.0");
        public static final ASN1ObjectIdentifier id_ecies_specifiedParameters = id_secg_scheme.branch("8");
        public static final ASN1ObjectIdentifier id_hmac_full_ecies = id_secg_scheme.branch("22");
    }

    public static final class Extn {
        public static final ASN1ObjectIdentifier id_pkix_ocsp_prefSigAlgs = OCSPObjectIdentifiers.id_pkix_ocsp.branch("8");
        public static final ASN1ObjectIdentifier id_pkix_ocsp_extendedRevoke = OCSPObjectIdentifiers.id_pkix_ocsp.branch("9");
        public static final ASN1ObjectIdentifier id_extension_pkix_ocsp_nocheck = ObjectIdentifiers.access$300().branch("48.1.5");
        public static final ASN1ObjectIdentifier id_extension_restriction = new ASN1ObjectIdentifier("1.3.36.8.3.8");
        public static final ASN1ObjectIdentifier id_extension_additionalInformation = new ASN1ObjectIdentifier("1.3.36.8.3.15");
        public static final ASN1ObjectIdentifier id_extension_validityModel = new ASN1ObjectIdentifier("1.3.6.1.4.1.8301.3.5");
        public static final ASN1ObjectIdentifier id_extension_admission = new ASN1ObjectIdentifier("1.3.36.8.3.3");
        private static final ASN1ObjectIdentifier id_ad = ObjectIdentifiers.access$300().branch("48");
        public static final ASN1ObjectIdentifier id_ad_timeStamping = id_ad.branch("3");
        public static final ASN1ObjectIdentifier id_ad_caRepository = id_ad.branch("5");
        private static final ASN1ObjectIdentifier id_qcs = ObjectIdentifiers.access$300().branch("11");
        public static final ASN1ObjectIdentifier id_qcs_pkixQCSyntax_v1 = id_qcs.branch("1");
        public static final ASN1ObjectIdentifier id_qcs_pkixQCSyntax_v2 = id_qcs.branch("2");
        private static final ASN1ObjectIdentifier id_etsi_qcs = new ASN1ObjectIdentifier("0.4.0.1862.1");
        public static final ASN1ObjectIdentifier id_etsi_qcs_QcCompliance = id_etsi_qcs.branch("1");
        public static final ASN1ObjectIdentifier id_etsi_qcs_QcLimitValue = id_etsi_qcs.branch("2");
        public static final ASN1ObjectIdentifier id_etsi_qcs_QcRetentionPeriod = id_etsi_qcs.branch("3");
        public static final ASN1ObjectIdentifier id_etsi_qcs_QcSSCD = id_etsi_qcs.branch("4");
        public static final ASN1ObjectIdentifier id_etsi_qcs_QcPDS = id_etsi_qcs.branch("5");
        private static final ASN1ObjectIdentifier id_pe = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.1");
        public static final ASN1ObjectIdentifier id_pe_tlsfeature = id_pe.branch("24");
        public static final ASN1ObjectIdentifier id_smimeCapabilities = new ASN1ObjectIdentifier("1.2.840.113549.1.9.15");
        public static final ASN1ObjectIdentifier id_GMT_0015_IdentityCode = new ASN1ObjectIdentifier("1.2.156.10260.4.1.1");
        public static final ASN1ObjectIdentifier id_GMT_0015_InsuranceNumber = new ASN1ObjectIdentifier("1.2.156.10260.4.1.2");
        public static final ASN1ObjectIdentifier id_GMT_0015_ICRegistrationNumber = new ASN1ObjectIdentifier("1.2.156.10260.4.1.3");
        public static final ASN1ObjectIdentifier id_GMT_0015_OrganizationCode = new ASN1ObjectIdentifier("1.2.156.10260.4.1.4");
        public static final ASN1ObjectIdentifier id_GMT_0015_TaxationNumber = new ASN1ObjectIdentifier("1.2.156.10260.4.1.5");
        public static final ASN1ObjectIdentifier id_precertificate = new ASN1ObjectIdentifier("1.3.6.1.4.1.11129.2.4.3");
        public static final ASN1ObjectIdentifier id_SCTs = new ASN1ObjectIdentifier("1.3.6.1.4.1.11129.2.4.2");
    }

    public static final class XKU {
        public static final ASN1ObjectIdentifier id_kp_anyExtendedKeyUsage = Extension.extendedKeyUsage.branch("0");
        private static final ASN1ObjectIdentifier id_kp = ObjectIdentifiers.access$300().branch("3");
        public static final ASN1ObjectIdentifier id_kp_clientAuth = id_kp.branch("2");
        public static final ASN1ObjectIdentifier id_kp_codeSigning = id_kp.branch("3");
        public static final ASN1ObjectIdentifier id_kp_csn369791TlsClient = new ASN1ObjectIdentifier("1.2.203.7064.1.1.369791.1");
        public static final ASN1ObjectIdentifier id_kp_csn369791TlsServer = new ASN1ObjectIdentifier("1.2.203.7064.1.1.369791.2");
        public static final ASN1ObjectIdentifier id_kp_eapOverLan = id_kp.branch("14");
        public static final ASN1ObjectIdentifier id_kp_eapOverPpp = id_kp.branch("13");
        public static final ASN1ObjectIdentifier id_kp_emailProtection = id_kp.branch("4");
        public static final ASN1ObjectIdentifier id_kp_etsiTslSigning = new ASN1ObjectIdentifier("0.4.0.2231.3.0");
        public static final ASN1ObjectIdentifier id_kp_icaoMasterListSigning = new ASN1ObjectIdentifier("2.23.136.1.1.3");
        public static final ASN1ObjectIdentifier id_kp_ikeForIpsec = id_kp.branch("17");
        public static final ASN1ObjectIdentifier id_kp_intelAmtManagement = new ASN1ObjectIdentifier("2.16.840.1.113741.1.2.3");
        public static final ASN1ObjectIdentifier id_kp_ipsecEndSystem = id_kp.branch("5");
        public static final ASN1ObjectIdentifier id_kp_ipsecTunnel = id_kp.branch("6");
        public static final ASN1ObjectIdentifier id_kp_ipsecUser = id_kp.branch("7");
        public static final ASN1ObjectIdentifier id_kp_kerberosClientAuthentication = new ASN1ObjectIdentifier("1.3.6.1.5.2.3.4");
        public static final ASN1ObjectIdentifier id_kp_kerberosKdc = new ASN1ObjectIdentifier("1.3.6.1.5.2.3.5");
        public static final ASN1ObjectIdentifier id_kp_microsoftCommercialCodeSigning = ObjectIdentifiers.access$200().branch("2.1.22");
        public static final ASN1ObjectIdentifier id_kp_microsoftDocumentSigning = ObjectIdentifiers.access$200().branch("10.3.12");
        public static final ASN1ObjectIdentifier id_kp_microsoftEfs = ObjectIdentifiers.access$200().branch("10.3.4");
        public static final ASN1ObjectIdentifier id_kp_microsoftEfsRecovery = ObjectIdentifiers.access$200().branch("10.3.4.1");
        public static final ASN1ObjectIdentifier id_kp_microsoftIndividualCodeSigning = ObjectIdentifiers.access$200().branch("2.1.21");
        public static final ASN1ObjectIdentifier id_kp_microsoftSmartCardLogon = ObjectIdentifiers.access$200().branch("20.2.2");
        public static final ASN1ObjectIdentifier id_kp_ocspSigning = id_kp.branch("9");
        public static final ASN1ObjectIdentifier id_kp_pivCardAuthentication = new ASN1ObjectIdentifier("2.16.840.1.101.3.6.8");
        public static final ASN1ObjectIdentifier id_kp_pdfSigning = new ASN1ObjectIdentifier("1.2.840.113583.1.1.5");
        public static final ASN1ObjectIdentifier id_kp_scvpClient = id_kp.branch("16");
        public static final ASN1ObjectIdentifier id_kp_scvpServer = id_kp.branch("15");
        public static final ASN1ObjectIdentifier id_kp_serverAuth = id_kp.branch("1");
        public static final ASN1ObjectIdentifier id_kp_sipDomain = id_kp.branch("20");
        public static final ASN1ObjectIdentifier id_kp_sshClient = id_kp.branch("21");
        public static final ASN1ObjectIdentifier id_kp_sshServer = id_kp.branch("22");
        public static final ASN1ObjectIdentifier id_kp_timeStamping = id_kp.branch("8");
        private static final ASN1ObjectIdentifier id_appleExtendedKeyUsage = new ASN1ObjectIdentifier("1.2.840.113635.100.4");
        public static final ASN1ObjectIdentifier id_kp_appleSafariExtensionSigning = id_appleExtendedKeyUsage.branch("8");
        public static final ASN1ObjectIdentifier id_kp_macInstallerPackageSigning = id_appleExtendedKeyUsage.branch("9");
        public static final ASN1ObjectIdentifier id_kp_macAppStoreInstallerPackageSigning = id_appleExtendedKeyUsage.branch("10");
        public static final ASN1ObjectIdentifier id_kp_certificateTransparency = new ASN1ObjectIdentifier("1.3.6.1.4.1.11129.2.4.4");
    }

    public static class DN {
        public static final ASN1ObjectIdentifier C = new ASN1ObjectIdentifier("2.5.4.6");
        public static final ASN1ObjectIdentifier O = new ASN1ObjectIdentifier("2.5.4.10");
        public static final ASN1ObjectIdentifier organizationIdentifier = new ASN1ObjectIdentifier("2.5.4.97");
        public static final ASN1ObjectIdentifier OU = new ASN1ObjectIdentifier("2.5.4.11");
        public static final ASN1ObjectIdentifier T = new ASN1ObjectIdentifier("2.5.4.12");
        public static final ASN1ObjectIdentifier CN = new ASN1ObjectIdentifier("2.5.4.3");
        public static final ASN1ObjectIdentifier SN = new ASN1ObjectIdentifier("2.5.4.5");
        public static final ASN1ObjectIdentifier street = new ASN1ObjectIdentifier("2.5.4.9");
        public static final ASN1ObjectIdentifier serialNumber = SN;
        public static final ASN1ObjectIdentifier L;
        public static final ASN1ObjectIdentifier localityName;
        public static final ASN1ObjectIdentifier ST;
        public static final ASN1ObjectIdentifier surname;
        public static final ASN1ObjectIdentifier givenName;
        public static final ASN1ObjectIdentifier initials;
        public static final ASN1ObjectIdentifier generation;
        public static final ASN1ObjectIdentifier generationQualifier;
        public static final ASN1ObjectIdentifier uniqueIdentifier;
        public static final ASN1ObjectIdentifier businessCategory;
        public static final ASN1ObjectIdentifier postalCode;
        public static final ASN1ObjectIdentifier dnQualifier;
        public static final ASN1ObjectIdentifier pseudonym;
        public static final ASN1ObjectIdentifier dateOfBirth;
        public static final ASN1ObjectIdentifier placeOfBirth;
        public static final ASN1ObjectIdentifier gender;
        public static final ASN1ObjectIdentifier countryOfCitizenship;
        public static final ASN1ObjectIdentifier countryOfResidence;
        public static final ASN1ObjectIdentifier nameAtBirth;
        public static final ASN1ObjectIdentifier postalAddress;
        public static final ASN1ObjectIdentifier dmdName;
        public static final ASN1ObjectIdentifier telephoneNumber;
        public static final ASN1ObjectIdentifier name;
        public static final ASN1ObjectIdentifier emailAddress;
        public static final ASN1ObjectIdentifier unstructuredName;
        public static final ASN1ObjectIdentifier unstructuredAddress;
        public static final ASN1ObjectIdentifier E;
        public static final ASN1ObjectIdentifier DC;
        public static final ASN1ObjectIdentifier userid;
        public static final ASN1ObjectIdentifier UID;
        public static final ASN1ObjectIdentifier NIF;
        public static final ASN1ObjectIdentifier CIF;
        public static final ASN1ObjectIdentifier jurisdictionOfIncorporationLocalityName;
        public static final ASN1ObjectIdentifier jurisdictionOfIncorporationStateOrProvinceName;
        public static final ASN1ObjectIdentifier jurisdictionOfIncorporationCountryName;

        static {
            localityName = L = new ASN1ObjectIdentifier("2.5.4.7");
            ST = new ASN1ObjectIdentifier("2.5.4.8");
            surname = new ASN1ObjectIdentifier("2.5.4.4");
            givenName = new ASN1ObjectIdentifier("2.5.4.42");
            initials = new ASN1ObjectIdentifier("2.5.4.43");
            generationQualifier = generation = new ASN1ObjectIdentifier("2.5.4.44");
            uniqueIdentifier = new ASN1ObjectIdentifier("2.5.4.45");
            businessCategory = new ASN1ObjectIdentifier("2.5.4.15");
            postalCode = new ASN1ObjectIdentifier("2.5.4.17");
            dnQualifier = new ASN1ObjectIdentifier("2.5.4.46");
            pseudonym = new ASN1ObjectIdentifier("2.5.4.65");
            dateOfBirth = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.1");
            placeOfBirth = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.2");
            gender = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.3");
            countryOfCitizenship = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.4");
            countryOfResidence = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.5");
            nameAtBirth = new ASN1ObjectIdentifier("1.3.36.8.3.14");
            postalAddress = new ASN1ObjectIdentifier("2.5.4.16");
            dmdName = new ASN1ObjectIdentifier("2.5.4.54");
            telephoneNumber = X509ObjectIdentifiers.id_at_telephoneNumber;
            name = X509ObjectIdentifiers.id_at_name;
            emailAddress = PKCSObjectIdentifiers.pkcs_9_at_emailAddress;
            unstructuredName = PKCSObjectIdentifiers.pkcs_9_at_unstructuredName;
            unstructuredAddress = PKCSObjectIdentifiers.pkcs_9_at_unstructuredAddress;
            E = emailAddress;
            DC = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.25");
            UID = userid = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.1");
            NIF = id_pen.branch("18838.1.1");
            CIF = id_pen.branch("4710.1.3.2");
            jurisdictionOfIncorporationLocalityName = id_microsoft.branch("60.2.1.1");
            jurisdictionOfIncorporationStateOrProvinceName = id_microsoft.branch("60.2.1.2");
            jurisdictionOfIncorporationCountryName = id_microsoft.branch("60.2.1.3");
        }
    }

    public static class BaseRequirements {
        public static final ASN1ObjectIdentifier id_domain_validated = new ASN1ObjectIdentifier("2.23.140.1.2.1");
        public static final ASN1ObjectIdentifier id_organization_validated = new ASN1ObjectIdentifier("2.23.140.1.2.2");
        public static final ASN1ObjectIdentifier id_individual_validated = new ASN1ObjectIdentifier("2.23.140.1.2.3");
    }

    public static final class Xipki {
        private static final ASN1ObjectIdentifier id_xipki_cmp = ObjectIdentifiers.access$000().branch("2");
        public static final ASN1ObjectIdentifier id_xipki_cmp_cmpGenmsg = id_xipki_cmp.branch("1");
        private static final ASN1ObjectIdentifier id_xipki_alg = ObjectIdentifiers.access$000().branch("3");
        public static final ASN1ObjectIdentifier id_alg_dhPop_x25519 = id_xipki_alg.branch("1");
        public static final ASN1ObjectIdentifier id_alg_dhPop_x448 = id_xipki_alg.branch("2");
    }
}

