/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.bc;

import java.security.NoSuchAlgorithmException;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcRSAContentVerifierProviderBuilder;
import org.xipki.security.SignAlgo;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.SignerUtil;

public class XiRSAContentVerifierProviderBuilder
extends BcRSAContentVerifierProviderBuilder {
    private static final DigestAlgorithmIdentifierFinder digestAlgorithmFinder = new DefaultDigestAlgorithmIdentifierFinder();

    public XiRSAContentVerifierProviderBuilder() {
        super(digestAlgorithmFinder);
    }

    protected Signer createSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        SignAlgo signAlgo;
        try {
            signAlgo = SignAlgo.getInstance(sigAlgId);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new OperatorCreationException(ex.getMessage(), (Throwable)ex);
        }
        if (signAlgo.isRSAPSSSigAlgo()) {
            try {
                return SignerUtil.createPSSRSASigner(signAlgo);
            }
            catch (XiSecurityException ex) {
                throw new OperatorCreationException(ex.getMessage(), (Throwable)ex);
            }
        }
        AlgorithmIdentifier digAlg = digestAlgorithmFinder.find(sigAlgId);
        return new RSADigestSigner((Digest)this.digestProvider.get(digAlg));
    }
}

