/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs12;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.EdECConstants;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.SignerConf;
import org.xipki.security.SignerFactory;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs12.KeypairWithCert;
import org.xipki.security.pkcs12.P12ContentSignerBuilder;
import org.xipki.security.pkcs12.P12MacContentSignerBuilder;
import org.xipki.security.pkcs12.P12XdhMacContentSignerBuilder;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.StringUtil;

public class P12SignerFactory
implements SignerFactory {
    private static final String TYPE_PKCS12 = "pkcs12";
    private static final String TYPE_JCEKS = "jceks";
    private static final Set<String> types = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("pkcs12", "jceks")));
    private SecurityFactory securityFactory;

    public void setSecurityFactory(SecurityFactory securityFactory) {
        this.securityFactory = securityFactory;
    }

    @Override
    public Set<String> getSupportedSignerTypes() {
        return types;
    }

    @Override
    public boolean canCreateSigner(String type) {
        return types.contains(type.toLowerCase());
    }

    @Override
    public ConcurrentContentSigner newSigner(String type, SignerConf conf, X509Cert[] certificateChain) throws ObjectCreationException {
        char[] password;
        String passwordHint;
        if (!this.canCreateSigner(type)) {
            throw new ObjectCreationException("unknown signer type " + type);
        }
        String str = conf.getConfValue("parallelism");
        int parallelism = this.securityFactory.getDfltSignerParallelism();
        if (str != null) {
            try {
                parallelism = Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                throw new ObjectCreationException("invalid parallelism " + str);
            }
            if (parallelism < 1) {
                throw new ObjectCreationException("invalid parallelism " + str);
            }
        }
        if ((passwordHint = conf.getConfValue("password")) == null) {
            password = null;
        } else {
            PasswordResolver passwordResolver = this.securityFactory.getPasswordResolver();
            if (passwordResolver == null) {
                password = passwordHint.toCharArray();
            } else {
                try {
                    password = passwordResolver.resolvePassword(passwordHint);
                }
                catch (PasswordResolverException ex) {
                    throw new ObjectCreationException("could not resolve password. Message: " + ex.getMessage());
                }
            }
        }
        str = conf.getConfValue("keystore");
        String keyLabel = conf.getConfValue("key-label");
        InputStream keystoreStream = P12SignerFactory.getInputStream(str);
        try {
            SignAlgo sigAlgo = null;
            String algoName = conf.getConfValue("algo");
            if (algoName != null) {
                sigAlgo = SignAlgo.getInstance(algoName);
            }
            if (sigAlgo != null && sigAlgo.isMac()) {
                P12MacContentSignerBuilder signerBuilder = new P12MacContentSignerBuilder(type, keystoreStream, password, keyLabel, password);
                return signerBuilder.createSigner(sigAlgo, parallelism);
            }
            KeypairWithCert keypairWithCert = KeypairWithCert.fromKeystore(type, keystoreStream, password, keyLabel, password, certificateChain);
            String publicKeyAlg = keypairWithCert.getPublicKey().getAlgorithm();
            ASN1ObjectIdentifier curveOid = EdECConstants.getCurveOid(publicKeyAlg);
            if (curveOid != null && EdECConstants.isMontgomeryCurve(curveOid)) {
                X509Cert peerCert = null;
                List<X509Cert> peerCerts = conf.getPeerCertificates();
                if (peerCerts != null) {
                    for (X509Cert m : conf.getPeerCertificates()) {
                        if (!publicKeyAlg.equalsIgnoreCase(m.getPublicKey().getAlgorithm())) continue;
                        peerCert = m;
                        break;
                    }
                }
                if (peerCert == null) {
                    throw new ObjectCreationException("could not find peer certificate for algorithm " + publicKeyAlg);
                }
                P12XdhMacContentSignerBuilder signerBuilder = new P12XdhMacContentSignerBuilder(keypairWithCert, peerCert);
                return signerBuilder.createSigner(parallelism);
            }
            P12ContentSignerBuilder signerBuilder = new P12ContentSignerBuilder(keypairWithCert);
            if (sigAlgo == null) {
                PublicKey pubKey = signerBuilder.getCertificate().getPublicKey();
                sigAlgo = SignAlgo.getInstance(pubKey, conf);
            }
            return signerBuilder.createSigner(sigAlgo, parallelism, this.securityFactory.getRandom4Sign());
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException | XiSecurityException ex) {
            throw new ObjectCreationException(String.format("%s: %s", ex.getClass().getName(), ex.getMessage()));
        }
    }

    @Override
    public void refreshToken(String type) {
    }

    private static InputStream getInputStream(String str) throws ObjectCreationException {
        if (StringUtil.startsWithIgnoreCase((String)str, (String)"base64:")) {
            return new ByteArrayInputStream(Base64.decode((String)str.substring("base64:".length())));
        }
        if (StringUtil.startsWithIgnoreCase((String)str, (String)"file:")) {
            String fn = str.substring("file:".length());
            try {
                return Files.newInputStream(Paths.get(IoUtil.detectPath((String)fn), new String[0]), new OpenOption[0]);
            }
            catch (IOException ex) {
                throw new ObjectCreationException("file not found: " + fn);
            }
        }
        throw new ObjectCreationException("unknown content format");
    }
}

