/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.util;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.Xof;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import org.bouncycastle.operator.bc.BcDSAContentVerifierProviderBuilder;
import org.xipki.security.DHSigStaticKeyCertPair;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;
import org.xipki.security.XiSecurityException;
import org.xipki.security.bc.XiECContentVerifierProviderBuilder;
import org.xipki.security.bc.XiEdDSAContentVerifierProvider;
import org.xipki.security.bc.XiRSAContentVerifierProviderBuilder;
import org.xipki.security.bc.XiXDHContentVerifierProvider;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.Args;
import org.xipki.util.Hex;

public class SignerUtil {
    private static final Map<HashAlgo, byte[]> digestPkcsPrefix = new HashMap<HashAlgo, byte[]>();
    private static final DigestAlgorithmIdentifierFinder DIGESTALG_IDENTIFIER_FINDER = new DefaultDigestAlgorithmIdentifierFinder();
    private static final Map<String, BcContentVerifierProviderBuilder> VERIFIER_PROVIDER_BUILDER = new HashMap<String, BcContentVerifierProviderBuilder>();

    private static void addDigestPkcsPrefix(HashAlgo algo, String prefix) {
        digestPkcsPrefix.put(algo, Hex.decode((String)prefix));
    }

    private SignerUtil() {
    }

    public static RSAKeyParameters generateRSAPrivateKeyParameter(RSAPrivateKey key) {
        Args.notNull((Object)key, (String)"key");
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsaKey = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeyParameters(rsaKey.getModulus(), rsaKey.getPublicExponent(), rsaKey.getPrivateExponent(), rsaKey.getPrimeP(), rsaKey.getPrimeQ(), rsaKey.getPrimeExponentP(), rsaKey.getPrimeExponentQ(), rsaKey.getCrtCoefficient());
        }
        return new RSAKeyParameters(true, key.getModulus(), key.getPrivateExponent());
    }

    public static Signer createPSSRSASigner(SignAlgo sigAlgo) throws XiSecurityException {
        return SignerUtil.createPSSRSASigner(sigAlgo, null);
    }

    public static Signer createPSSRSASigner(SignAlgo sigAlgo, AsymmetricBlockCipher cipher) throws XiSecurityException {
        Args.notNull((Object)((Object)sigAlgo), (String)"sigAlgo");
        if (!sigAlgo.isRSAPSSSigAlgo()) {
            throw new XiSecurityException((Object)((Object)sigAlgo) + " is not an RSAPSS algorithm");
        }
        HashAlgo hashAlgo = sigAlgo.getHashAlgo();
        AsymmetricBlockCipher tmpCipher = cipher == null ? new RSABlindedEngine() : cipher;
        ExtendedDigest dig = hashAlgo.createDigest();
        ExtendedDigest mgfDig = hashAlgo.createDigest();
        return new PSSSigner(tmpCipher, (Digest)dig, (Digest)mgfDig, hashAlgo.getLength(), -68);
    }

    public static byte[] EMSA_PKCS1_v1_5_encoding(byte[] hashValue, int modulusBigLength, HashAlgo hashAlgo) throws XiSecurityException {
        Args.notNull((Object)hashValue, (String)"hashValue");
        Args.notNull((Object)((Object)hashAlgo), (String)"hashAlgo");
        int hashLen = hashAlgo.getLength();
        Args.range((int)hashValue.length, (String)"hashValue.length", (int)hashLen, (int)hashLen);
        int blockSize = (modulusBigLength + 7) / 8;
        byte[] prefix = digestPkcsPrefix.get((Object)hashAlgo);
        if (prefix.length + hashLen + 3 > blockSize) {
            throw new XiSecurityException("data too long (maximal " + (blockSize - 3) + " allowed): " + (prefix.length + hashLen));
        }
        byte[] block = new byte[blockSize];
        block[0] = 0;
        block[1] = 1;
        int offset = 2;
        while (offset < block.length - prefix.length - hashLen - 1) {
            block[offset++] = -1;
        }
        block[offset++] = 0;
        System.arraycopy(prefix, 0, block, offset, prefix.length);
        System.arraycopy(hashValue, 0, block, offset += prefix.length, hashValue.length);
        return block;
    }

    public static byte[] EMSA_PKCS1_v1_5_encoding(byte[] encodedDigestInfo, int modulusBigLength) throws XiSecurityException {
        Args.notNull((Object)encodedDigestInfo, (String)"encodedDigestInfo");
        int msgLen = encodedDigestInfo.length;
        int blockSize = (modulusBigLength + 7) / 8;
        if (msgLen + 3 > blockSize) {
            throw new XiSecurityException("data too long (maximal " + (blockSize - 3) + " allowed): " + msgLen);
        }
        byte[] block = new byte[blockSize];
        block[0] = 0;
        block[1] = 1;
        int offset = 2;
        while (offset < block.length - msgLen - 1) {
            block[offset++] = -1;
        }
        block[offset++] = 0;
        System.arraycopy(encodedDigestInfo, 0, block, offset, encodedDigestInfo.length);
        return block;
    }

    public static byte[] EMSA_PSS_ENCODE(HashAlgo contentDigest, byte[] hashValue, HashAlgo mgfDigest, int saltLen, int modulusBitLength, SecureRandom random) throws XiSecurityException {
        byte[] dbMask;
        switch (contentDigest) {
            case SHAKE128: 
            case SHAKE256: {
                if (mgfDigest != contentDigest) {
                    throw new XiSecurityException("contentDigest != mgfDigest");
                }
                if (saltLen == contentDigest.getLength()) break;
                throw new XiSecurityException("saltLen != " + contentDigest.getLength() + ": " + saltLen);
            }
        }
        int hLen = contentDigest.getLength();
        byte[] salt = new byte[saltLen];
        byte[] mDash = new byte[8 + saltLen + hLen];
        int trailer = -68;
        if (hashValue.length != hLen) {
            throw new XiSecurityException("hashValue.length is incorrect: " + hashValue.length + " != " + hLen);
        }
        int emBits = modulusBitLength - 1;
        if (emBits < 8 * hLen + 8 * saltLen + 9) {
            throw new IllegalArgumentException("key too small for specified hash and salt lengths");
        }
        System.arraycopy(hashValue, 0, mDash, mDash.length - hLen - saltLen, hLen);
        random.nextBytes(salt);
        System.arraycopy(salt, 0, mDash, mDash.length - saltLen, saltLen);
        byte[] hv = contentDigest.hash(new byte[][]{mDash});
        byte[] block = new byte[(emBits + 7) / 8];
        block[block.length - saltLen - 1 - hLen - 1] = 1;
        System.arraycopy(salt, 0, block, block.length - saltLen - hLen - 1, saltLen);
        int dbMaskLen = block.length - hLen - 1;
        switch (contentDigest) {
            case SHAKE128: 
            case SHAKE256: {
                Xof xof = (Xof)contentDigest.createDigest();
                xof.update(hv, 0, hv.length);
                dbMask = new byte[dbMaskLen];
                xof.doFinal(dbMask, 0, dbMaskLen);
                break;
            }
            default: {
                dbMask = SignerUtil.maskGeneratorFunction1(mgfDigest, hv, dbMaskLen);
            }
        }
        for (int i = 0; i != dbMask.length; ++i) {
            int n = i;
            block[n] = (byte)(block[n] ^ dbMask[i]);
        }
        block[0] = (byte)(block[0] & 255 >> block.length * 8 - emBits);
        System.arraycopy(hv, 0, block, block.length - hLen - 1, hLen);
        block[block.length - 1] = -68;
        return block;
    }

    private static void ItoOSP(int i, byte[] sp, int spOffset) {
        sp[spOffset] = (byte)(i >>> 24);
        sp[spOffset + 1] = (byte)(i >>> 16);
        sp[spOffset + 2] = (byte)(i >>> 8);
        sp[spOffset + 3] = (byte)i;
    }

    private static byte[] maskGeneratorFunction1(HashAlgo mgfDigest, byte[] Z, int length) {
        byte[] hashBuf;
        int counter;
        int mgfhLen = mgfDigest.getLength();
        byte[] mask = new byte[length];
        byte[] all = new byte[Z.length + 4];
        System.arraycopy(Z, 0, all, 0, Z.length);
        for (counter = 0; counter < length / mgfhLen; ++counter) {
            SignerUtil.ItoOSP(counter, all, Z.length);
            hashBuf = mgfDigest.hash(new byte[][]{all});
            System.arraycopy(hashBuf, 0, mask, counter * mgfhLen, mgfhLen);
        }
        if (counter * mgfhLen < length) {
            SignerUtil.ItoOSP(counter, all, Z.length);
            hashBuf = mgfDigest.hash(new byte[][]{all});
            int offset = counter * mgfhLen;
            System.arraycopy(hashBuf, 0, mask, offset, mask.length - offset);
        }
        return mask;
    }

    public static byte[] dsaSigPlainToX962(byte[] signature) throws XiSecurityException {
        Args.notNull((Object)signature, (String)"signature");
        if (signature.length % 2 != 0) {
            throw new XiSecurityException("signature.lenth must be even, but is odd");
        }
        byte[] ba = new byte[signature.length / 2];
        ASN1EncodableVector sigder = new ASN1EncodableVector();
        System.arraycopy(signature, 0, ba, 0, ba.length);
        sigder.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, ba)));
        System.arraycopy(signature, ba.length, ba, 0, ba.length);
        sigder.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, ba)));
        DERSequence seq = new DERSequence(sigder);
        try {
            return seq.getEncoded();
        }
        catch (IOException ex) {
            throw new XiSecurityException("IOException, message: " + ex.getMessage(), ex);
        }
    }

    public static byte[] dsaSigX962ToPlain(byte[] x962Signature, int keyBitLen) throws XiSecurityException {
        Args.notNull((Object)x962Signature, (String)"x962Signature");
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)x962Signature);
        if (seq.size() != 2) {
            throw new IllegalArgumentException("invalid X962Signature");
        }
        BigInteger sigR = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getPositiveValue();
        BigInteger sigS = ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getPositiveValue();
        return SignerUtil.dsaSigToPlain(sigR, sigS, keyBitLen);
    }

    public static byte[] dsaSigToPlain(BigInteger sigR, BigInteger sigS, int keyBitLen) throws XiSecurityException {
        Args.notNull((Object)sigR, (String)"sigR");
        Args.notNull((Object)sigS, (String)"sigS");
        int blockSize = (keyBitLen + 7) / 8;
        int bitLenOfR = sigR.bitLength();
        int bitLenOfS = sigS.bitLength();
        int bitLen = Math.max(bitLenOfR, bitLenOfS);
        if ((bitLen + 7) / 8 > blockSize) {
            throw new XiSecurityException("signature is too large");
        }
        byte[] plainSignature = new byte[2 * blockSize];
        SignerUtil.bigIntToBytes(sigR, plainSignature, 0, blockSize);
        SignerUtil.bigIntToBytes(sigS, plainSignature, blockSize, blockSize);
        return plainSignature;
    }

    private static void bigIntToBytes(BigInteger num, byte[] dest, int destPos, int length) {
        byte[] bytes = num.toByteArray();
        if (bytes.length == length) {
            System.arraycopy(bytes, 0, dest, destPos, length);
        } else if (bytes.length < length) {
            System.arraycopy(bytes, 0, dest, destPos + length - bytes.length, bytes.length);
        } else {
            System.arraycopy(bytes, bytes.length - length, dest, destPos, length);
        }
    }

    public static byte[] getDigestPkcsPrefix(HashAlgo hashAlgo) {
        byte[] bytes = digestPkcsPrefix.get((Object)hashAlgo);
        return bytes == null ? null : Arrays.copyOf(bytes, bytes.length);
    }

    public static ContentVerifierProvider getContentVerifierProvider(PublicKey publicKey, DHSigStaticKeyCertPair ownerKeyAndCert) throws InvalidKeyException {
        Args.notNull((Object)publicKey, (String)"publicKey");
        String keyAlg = publicKey.getAlgorithm().toUpperCase();
        if ("ED25519".equals(keyAlg) || "ED448".equals(keyAlg)) {
            return new XiEdDSAContentVerifierProvider(publicKey);
        }
        if ("X25519".equals(keyAlg) || "X448".equals(keyAlg)) {
            if (ownerKeyAndCert == null) {
                throw new InvalidKeyException("ownerKeyAndCert is required but absent");
            }
            return new XiXDHContentVerifierProvider(publicKey, ownerKeyAndCert);
        }
        Object builder = VERIFIER_PROVIDER_BUILDER.get(keyAlg);
        if (builder == null) {
            switch (keyAlg) {
                case "RSA": {
                    builder = new XiRSAContentVerifierProviderBuilder();
                    break;
                }
                case "DSA": {
                    builder = new BcDSAContentVerifierProviderBuilder(DIGESTALG_IDENTIFIER_FINDER);
                    break;
                }
                case "EC": 
                case "ECDSA": {
                    builder = new XiECContentVerifierProviderBuilder();
                    break;
                }
                default: {
                    throw new InvalidKeyException("unknown key algorithm of the public key " + keyAlg);
                }
            }
            VERIFIER_PROVIDER_BUILDER.put(keyAlg, (BcContentVerifierProviderBuilder)builder);
        }
        AsymmetricKeyParameter keyParam = KeyUtil.generatePublicKeyParameter(publicKey);
        try {
            return builder.build(keyParam);
        }
        catch (OperatorCreationException ex) {
            throw new InvalidKeyException("could not build ContentVerifierProvider: " + ex.getMessage(), ex);
        }
    }

    static {
        SignerUtil.addDigestPkcsPrefix(HashAlgo.SHA1, "3021300906052b0e03021a05000414");
        SignerUtil.addDigestPkcsPrefix(HashAlgo.SHA224, "302d300d06096086480165030402040500041c");
        SignerUtil.addDigestPkcsPrefix(HashAlgo.SHA256, "3031300d060960864801650304020105000420");
        SignerUtil.addDigestPkcsPrefix(HashAlgo.SHA384, "3041300d060960864801650304020205000430");
        SignerUtil.addDigestPkcsPrefix(HashAlgo.SHA512, "3051300d060960864801650304020305000440");
        SignerUtil.addDigestPkcsPrefix(HashAlgo.SHA3_224, "302d300d06096086480165030402070500041c");
        SignerUtil.addDigestPkcsPrefix(HashAlgo.SHA3_256, "3031300d060960864801650304020805000420");
        SignerUtil.addDigestPkcsPrefix(HashAlgo.SHA3_384, "3041300d060960864801650304020905000430");
        SignerUtil.addDigestPkcsPrefix(HashAlgo.SHA3_512, "3051300d060960864801650304020a05000440");
    }
}

